/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ACMovePlanElementStructure;
import com.arcway.planagent.planmodel.actions.ACTransferPlanElementStructure;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.actions.ConcatenatingActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.List;

public class TACreatePlanElementStructureByShortcutHandle
extends Transaction {
    private final IPMPlanRW destinationPlan;
    private final GeoVector translation;
    private final IPMPlanRW sourcePlan;
    private final GeoVector distanceToDestinationInTargetPlan;
    private final List peToMove;
    private ACTransferPlanElementStructure action;

    public TACreatePlanElementStructureByShortcutHandle(IPMPlanRW sourcePlan, GeoVector translation, IPMPlanRW destinationPlan, ActionParameters actionParameters, GeoVector distanceToDestinationInTargetPlan, List peToMove) {
        super(destinationPlan, TACreatePlanElementStructureByShortcutHandle.overrideBendingToBeActive(actionParameters));
        assert (sourcePlan != null) : "sourcePlan is null";
        assert (translation != null) : "translation is null";
        this.sourcePlan = sourcePlan;
        this.translation = translation;
        this.destinationPlan = destinationPlan;
        this.distanceToDestinationInTargetPlan = distanceToDestinationInTargetPlan;
        this.peToMove = peToMove;
        if (!TACreatePlanElementStructureByShortcutHandle.areAllPlanElementTypesSupported(sourcePlan, destinationPlan)) {
            this.setInvalid(new EXTransactionNotValidException("some or all plan element types are not supported"));
        }
    }

    private static ActionParameters overrideBendingToBeActive(ActionParameters actionParameters) {
        IRoutingParameters routingParameters = new IRoutingParameters(){

            @Override
            public boolean isBendingActive() {
                return true;
            }

            @Override
            public GeoVector getDistanceWhenFiguresAreMoved(IPMFigureRW movedFigure) {
                return null;
            }
        };
        return new ActionParameters(actionParameters.getAnchoringContext(), routingParameters);
    }

    public static boolean areAllPlanElementTypesSupported(IPMPlanRW sourcePlan, IPMPlanRW destinationPlan) {
        boolean allTypesAreSupported = true;
        int i = 0;
        while (i < sourcePlan.getPlanElementCount()) {
            allTypesAreSupported &= TACreatePlanElementStructureByShortcutHandle.isSupportedType(destinationPlan, sourcePlan.getPlanElementRW(i).getType());
            ++i;
        }
        return allTypesAreSupported;
    }

    public static boolean isSupportedType(IPMPlanRW plan, String planElementTypeID) {
        boolean typeIsSupported = false;
        String[] supportedTypes = plan.getSupportedPlanElementTypeIDs();
        int i = 0;
        while (!typeIsSupported && i < supportedTypes.length) {
            typeIsSupported = supportedTypes[i].equals(planElementTypeID);
            ++i;
        }
        return typeIsSupported;
    }

    @Override
    public ActionIterator getActionIterator() {
        PredeterminedActionIterator createActions = this.peToMove.size() > 0 ? new PredeterminedActionIterator(2) : new PredeterminedActionIterator(1);
        ACTransferPlanElementStructure peTransferStructureAction = new ACTransferPlanElementStructure(this.getActionContext(), this.sourcePlan, this.destinationPlan, this.translation);
        createActions.addAction(peTransferStructureAction);
        this.action = peTransferStructureAction;
        if (this.peToMove.size() > 0) {
            ACMovePlanElementStructure peMoveStructureAction = new ACMovePlanElementStructure(this.getActionContext(), this.peToMove, this.distanceToDestinationInTargetPlan, false);
            createActions.addAction(peMoveStructureAction);
        }
        ConcatenatingActionIterator actions = this.peToMove.size() > 0 ? new ConcatenatingActionIterator(2) : new ConcatenatingActionIterator(1);
        actions.addActionIterator(createActions);
        return actions;
    }

    public String toString() {
        return "TACreatePlanElementStructureAsCopy (source plan " + this.sourcePlan + ", Destination plan " + this.destinationPlan + ")";
    }

    public List getCreatedPlanElements() {
        return this.action.getCreatedPlanElements();
    }
}

