/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ACTransferPlanElementStructure;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.actions.ConcatenatingActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.List;

public class TACreatePlanElementStructureAsCopy
extends Transaction {
    private final IPMPlanRW destinationPlan;
    private final GeoVector translation;
    private final IPMPlanRW sourcePlan;
    private ACTransferPlanElementStructure action;

    public TACreatePlanElementStructureAsCopy(IPMPlanRW sourcePlan, GeoVector translation, IPMPlanRW destinationPlan, ActionParameters actionParameters) {
        super(destinationPlan, actionParameters);
        assert (sourcePlan != null) : "sourcePlan is null";
        assert (translation != null) : "translation is null";
        this.sourcePlan = sourcePlan;
        this.translation = translation;
        this.destinationPlan = destinationPlan;
        if (!TACreatePlanElementStructureAsCopy.areAllPlanElementsUnique(sourcePlan, destinationPlan)) {
            this.setInvalid(new EXTransactionNotValidException("some or all plan elements already exist on the target plan (duplicate UID)"));
            assert (false);
        }
        if (!TACreatePlanElementStructureAsCopy.areAllPlanElementTypesSupported(sourcePlan, destinationPlan)) {
            this.setInvalid(new EXTransactionNotValidException("some or all plan element types are not supported"));
        }
    }

    public static boolean areAllPlanElementTypesSupported(IPMPlanRW sourcePlan, IPMPlanRW destinationPlan) {
        boolean allTypesAreSupported = true;
        int i = 0;
        while (allTypesAreSupported && i < sourcePlan.getPlanElementCount()) {
            allTypesAreSupported &= TACreatePlanElementStructureAsCopy.isSupportedType(destinationPlan, sourcePlan.getPlanElementRW(i).getType());
            ++i;
        }
        return allTypesAreSupported;
    }

    private static boolean areAllPlanElementsUnique(IPMPlanRW sourcePlan, IPMPlanRW destinationPlan) {
        IPMPlanRW planWithManyElements;
        IPMPlanRW planWithSomeElements;
        boolean allPlanElementsAreUnique = true;
        if (sourcePlan.getPlanElementCount() > destinationPlan.getPlanElementCount()) {
            planWithSomeElements = destinationPlan;
            planWithManyElements = sourcePlan;
        } else {
            planWithSomeElements = sourcePlan;
            planWithManyElements = destinationPlan;
        }
        int i = 0;
        while (allPlanElementsAreUnique && i < planWithSomeElements.getPlanElementCount()) {
            allPlanElementsAreUnique &= planWithManyElements.getPlanElementRW(planWithSomeElements.getPlanElementRW(i).getUid()) == null;
            ++i;
        }
        return allPlanElementsAreUnique;
    }

    public static boolean isSupportedType(IPMPlanRW plan, String planElementTypeID) {
        boolean typeIsSupported = false;
        String[] supportedTypes = plan.getSupportedPlanElementTypeIDs();
        int i = 0;
        while (!typeIsSupported && i < supportedTypes.length) {
            typeIsSupported = supportedTypes[i].equals(planElementTypeID);
            ++i;
        }
        return typeIsSupported;
    }

    @Override
    public ActionIterator getActionIterator() {
        PredeterminedActionIterator createActions = new PredeterminedActionIterator(1);
        ACTransferPlanElementStructure peStructureAction = new ACTransferPlanElementStructure(this.getActionContext(), this.sourcePlan, this.destinationPlan, this.translation);
        createActions.addAction(peStructureAction);
        this.action = peStructureAction;
        ConcatenatingActionIterator actions = new ConcatenatingActionIterator(1);
        actions.addActionIterator(createActions);
        return actions;
    }

    public String toString() {
        return "TACreatePlanElementStructureAsCopy (source plan " + this.sourcePlan + ", Destination plan " + this.destinationPlan + ")";
    }

    public List getCreatedPlanElements() {
        return this.action.getCreatedPlanElements();
    }
}

