/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.transactions.ForceValidFiguresTransactionValidator;
import com.arcway.planagent.planmodel.transactions.Transaction;

public class ForceValidPointsTransactionValidator
extends ForceValidFiguresTransactionValidator {
    private final IPMPlanElementRO planElement;
    private final Point offset;

    public ForceValidPointsTransactionValidator(IPMPlanElementRO planElement, Point offset) {
        super(planElement);
        this.planElement = planElement;
        this.offset = offset;
    }

    @Override
    public boolean validateTransactionPost(Transaction transaction) {
        boolean planObjectsAreOk = true;
        planObjectsAreOk &= super.validateTransactionPost(transaction);
        int figureIdx = 0;
        while (planObjectsAreOk && figureIdx < this.planElement.getFigureCount()) {
            IPMFigureRO figure = this.planElement.getFigureRO(figureIdx);
            planObjectsAreOk &= this.areFigurePointPositionsValid(figure);
            ++figureIdx;
        }
        return planObjectsAreOk;
    }

    private boolean areFigurePointPositionsValid(IPMFigureRO figure) {
        IPMPointListRO points = figure.getPointListRO();
        int pointCount = points.getPointCount();
        Point[] pointArray = new Point[pointCount];
        int i = 0;
        while (i < pointCount) {
            IPMPointRO point = points.getPointRO(i);
            pointArray[i] = point.getPosition();
            ++i;
        }
        i = 0;
        while (i < pointCount) {
            Point pos = pointArray[i];
            int j = i + 1;
            while (j < pointCount) {
                double subtrahendy;
                double minuendy;
                double subtrahendx;
                double minuendx;
                double x1 = pos.x;
                double y1 = pos.y;
                double x2 = pointArray[j].x;
                double y2 = pointArray[j].y;
                if (x1 > x2) {
                    minuendx = x1;
                    subtrahendx = x2;
                } else {
                    minuendx = x2;
                    subtrahendx = x1;
                }
                if (y1 > y2) {
                    minuendy = y1;
                    subtrahendy = y2;
                } else {
                    minuendy = y2;
                    subtrahendy = y1;
                }
                if (Math.abs(minuendx - subtrahendx) <= this.offset.x + 1.0E-10 && Math.abs(minuendy - subtrahendy) <= this.offset.y + 1.0E-10) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

