/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.planagent.planmodel.access.readonly.IPMFigureDotRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import com.arcway.planagent.planmodel.transactions.Transaction;

public class ForceValidFiguresTransactionValidator
implements ITransactionValidator {
    protected final IPMPlanElementRO planElement;

    public ForceValidFiguresTransactionValidator(IPMPlanElementRO planElement) {
        assert (planElement != null);
        this.planElement = planElement;
    }

    @Override
    public boolean validateTransactionPre(Transaction transaction) {
        return true;
    }

    @Override
    public boolean validateTransactionPost(Transaction transaction) {
        boolean planObjectsAreOk = true;
        int figureIdx = 0;
        while (planObjectsAreOk && figureIdx < this.planElement.getFigureCount()) {
            IPMFigureRO figure = this.planElement.getFigureRO(figureIdx);
            planObjectsAreOk &= this.isPlanObjectOk(figure);
            ++figureIdx;
        }
        return planObjectsAreOk;
    }

    protected boolean isPlanObjectOk(IPMPlanObjectRO planObject) {
        boolean isClosed;
        assert (planObject != null);
        boolean planObjectIsOk = false;
        IPMPointListRO pointList = planObject.getPointListRO();
        boolean bl = isClosed = pointList.getLineCount() == pointList.getPointCount();
        planObjectIsOk = isClosed ? pointList.getPointCount() >= 3 : (planObject instanceof IPMFigureDotRO ? pointList.getPointCount() == 1 : pointList.getPointCount() >= 2);
        return planObjectIsOk;
    }
}

