/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.routing;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.actions.ACInvalidAction;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.routing.IRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;

public abstract class AbstractRouter
implements IRouter {
    private static final ILogger logger = Logger.getLogger(AbstractRouter.class);
    private final Class<?> sourceClassToCheck;
    private final Class<?> destinationClassToCheck;

    public AbstractRouter(Class<?> sourceClassToCheck, Class<?> destinationClassToCheck) {
        this.sourceClassToCheck = sourceClassToCheck;
        this.destinationClassToCheck = destinationClassToCheck;
    }

    @Override
    public final ActionIterator route(IAnchoringSource source, IAnchoringDestination destination, ActionContext actionContext, IRoutingParameters routingParameters, IRoutingManager routingManager) {
        ActionIterator actionIterator;
        if (logger.isDebugEnabled(53)) {
            logger.debug(53, "      --> routing " + source + " to " + destination + " with Router " + this.getClass().getName());
        }
        if (this.sourceClassToCheck.isInstance(source) && this.destinationClassToCheck.isInstance(destination)) {
            actionIterator = this.routeWhenClassesAreChecked(source, destination, actionContext, routingParameters, routingManager);
            if (logger.isDebugEnabled(53)) {
                logger.debug(53, "      --> routing finished.");
            }
        } else {
            PredeterminedActionIterator preDeterminedActionIterator = new PredeterminedActionIterator(1);
            preDeterminedActionIterator.addAction(new ACInvalidAction(actionContext));
            actionIterator = preDeterminedActionIterator;
            logger.error("      --> invalid source/destination type for router " + this.getClass().getName());
        }
        return actionIterator;
    }

    public abstract ActionIterator routeWhenClassesAreChecked(IAnchoringSource var1, IAnchoringDestination var2, ActionContext var3, IRoutingParameters var4, IRoutingManager var5);
}

