/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.reactions;

import com.arcway.planagent.planmodel.access.readwrite.IPMContainmentRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.actions.ACReorderPlanElementStructure;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.nesting.NestingAgent;
import com.arcway.planagent.planmodel.reactions.FigureMovements;
import com.arcway.planagent.planmodel.reactions.IRAAddContainment;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryAttributeFigure;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.IRAFiguresCreated;
import com.arcway.planagent.planmodel.reactions.IRAMoveFigure;
import com.arcway.planagent.planmodel.reactions.IReactionPostprocessing;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class RAFixContainments
implements IRAChangeGeometryFigure,
IRAChangeGeometryAttributeFigure,
IRAFiguresCreated,
IRAMoveFigure,
IRAAddContainment,
IReactionPostprocessing {
    @Override
    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext context) {
        Collection<IPMPlanElementRW> nestables = this.getRelatedNestables(Collections.singleton(figure));
        return this.updateNestings(nestables, context);
    }

    @Override
    public ActionIterator createReactionsFigureGeometryAttributeChanged(IPMFigureRW figure, ActionContext context) {
        Collection<IPMPlanElementRW> nestables = this.getRelatedNestables(Collections.singleton(figure));
        return this.updateNestings(nestables, context);
    }

    @Override
    public ActionIterator createReactionsFiguresCreated(List<IPMFigureRW> createdFigures, ActionContext context) {
        Collection<IPMPlanElementRW> nestables = this.getRelatedNestables(createdFigures);
        return this.createNestings(nestables, context);
    }

    @Override
    public ActionIterator createReactionsFiguresMoved(FigureMovements figureMovements, ActionContext context) {
        Collection<IPMPlanElementRW> nestables = this.getRelatedNestables(figureMovements.getMovedFigures());
        return this.updateNestings(nestables, context);
    }

    private ActionIterator createNestings(Collection<IPMPlanElementRW> nestables, ActionContext actionContext) {
        NestingAgent nestingAgent = actionContext.getPlanModelMgr().getNestingAgent();
        return nestingAgent.createNestings(nestables, actionContext);
    }

    private ActionIterator updateNestings(Collection<IPMPlanElementRW> nestables, ActionContext actionContext) {
        NestingAgent nestingAgent = actionContext.getPlanModelMgr().getNestingAgent();
        return nestingAgent.updateNestings(nestables, actionContext);
    }

    private Collection<IPMPlanElementRW> getRelatedNestables(Collection<IPMFigureRW> figures) {
        HashSet<IPMPlanElementRW> relatedNestables = new HashSet<IPMPlanElementRW>(figures.size());
        for (IPMFigureRW figure : figures) {
            IPMPlanElementRW planElement = figure.getPlanElementRW();
            relatedNestables.add(planElement);
        }
        return relatedNestables;
    }

    @Override
    public ActionIterator createReactionsContainmentAdded(IPMContainmentRW containment, ActionContext context) {
        int containedIdx;
        PredeterminedActionIterator resortActions = null;
        IPMPlanElementRW container = containment.getContainingPlanElementRW();
        IPMPlanElementRW contained = containment.getContainedPlanElementRW();
        int containerIdx = container.getPlanRW().getPlanElementIndex(container);
        if (containerIdx > (containedIdx = container.getPlanRW().getPlanElementIndex(contained))) {
            Collection<IPMPlanElementRW> allContainerElements = contained.getAllContainersRW();
            ArrayList<IPMPlanElementRW> sendToBack = new ArrayList<IPMPlanElementRW>(allContainerElements.size());
            for (IPMPlanElementRW currentContainer : allContainerElements) {
                int currentContainerIdx = container.getPlanRW().getPlanElementIndex(currentContainer);
                if (currentContainerIdx <= containedIdx) continue;
                sendToBack.add(currentContainer);
            }
            if (!sendToBack.isEmpty()) {
                ACReorderPlanElementStructure resortAction = new ACReorderPlanElementStructure(context, sendToBack, containedIdx);
                resortActions = new PredeterminedActionIterator(1);
                resortActions.addAction(resortAction);
            }
        }
        return resortActions;
    }
}

