/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.reactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FigureMovements
implements Iterable<IPMFigureRW> {
    private final Map<IPMFigureRW, GeoVector> figures2Distance = new HashMap<IPMFigureRW, GeoVector>();

    public void addMovement(IPMFigureRW figure, GeoVector distance) {
        GeoVector oldDistance = this.figures2Distance.get(figure);
        GeoVector sumDistance = oldDistance == null ? distance : GeoVector.add((GeoVector)oldDistance, (GeoVector)distance);
        this.figures2Distance.put(figure, sumDistance);
    }

    public void addAll(FigureMovements figureMovements) {
        for (Map.Entry<IPMFigureRW, GeoVector> figure2Distance : figureMovements.figures2Distance.entrySet()) {
            IPMFigureRW figure = figure2Distance.getKey();
            GeoVector distance = figure2Distance.getValue();
            this.addMovement(figure, distance);
        }
    }

    public Collection<IPMFigureRW> getMovedFigures() {
        return this.figures2Distance.keySet();
    }

    public GeoVector getDistance(IPMFigureRW figure) {
        GeoVector distance = this.figures2Distance.get(figure);
        if (distance == null) {
            distance = GeoVector.NULL;
        }
        return distance;
    }

    public boolean isEmpty() {
        return this.figures2Distance.isEmpty();
    }

    public int size() {
        return this.figures2Distance.size();
    }

    @Override
    public Iterator<IPMFigureRW> iterator() {
        return this.figures2Distance.keySet().iterator();
    }
}

