/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.planagent.planmodel.persistent.EOPlan;
import com.arcway.planagent.planmodel.persistent.EXEOFactoryException;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import com.arcway.planagent.planmodel.persistent.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.SetupTool;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PlanFileMgr
implements IEncodableObjectFactory {
    private static XMLDecoder decoder = new XMLDecoder();
    private File planFile;
    private EOPlan planRoot;

    static {
        SetupTool.setup();
    }

    public void setData(EOPlan rootElement) {
        this.planRoot = rootElement;
    }

    public EOPlan getPlanContentRootElement() {
        return this.planRoot;
    }

    public void setPlanFile(File file) {
        this.planFile = file;
    }

    protected EOPlan readFile(File planFile) throws EXPlanCreationException {
        this.setPlanFile(planFile);
        return this.readFile();
    }

    public EOPlan readFile() throws EXPlanCreationException {
        if (this.planFile != null) {
            BufferedInputStream b_in;
            try {
                b_in = new BufferedInputStream(new FileInputStream(this.planFile));
            }
            catch (FileNotFoundException e) {
                throw new EXPlanCreationException("Planfile not found.", e);
            }
            return this.read(b_in);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOPlan read(InputStream b_in) throws EXPlanCreationException {
        try {
            XMLDecoder xMLDecoder = decoder;
            synchronized (xMLDecoder) {
                this.planRoot = (EOPlan)decoder.decodeXML(b_in, (IEncodableObjectFactory)this, true);
            }
        }
        catch (EXDecoderException e) {
            throw new EXPlanCreationException(e);
        }
        return this.planRoot;
    }

    public boolean writeFile() throws IOException {
        boolean success = false;
        if (this.planFile != null && this.planRoot != null) {
            BufferedOutputStream b_out = new BufferedOutputStream(new FileOutputStream(this.planFile));
            success = this.write(b_out);
        } else {
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(OutputStream b_out) throws IOException {
        boolean success = false;
        if (this.planRoot != null) {
            try {
                try {
                    PlanFileMgr planFileMgr = this;
                    synchronized (planFileMgr) {
                        this.planRoot.writeToXMLStream(b_out, true);
                    }
                }
                catch (EXEncoderException e) {
                    throw e.toNewIOException("Unable to write/serialize plan file");
                }
            }
            finally {
                b_out.close();
            }
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    public boolean writeFile(File planFile) throws IOException {
        this.setPlanFile(planFile);
        return this.writeFile();
    }

    public boolean writeFile(EOPlan planContent) throws IOException {
        this.setData(planContent);
        return this.writeFile();
    }

    public boolean writeFile(File planFile, EOPlan planContent) throws IOException {
        this.setData(planContent);
        return this.writeFile(planFile);
    }

    public EncodableObjectBase createEncodableObject(String xmlName, XMLContext context) throws EXDecoderException {
        EncodableObjectBase newEO = null;
        try {
            newEO = PlanModelObjectFactoryDispatcher.createEncodableObject(xmlName, context);
        }
        catch (EXEOFactoryException e) {
            throw new EXDecoderException("Execption occured while creation EOEncodableObject", (Throwable)e);
        }
        return newEO;
    }
}

