/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.persistent.PlanModelObjectFactoryDispatcher;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOEncodableObjectUnknown;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public abstract class EOPlanModelObject
extends EOEncodableObjectUnknown {
    private static final ILogger LOGGER = Logger.getLogger(EOPlanModelObject.class);
    private static final String ATTR_TAG_UID = "uid";
    private String uid;
    boolean hasCrosslinks = false;
    private boolean isResourceCacheActive = false;
    private int estimatedChildrenCount = 0;

    public static String generateUid() {
        return PlanModelObjectFactoryDispatcher.uUIDGenerator.getUUID();
    }

    public EOPlanModelObject(String xmlName) {
        super(xmlName);
    }

    public EOPlanModelObject(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    protected abstract EOPlanModelObject getFlatCopy(EOPlanModelObject var1);

    protected EOPlanModelObject getDeepCopy(EOPlanModelObject parent) {
        EOPlanModelObject newObject = this.getFlatCopy(parent);
        for (EOPlanModelObject eOPlanModelObject : this.getAllChildren()) {
            EOPlanModelObject newChild = eOPlanModelObject.getDeepCopy(newObject);
            newObject.addChildFromXML((EncodableObjectBase)newChild);
        }
        return newObject;
    }

    protected final void setAttributesFromEO(EOPlanModelObject sourceEO) {
        assert (sourceEO != null);
        this.uid = sourceEO.uid;
    }

    public boolean isResourceCacheActive() {
        return this.isResourceCacheActive;
    }

    public final void activateResourceCache() {
        if (!this.isResourceCacheActive) {
            this.isResourceCacheActive = true;
            this.resourceCacheActivated();
            for (EOPlanModelObject eOPlanModelObject : this.getAllChildren()) {
                eOPlanModelObject.activateResourceCache();
            }
        } else {
            LOGGER.warn("resouce cache was activated although it wasn't inactive");
        }
    }

    public final void deactivateResourceCache() {
        if (this.isResourceCacheActive) {
            for (EOPlanModelObject eOPlanModelObject : this.getAllChildren()) {
                eOPlanModelObject.deactivateResourceCache();
            }
            this.isResourceCacheActive = false;
            this.resourceCacheDeactivated();
        } else {
            LOGGER.warn("resource cache was deactivated although it wasn't active");
        }
    }

    private final void planModelObjectHooked(EOPlanModelObject parent) {
        if (this.isResourceCacheActive) {
            LOGGER.warn("plan model object hooked although resource cache is already active");
            this.deactivateResourceCache();
        }
        if (parent.isResourceCacheActive) {
            this.activateResourceCache();
        }
    }

    private final void planModelObjectUnhooked() {
        if (this.isResourceCacheActive) {
            this.deactivateResourceCache();
        }
    }

    protected final void childHooked(EOPlanModelObject child) {
        child.planModelObjectHooked(this);
    }

    protected final void childUnhooked(EOPlanModelObject child) {
        child.planModelObjectUnhooked();
    }

    protected void resourceCacheActivated() {
    }

    protected void resourceCacheDeactivated() {
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_UID)) {
            this.setUid(value);
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        if (this.hasCrosslinks || this.forceWritingUIDToXML()) {
            this.appendAttrToXML(writeContext, ATTR_TAG_UID, this.getUid());
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    protected final boolean hasChildren() {
        return !this.getAllChildren().isEmpty();
    }

    protected final void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        for (EOEncodableObject eOEncodableObject : this.getAllChildren()) {
            eOEncodableObject.writeXMLBody(writeContext, depth);
        }
    }

    protected final List<? extends EOPlanModelObject> getAllChildren() {
        ArrayList<EOPlanModelObject> allChildren = new ArrayList<EOPlanModelObject>(50 + this.estimatedChildrenCount);
        this.getAllChildren(allChildren);
        this.estimatedChildrenCount = allChildren.size();
        return allChildren;
    }

    protected void getAllChildren(List<EOPlanModelObject> allChildrenReceiver) {
        assert (allChildrenReceiver != null);
    }

    protected boolean forceWritingUIDToXML() {
        return false;
    }

    public String getUid() {
        if (this.uid == null) {
            this.uid = EOPlanModelObject.generateUid();
        }
        return this.uid;
    }

    public String getUidIfAvailable() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void clearHasCrosslinks() {
        this.hasCrosslinks = false;
    }

    public void setHasCrosslinks() {
        this.hasCrosslinks = true;
    }
}

