/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.planagent.planmodel.persistent.EOAnchor;
import com.arcway.planagent.planmodel.persistent.EOAnchoringLine;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.IEOFactory;
import com.arcway.planagent.planmodel.persistent.PlanModelObjectFactoryDispatcher;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public final class EOLine
extends EOPlanModelObject {
    public static final int FORCE_NONE = 1;
    public static final int FORCE_H = 2;
    public static final int FORCE_V = 3;
    private static final int DEFAULT_FORCE = 1;
    public static final String XML_NAME = "line";
    private static final String ATTR_TAG_FORCE = "force";
    private static final String ATTR_VALUE_FORCE_NONE = "none";
    private static final String ATTR_VALUE_FORCE_H = "horizontal";
    private static final String ATTR_VALUE_FORCE_V = "vertical";
    private int force = 1;
    private EOAnchoringLine anchoring = null;
    private final ArrayList<EOAnchor> anchors = new ArrayList();

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(XML_NAME, new Factory());
    }

    public EOLine() {
        super(XML_NAME);
    }

    public EOLine(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected EOPlanModelObject getFlatCopy(EOPlanModelObject parent) {
        EOLine newObject = new EOLine();
        newObject.setAttributesFromEO(this);
        return newObject;
    }

    protected final void setAttributesFromEO(EOLine sourceEO) {
        assert (sourceEO != null);
        super.setAttributesFromEO(sourceEO);
        this.force = sourceEO.force;
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_FORCE)) {
            if (value.equals(ATTR_VALUE_FORCE_NONE)) {
                this.force = 1;
            } else if (value.equals(ATTR_VALUE_FORCE_H)) {
                this.force = 2;
            } else if (value.equals(ATTR_VALUE_FORCE_V)) {
                this.force = 3;
            } else {
                knownAttribute = false;
                this.force = 1;
            }
        } else {
            knownAttribute = super.setAttributeFromXML(name, value);
        }
        return knownAttribute;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        if (this.force != 1) {
            if (this.force == 1) {
                this.appendAttrToXML(writeContext, ATTR_TAG_FORCE, ATTR_VALUE_FORCE_NONE);
            } else if (this.force == 2) {
                this.appendAttrToXML(writeContext, ATTR_TAG_FORCE, ATTR_VALUE_FORCE_H);
            } else if (this.force == 3) {
                this.appendAttrToXML(writeContext, ATTR_TAG_FORCE, ATTR_VALUE_FORCE_V);
            }
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success = true;
        if (newChild instanceof EOAnchoringLine) {
            this.anchoring = (EOAnchoringLine)newChild;
            this.childHooked(this.anchoring);
        } else if (newChild instanceof EOAnchor) {
            this.anchors.add((EOAnchor)newChild);
            this.childHooked((EOAnchor)newChild);
        } else {
            success = super.addChildFromXML(newChild);
        }
        return success;
    }

    @Override
    protected void getAllChildren(List<EOPlanModelObject> allChildrenReceiver) {
        super.getAllChildren(allChildrenReceiver);
        if (this.anchoring != null) {
            allChildrenReceiver.add(this.anchoring);
        }
        allChildrenReceiver.addAll(this.anchors);
    }

    public int getForce() {
        return this.force;
    }

    public EOAnchor getAnchor(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getAnchorCount()) : "i >= getAnchorCount()";
        return this.anchors.get(i);
    }

    public int getAnchorCount() {
        return this.anchors.size();
    }

    public void setForce(int force) {
        assert (force == 1 || force == 2 || force == 3) : "force is out of range";
        this.force = force;
    }

    public void addAnchor(EOAnchor anchor, int i) {
        assert (anchor != null) : "anchor is null";
        this.anchors.add(i, anchor);
        this.childHooked(anchor);
    }

    public void removeAnchor(EOAnchor anchor) {
        assert (anchor != null) : "anchor is null";
        assert (this.anchors.indexOf((Object)anchor) != -1) : "anchor is not related to this line";
        this.anchors.remove((Object)anchor);
        this.childUnhooked(anchor);
    }

    public void removeAnchor(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getAnchorCount()) : "i >= getAnchorCount()";
        EOAnchor anchor = this.anchors.remove(i);
        this.childUnhooked(anchor);
    }

    public EOAnchoringLine getAnchoring() {
        return this.anchoring;
    }

    public void setAnchoring(EOAnchoringLine anchoring) {
        if (this.anchoring != null) {
            this.childUnhooked(this.anchoring);
        }
        this.anchoring = anchoring;
        if (this.anchoring != null) {
            this.childHooked(this.anchoring);
        }
    }

    static class Factory
    implements IEOFactory {
        Factory() {
        }

        @Override
        public EncodableObjectBase create(XMLContext xmlContext) {
            return new EOLine(xmlContext);
        }
    }
}

