/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.planagent.planmodel.persistent.EOGraphicalSupplementDataRoot;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.EOPlanObject;
import com.arcway.planagent.planmodel.persistent.EOReferenceToFigure;
import com.arcway.planagent.planmodel.persistent.IEOFactory;
import com.arcway.planagent.planmodel.persistent.PlanModelObjectFactoryDispatcher;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public class EOGraphicalSupplement
extends EOPlanObject {
    private static final String DEFAULT_ROLE = "";
    private static final String DEFAULT_TYPE = "";
    public static final String XML_NAME = "supplement";
    private static final String ATTR_TAG_ROLE = "role";
    private static final String ATTR_TAG_TYPE = "type";
    private String role = "";
    private String type = "";
    private EOGraphicalSupplementDataRoot dataRoot = null;
    private final ArrayList<EOReferenceToFigure> references = new ArrayList();

    public EOGraphicalSupplement() {
        super(XML_NAME);
    }

    public EOGraphicalSupplement(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected EOPlanModelObject getFlatCopy(EOPlanModelObject parent) {
        EOGraphicalSupplement newObject = new EOGraphicalSupplement();
        newObject.setAttributesFromEO(this);
        return newObject;
    }

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(XML_NAME, new Factory());
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_ROLE)) {
            this.role = value;
        } else if (name.equals(ATTR_TAG_TYPE)) {
            this.type = value;
        } else {
            knownAttribute = super.setAttributeFromXML(name, value);
        }
        return knownAttribute;
    }

    protected final void setAttributesFromEO(EOGraphicalSupplement sourceEO) {
        assert (sourceEO != null);
        super.setAttributesFromEO(sourceEO);
        this.role = sourceEO.role;
        this.type = sourceEO.type;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        if (!this.type.equals("")) {
            this.appendAttrToXML(writeContext, ATTR_TAG_TYPE, this.type);
        }
        if (!this.role.equals("")) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ROLE, this.role);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean knownType = true;
        if (newChild instanceof EOGraphicalSupplementDataRoot) {
            if (this.dataRoot == null) {
                this.dataRoot = (EOGraphicalSupplementDataRoot)newChild;
                this.childHooked(this.dataRoot);
            } else {
                knownType = false;
            }
        } else if (newChild instanceof EOReferenceToFigure) {
            this.references.add((EOReferenceToFigure)newChild);
            this.childHooked((EOReferenceToFigure)newChild);
        } else {
            knownType = super.addChildFromXML(newChild);
        }
        return knownType;
    }

    @Override
    protected void getAllChildren(List<EOPlanModelObject> allChildrenReceiver) {
        super.getAllChildren(allChildrenReceiver);
        allChildrenReceiver.addAll(this.references);
        if (this.dataRoot != null) {
            allChildrenReceiver.add(this.dataRoot);
        }
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public EOGraphicalSupplementDataRoot getDataRoot() {
        return this.dataRoot;
    }

    public void setData(EOGraphicalSupplementDataRoot dataRoot) {
        if (this.dataRoot != null) {
            this.childUnhooked(this.dataRoot);
        }
        this.dataRoot = dataRoot;
        if (this.dataRoot != null) {
            this.childHooked(this.dataRoot);
        }
    }

    public int getReferenceCount() {
        return this.references.size();
    }

    public EOReferenceToFigure getReference(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getReferenceCount()) : "i >= getReferenceCount()";
        return this.references.get(i);
    }

    public void addReference(EOReferenceToFigure reference, int i) {
        assert (reference != null) : "reference is null";
        assert (i >= 0) : "i<0";
        assert (i <= this.getReferenceCount()) : "i > getReferenceCount()";
        this.references.add(i, reference);
        this.childHooked(reference);
    }

    public void removeReference(EOReferenceToFigure reference) {
        assert (reference != null) : "reference is null";
        assert (this.references.indexOf((Object)reference) != -1) : "reference is not related to this graphical supplement";
        this.references.remove((Object)reference);
        this.childUnhooked(reference);
    }

    public void removeReference(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getReferenceCount()) : "i >= getReferenceCount()";
        EOReferenceToFigure reference = this.references.remove(i);
        this.childUnhooked(reference);
    }

    static class Factory
    implements IEOFactory {
        Factory() {
        }

        @Override
        public EncodableObjectBase create(XMLContext xmlContext) {
            return new EOGraphicalSupplement(xmlContext);
        }
    }
}

