/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.planagent.planmodel.appearance.AppearanceCopier;
import com.arcway.planagent.planmodel.persistent.EALineAppearance;
import com.arcway.planagent.planmodel.persistent.EOGraphicalSupplement;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.EOPlanObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public abstract class EOFigure
extends EOPlanObject {
    private static final String DEFAULT_ROLE = "";
    public static final String XML_NAME = "figure";
    private static final String ATTR_TAG_ROLE = "role";
    protected static final String ATTR_TAG_LINE = "line";
    private String role = "";
    private final EALineAppearance lineAppearance = new EALineAppearance("line");
    private final ArrayList<EOGraphicalSupplement> graphicalSupplements = new ArrayList();

    public EOFigure(String xmlName) {
        super(xmlName);
    }

    public EOFigure(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    protected final void setAttributesFromEO(EOFigure sourceEO) {
        assert (sourceEO != null);
        super.setAttributesFromEO(sourceEO);
        this.role = sourceEO.role;
        AppearanceCopier.line(sourceEO.lineAppearance, this.lineAppearance);
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_ROLE)) {
            this.role = value;
        } else {
            knownAttribute = false;
        }
        if (!knownAttribute) {
            knownAttribute = this.lineAppearance.setAttributeFromXML(name, value);
        }
        if (!knownAttribute) {
            knownAttribute = super.setAttributeFromXML(name, value);
        }
        return knownAttribute;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        if (!this.role.equals(DEFAULT_ROLE)) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ROLE, this.role);
        }
        this.lineAppearance.appendAttributesToXML(writeContext);
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success = true;
        if (newChild instanceof EOGraphicalSupplement) {
            this.graphicalSupplements.add((EOGraphicalSupplement)newChild);
            this.childHooked((EOGraphicalSupplement)newChild);
        } else {
            success = super.addChildFromXML(newChild);
        }
        return success;
    }

    @Override
    protected void getAllChildren(List<EOPlanModelObject> allChildrenReceiver) {
        super.getAllChildren(allChildrenReceiver);
        allChildrenReceiver.addAll(this.graphicalSupplements);
    }

    public String getRole() {
        return this.role;
    }

    public EALineAppearance getLineAppearance() {
        return this.lineAppearance;
    }

    public EOGraphicalSupplement getGraphicalSupplement(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getGraphicalSupplementCount()) : "i >= getGraphicalSupplementCount()";
        return this.graphicalSupplements.get(i);
    }

    public int getGraphicalSupplementCount() {
        return this.graphicalSupplements.size();
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void addGraphicalSupplement(EOGraphicalSupplement graphicalSupplement, int i) {
        assert (graphicalSupplement != null) : "graphicalSupplement is null";
        assert (i >= 0) : "i<0";
        assert (i <= this.getGraphicalSupplementCount()) : "i > getGraphicalSupplementCount()";
        this.graphicalSupplements.add(i, graphicalSupplement);
        this.childHooked(graphicalSupplement);
    }

    public void removeGraphicalSupplement(EOGraphicalSupplement graphicalSupplement) {
        assert (graphicalSupplement != null) : "graphicalSupplement is null";
        assert (this.graphicalSupplements.indexOf((Object)graphicalSupplement) != -1) : "graphicalSupplement is not related to this figure";
        this.graphicalSupplements.remove((Object)graphicalSupplement);
        this.childUnhooked(graphicalSupplement);
    }

    public void removeGraphicalSupplement(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getGraphicalSupplementCount()) : "i >= getGraphicalSupplementCount()";
        EOGraphicalSupplement graphicalSupplement = this.graphicalSupplements.remove(i);
        this.childUnhooked(graphicalSupplement);
    }
}

