/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.IEOFactory;
import com.arcway.planagent.planmodel.persistent.PlanModelObjectFactoryDispatcher;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.List;

public final class EOAnchor
extends EOPlanModelObject {
    public static final String XML_NAME = "anchor";
    private static final String ATTR_TAG_POSITION = "position";
    private static final String ATTR_TAG_OFFSET_X = "offset.x";
    private static final String ATTR_TAG_OFFSET_Y = "offset.y";
    private double position = 0.5;
    private double offsetX = 0.0;
    private double offsetY = 0.0;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(XML_NAME, new Factory());
    }

    public EOAnchor() {
        super(XML_NAME);
    }

    public EOAnchor(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    public EOPlanModelObject getFlatCopy(EOPlanModelObject parent) {
        EOAnchor newObject = new EOAnchor();
        newObject.setAttributesFromEO(this);
        return newObject;
    }

    protected final void setAttributesFromEO(EOAnchor sourceEO) {
        assert (sourceEO != null);
        super.setAttributesFromEO(sourceEO);
        this.position = sourceEO.position;
        this.offsetX = sourceEO.offsetX;
        this.offsetY = sourceEO.offsetY;
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_POSITION)) {
            this.position = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_OFFSET_X)) {
            this.offsetX = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_OFFSET_Y)) {
            this.offsetY = this.toDouble(value);
        } else {
            knownAttribute = super.setAttributeFromXML(name, value);
        }
        return knownAttribute;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        this.appendAttrToXML(writeContext, ATTR_TAG_POSITION, this.position);
        if (Math.abs(this.offsetX) > 1.0E-10 || Math.abs(this.offsetY) > 1.0E-10) {
            this.appendAttrToXML(writeContext, ATTR_TAG_OFFSET_X, this.offsetX);
            this.appendAttrToXML(writeContext, ATTR_TAG_OFFSET_Y, this.offsetY);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return super.addChildFromXML(newChild);
    }

    @Override
    protected void getAllChildren(List<EOPlanModelObject> allChildrenReceiver) {
        super.getAllChildren(allChildrenReceiver);
    }

    public double getPosition() {
        return this.position;
    }

    public GeoVector getOffset() {
        return new GeoVector(this.offsetX, this.offsetY);
    }

    public void setPosition(double position) {
        assert (position > -1.0E-10) : "position < 0";
        assert (position < 1.0000000001) : "position > 1";
        this.position = position;
    }

    public void setOffset(GeoVector offset) {
        this.offsetX = offset.x;
        this.offsetY = offset.y;
    }

    static class Factory
    implements IEOFactory {
        Factory() {
        }

        @Override
        public EncodableObjectBase create(XMLContext xmlContext) {
            return new EOAnchor(xmlContext);
        }
    }
}

