/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearance;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TextAppearance;
import de.plans.lib.xml.encoding.EAEncodableAttributes;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class EATextAppearance
extends EAEncodableAttributes
implements ITextAppearance {
    private static final String ATTR_TAG_ALIGNMENT_H = "alignment.h";
    private static final String ATTR_TAG_ALIGNMENT_V = "alignment.v";
    private static final String ATTR_TAG_DIRECTION = "direction";
    private static final String ATTR_TAG_INSET_LEFT = "alignment.inset.left";
    private static final String ATTR_TAG_INSET_RIGHT = "alignment.inset.right";
    private static final String ATTR_TAG_INSET_TOP = "alignment.inset.top";
    private static final String ATTR_TAG_INSET_BOTTOM = "alignment.inset.bottom";
    private static final String ATTR_TAG_FONTNAME = "font.name";
    private static final String ATTR_TAG_BOLD = "font.style.bold";
    private static final String ATTR_TAG_ITALIC = "font.style.italic";
    private static final String ATTR_TAG_TEXTLINEHEIGHT = "font.textlineheight";
    private static final String OLD_ATTR_TAG_TEXTHEIGHT = "font.textheight";
    private static final String OLD_ATTR_TAG_TEXTSIZE = "font.textsize";
    private static final String ATTR_TAG_TEXTCOLOR_RED = "color.red";
    private static final String ATTR_TAG_TEXTCOLOR_GREEN = "color.green";
    private static final String ATTR_TAG_TEXTCOLOR_BLUE = "color.blue";
    private static final String ATTR_TAG_TEXTCOLOR_TRANSPARENT = "color.transparent";
    private static final String ATTR_VALUE_ALIGNMENT_H_LEFT = "left";
    private static final String ATTR_VALUE_ALIGNMENT_H_CENTER = "center";
    private static final String ATTR_VALUE_ALIGNMENT_H_RIGHT = "right";
    private static final String ATTR_VALUE_ALIGNMENT_V_TOP = "top";
    private static final String ATTR_VALUE_ALIGNMENT_V_CENTER = "center";
    private static final String ATTR_VALUE_ALIGNMENT_V_BOTTOM = "bottom";
    private int alignmentH = 2;
    private int alignmentV = 16;
    private double direction = DEFAULT_DIRECITON.getAngle();
    private double insetTop;
    private double insetBottom;
    private double insetLeft;
    private double insetRight;
    private String fontName;
    private boolean bold;
    private boolean italic;
    private double textLineHeight;
    private int textColorRed;
    private int textColorGreen;
    private int textColorBlue;
    private boolean textColorTransparent;

    public EATextAppearance(String xmlAttrTag) {
        super(xmlAttrTag);
        this.insetTop = EATextAppearance.DEFAULT_INSETS.upperInset;
        this.insetBottom = EATextAppearance.DEFAULT_INSETS.lowerInset;
        this.insetLeft = EATextAppearance.DEFAULT_INSETS.leftInset;
        this.insetRight = EATextAppearance.DEFAULT_INSETS.rightInset;
        this.fontName = "Arial";
        this.bold = false;
        this.italic = false;
        this.textLineHeight = 4.5;
        this.textColorRed = 0;
        this.textColorGreen = 0;
        this.textColorBlue = 0;
        this.textColorTransparent = false;
    }

    public void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        if (this.alignmentH != 2) {
            if (this.alignmentH == 1) {
                this.appendAttrToXML(writeContext, ATTR_TAG_ALIGNMENT_H, ATTR_VALUE_ALIGNMENT_H_LEFT);
            } else if (this.alignmentH == 2) {
                this.appendAttrToXML(writeContext, ATTR_TAG_ALIGNMENT_H, "center");
            } else if (this.alignmentH == 4) {
                this.appendAttrToXML(writeContext, ATTR_TAG_ALIGNMENT_H, ATTR_VALUE_ALIGNMENT_H_RIGHT);
            }
        }
        if (this.alignmentV != 16) {
            if (this.alignmentV == 8) {
                this.appendAttrToXML(writeContext, ATTR_TAG_ALIGNMENT_V, ATTR_VALUE_ALIGNMENT_V_TOP);
            } else if (this.alignmentV == 16) {
                this.appendAttrToXML(writeContext, ATTR_TAG_ALIGNMENT_V, "center");
            } else if (this.alignmentV == 32) {
                this.appendAttrToXML(writeContext, ATTR_TAG_ALIGNMENT_V, ATTR_VALUE_ALIGNMENT_V_BOTTOM);
            }
        }
        if (!DEFAULT_DIRECITON.equalsDirection(Direction.valueOf((double)this.direction))) {
            this.appendAttrToXML(writeContext, ATTR_TAG_DIRECTION, this.direction);
        }
        if (!DEFAULT_INSETS.equalsInsets(new Insets(this.insetTop, this.insetBottom, this.insetLeft, this.insetRight))) {
            this.appendAttrToXML(writeContext, ATTR_TAG_INSET_TOP, this.insetTop);
            this.appendAttrToXML(writeContext, ATTR_TAG_INSET_BOTTOM, this.insetBottom);
            this.appendAttrToXML(writeContext, ATTR_TAG_INSET_LEFT, this.insetLeft);
            this.appendAttrToXML(writeContext, ATTR_TAG_INSET_RIGHT, this.insetRight);
        }
        if (!this.fontName.equals("Arial")) {
            this.appendAttrToXML(writeContext, ATTR_TAG_FONTNAME, this.fontName);
        }
        if (this.bold) {
            this.appendAttrToXML(writeContext, ATTR_TAG_BOLD, this.bold);
        }
        if (this.italic) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ITALIC, this.italic);
        }
        if (this.textLineHeight != 4.5) {
            this.appendAttrToXML(writeContext, ATTR_TAG_TEXTLINEHEIGHT, this.textLineHeight);
        }
        if (this.textColorTransparent) {
            this.appendAttrToXML(writeContext, ATTR_TAG_TEXTCOLOR_TRANSPARENT, this.textColorTransparent);
        }
        if (!(this.textColorRed == 0 && this.textColorGreen == 0 && this.textColorBlue == 0 || this.textColorTransparent)) {
            this.appendAttrToXML(writeContext, ATTR_TAG_TEXTCOLOR_RED, this.textColorRed);
            this.appendAttrToXML(writeContext, ATTR_TAG_TEXTCOLOR_GREEN, this.textColorGreen);
            this.appendAttrToXML(writeContext, ATTR_TAG_TEXTCOLOR_BLUE, this.textColorBlue);
        }
    }

    protected boolean setSubAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_ALIGNMENT_H)) {
            this.alignmentH = value.equals(ATTR_VALUE_ALIGNMENT_H_LEFT) ? 1 : (value.equals("center") ? 2 : (value.equals(ATTR_VALUE_ALIGNMENT_H_RIGHT) ? 4 : 2));
        } else if (name.equals(ATTR_TAG_ALIGNMENT_V)) {
            this.alignmentV = value.equals(ATTR_VALUE_ALIGNMENT_V_TOP) ? 8 : (value.equals("center") ? 16 : (value.equals(ATTR_VALUE_ALIGNMENT_V_BOTTOM) ? 32 : 16));
        } else if (name.equals(ATTR_TAG_DIRECTION)) {
            this.direction = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_INSET_TOP)) {
            this.insetTop = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_INSET_BOTTOM)) {
            this.insetBottom = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_INSET_LEFT)) {
            this.insetLeft = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_INSET_RIGHT)) {
            this.insetRight = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_FONTNAME)) {
            this.fontName = value;
        } else if (name.equals(ATTR_TAG_BOLD)) {
            this.bold = this.toBoolean(value);
        } else if (name.equals(ATTR_TAG_ITALIC)) {
            this.italic = this.toBoolean(value);
        } else if (name.equals(OLD_ATTR_TAG_TEXTHEIGHT)) {
            this.textLineHeight = this.convertTextHeightToTextLineHeight(this.toDouble(value));
        } else if (name.equals(OLD_ATTR_TAG_TEXTSIZE)) {
            this.textLineHeight = this.convertTextSizeToTextLineHeight(this.toDouble(value));
        } else if (name.equals(ATTR_TAG_TEXTLINEHEIGHT)) {
            this.textLineHeight = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_TEXTCOLOR_RED)) {
            this.textColorRed = this.toInt(value);
        } else if (name.equals(ATTR_TAG_TEXTCOLOR_GREEN)) {
            this.textColorGreen = this.toInt(value);
        } else if (name.equals(ATTR_TAG_TEXTCOLOR_BLUE)) {
            this.textColorBlue = this.toInt(value);
        } else if (name.equals(ATTR_TAG_TEXTCOLOR_TRANSPARENT)) {
            this.textColorTransparent = this.toBoolean(value);
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    private double convertTextSizeToTextLineHeight(double textSize) {
        double textLineHeight = Geo.equals((double)textSize, (double)1.5) ? 1.5 : (Geo.equals((double)textSize, (double)1.75) ? 1.5 : (Geo.equals((double)textSize, (double)2.0) ? 1.5 : (Geo.equals((double)textSize, (double)2.25) ? 1.5 : (Geo.equals((double)textSize, (double)2.5) ? 1.75 : (Geo.equals((double)textSize, (double)2.75) ? 2.0 : (Geo.equals((double)textSize, (double)3.0) ? 2.25 : (Geo.equals((double)textSize, (double)3.25) ? 2.25 : (Geo.equals((double)textSize, (double)3.5) ? 2.5 : (Geo.equals((double)textSize, (double)3.75) ? 2.75 : (Geo.equals((double)textSize, (double)4.0) ? 3.0 : (Geo.equals((double)textSize, (double)4.25) ? 3.0 : (Geo.equals((double)textSize, (double)4.5) ? 3.25 : (Geo.equals((double)textSize, (double)5.0) ? 3.5 : (Geo.equals((double)textSize, (double)5.5) ? 4.0 : (Geo.equals((double)textSize, (double)6.0) ? 4.5 : (Geo.equals((double)textSize, (double)7.0) ? 5.0 : (Geo.equals((double)textSize, (double)8.0) ? 5.5 : (Geo.equals((double)textSize, (double)9.0) ? 6.0 : (Geo.equals((double)textSize, (double)10.0) ? 7.0 : (Geo.equals((double)textSize, (double)12.0) ? 8.0 : (Geo.equals((double)textSize, (double)14.0) ? 10.0 : (Geo.equals((double)textSize, (double)16.0) ? 12.0 : (Geo.equals((double)textSize, (double)18.0) ? 12.0 : (Geo.equals((double)textSize, (double)20.0) ? 14.0 : (Geo.equals((double)textSize, (double)22.0) ? 16.0 : (Geo.equals((double)textSize, (double)25.0) ? 18.0 : (Geo.equals((double)textSize, (double)27.0) ? 20.0 : (Geo.equals((double)textSize, (double)30.0) ? 22.0 : (Geo.equals((double)textSize, (double)35.0) ? 25.0 : (Geo.equals((double)textSize, (double)40.0) ? 27.0 : (Geo.equals((double)textSize, (double)50.0) ? 35.0 : textSize * 0.72)))))))))))))))))))))))))))))));
        return textLineHeight;
    }

    private double convertTextHeightToTextLineHeight(double textHeight) {
        double textHeightInPt = textHeight * 2.8346456692913384;
        double textLineHeight = Geo.equals((double)textHeightInPt, (double)6.0) ? 2.5 : (Geo.equals((double)textHeightInPt, (double)6.5) ? 2.75 : (Geo.equals((double)textHeightInPt, (double)7.0) ? 3.0 : (Geo.equals((double)textHeightInPt, (double)7.5) ? 3.25 : (Geo.equals((double)textHeightInPt, (double)8.0) ? 3.5 : (Geo.equals((double)textHeightInPt, (double)9.0) ? 4.0 : (Geo.equals((double)textHeightInPt, (double)10.0) ? 4.5 : (Geo.equals((double)textHeightInPt, (double)12.0) ? 5.0 : (Geo.equals((double)textHeightInPt, (double)16.0) ? 7.0 : (Geo.equals((double)textHeightInPt, (double)18.0) ? 8.0 : (Geo.equals((double)textHeightInPt, (double)20.0) ? 9.0 : (Geo.equals((double)textHeightInPt, (double)24.0) ? 10.0 : (Geo.equals((double)textHeightInPt, (double)26.0) ? 12.0 : (Geo.equals((double)textHeightInPt, (double)36.0) ? 16.0 : (Geo.equals((double)textHeightInPt, (double)48.0) ? 20.5 : (Geo.equals((double)textHeightInPt, (double)60.0) ? 27.0 : (Geo.equals((double)textHeightInPt, (double)72.0) ? 30.0 : (Geo.equals((double)textHeightInPt, (double)84.0) ? 35.0 : (Geo.equals((double)textHeightInPt, (double)96.0) ? 40.0 : textHeight))))))))))))))))));
        return textLineHeight;
    }

    @Override
    public Alignment getAlignment() {
        return new Alignment(this.alignmentH, this.alignmentV);
    }

    @Override
    public Direction getDirection() {
        return Direction.valueOf((double)this.direction);
    }

    @Override
    public Insets getInsets() {
        return new Insets(this.insetTop, this.insetBottom, this.insetLeft, this.insetRight);
    }

    @Override
    public TextStyle getTextStyle() {
        return new TextStyle(this.fontName, this.bold, this.italic);
    }

    @Override
    public double getTextLineHeight() {
        return this.textLineHeight;
    }

    @Override
    public Color getTextColor() {
        if (this.textColorTransparent) {
            return new Color(Color.TRANSPARENT);
        }
        return new Color(this.textColorRed, this.textColorGreen, this.textColorBlue);
    }

    @Override
    public void setAlignment(Alignment alignment) {
        assert (alignment != null) : "alignment is null";
        this.alignmentH = alignment.h;
        this.alignmentV = alignment.v;
    }

    @Override
    public void setDirection(Direction direction) {
        assert (direction != null);
        this.direction = direction.getAngle();
    }

    @Override
    public void setInsets(Insets insets) {
        assert (insets != null) : "insets is null";
        this.insetTop = insets.upperInset;
        this.insetBottom = insets.lowerInset;
        this.insetLeft = insets.leftInset;
        this.insetRight = insets.rightInset;
    }

    @Override
    public void setTextStyle(TextStyle textStyle) {
        assert (textStyle != null) : "textStyle is null";
        this.fontName = textStyle.getFontName();
        this.bold = textStyle.isBold();
        this.italic = textStyle.isItalic();
    }

    @Override
    public void setTextLineHeight(double textSize) {
        assert (textSize > -1.0E-10) : "textHeigth < 0";
        this.textLineHeight = textSize;
    }

    @Override
    public void setTextColor(Color textColor) {
        assert (textColor != null) : "textColor is null";
        this.textColorRed = textColor.r;
        this.textColorGreen = textColor.g;
        this.textColorBlue = textColor.b;
        this.textColorTransparent = textColor.transparent;
    }

    @Override
    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof ITextAppearanceRO)) {
            return;
        }
        ITextAppearanceRO text = (ITextAppearanceRO)appearance;
        this.setAlignment(text.getAlignment());
        this.setDirection(text.getDirection());
        this.setInsets(text.getInsets());
        this.setTextColor(text.getTextColor());
        this.setTextLineHeight(text.getTextLineHeight());
        this.setTextStyle(text.getTextStyle());
    }

    @Override
    public IAppearanceRO getAppearanceAsCopy() {
        return new TextAppearance(this);
    }
}

