/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.nesting;

import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.nesting.INestable;
import com.arcway.planagent.planmodel.nesting.INestingManager;
import de.plans.lib.structure.IStructureProvider;
import de.plans.lib.structure.IStructureProviderRW;
import de.plans.lib.structure.Relation;
import de.plans.lib.structure.StructureDelegating;
import de.plans.lib.structure.StructureLogging;
import de.plans.lib.structure.StructureProxy;
import java.util.Collection;

public class NestingAgent
implements IStructureProviderRW {
    private static final ILogger logger = Logger.getLogger(NestingAgent.class);
    private final INestingManager nestingManager;
    private final StructureDelegating structure;

    public NestingAgent(INestingManager nestingManager) {
        this.nestingManager = nestingManager;
        this.structure = new StructureDelegating((IStructureProviderRW)this);
    }

    public ActionIterator createNestings(Collection createdNestableObjects, ActionContext actionContext) {
        if (logger.isDebugEnabled(57)) {
            logger.debug(57, "  ~ **** Starting nesting agent: create nesting **** ");
        }
        StructureProxy simulationStructure = new StructureProxy((IStructureProvider)this);
        simulationStructure.createProxiedElementsRelations(createdNestableObjects);
        ActionIterator createNestingActions = this.getContainmentChangeActions((StructureLogging)simulationStructure, actionContext);
        if (logger.isDebugEnabled(57)) {
            logger.debug(57, "  ~ **** nesting agent finished **** ");
        }
        return createNestingActions;
    }

    public ActionIterator updateNestings(Collection changedNestableObjects, ActionContext actionContext) {
        if (logger.isDebugEnabled(57)) {
            logger.debug(57, "  ~ **** Starting nesting agent: update nesting **** ");
        }
        StructureProxy simulationStructure = new StructureProxy((IStructureProvider)this);
        simulationStructure.updateProxiedElementsRelations(changedNestableObjects);
        ActionIterator changeNestingActions = this.getContainmentChangeActions((StructureLogging)simulationStructure, actionContext);
        if (logger.isDebugEnabled(57)) {
            logger.debug(57, "  ~ **** nesting agent finished **** ");
        }
        return changeNestingActions;
    }

    public ActionIterator removeNestings(Collection removedNestableObjects, ActionContext actionContext) {
        if (logger.isDebugEnabled(57)) {
            logger.debug(57, "  ~ **** Starting nesting agent: remove nesting **** ");
        }
        StructureProxy simulationStructure = new StructureProxy((IStructureProvider)this);
        simulationStructure.removeProxiedElementsRelations(removedNestableObjects);
        ActionIterator removeNestingActions = this.getContainmentChangeActions((StructureLogging)simulationStructure, actionContext);
        if (logger.isDebugEnabled(57)) {
            logger.debug(57, "  ~ **** nesting agent finished **** ");
        }
        return removeNestingActions;
    }

    private ActionIterator getContainmentChangeActions(StructureLogging structure, ActionContext actionContext) {
        Collection containmentsToRemove = structure.getRemovedRelations();
        Collection containmentsToCreate = structure.getCreatedRelations();
        int numberOfActions = containmentsToRemove.size() + containmentsToCreate.size();
        PredeterminedActionIterator actions = new PredeterminedActionIterator(numberOfActions);
        if (numberOfActions > 0) {
            INestable contained;
            INestable container;
            for (Relation relation : containmentsToRemove) {
                container = (INestable)relation.getParent();
                contained = (INestable)relation.getChild();
                Action removeAction = ActionFactory.createACRemoveContainment(actionContext, container, contained);
                actions.addAction(removeAction);
                if (!logger.isDebugEnabled(57)) continue;
                logger.debug(57, "  ~ ~ ~ ~ Nesting agent: containment removed (" + container + " contained " + contained + ")");
            }
            for (Relation relation : containmentsToCreate) {
                container = (INestable)relation.getParent();
                contained = (INestable)relation.getChild();
                Action createAction = ActionFactory.createACCreateContainment(actionContext, container, contained);
                actions.addAction(createAction);
                if (!logger.isDebugEnabled(57)) continue;
                logger.debug(57, "  ~ ~ ~ ~ Nesting agent: containment created (" + container + " contains " + contained + ")");
            }
        }
        return actions;
    }

    public int getNumberOfElements() {
        return this.nestingManager.getNestableObjects().size();
    }

    public Collection getAllElements() {
        return this.nestingManager.getNestableObjects();
    }

    public Collection getParents(Object element) {
        return ((INestable)element).getNestableContainers();
    }

    public Collection getChildren(Object element) {
        return ((INestable)element).getNestableContainedNestables();
    }

    public boolean isAncestor(Object ancestor, Object descendant) {
        INestable container = (INestable)ancestor;
        INestable contained = (INestable)descendant;
        boolean isContained = this.isContained(container, contained) && !this.isContained(contained, container);
        return isContained;
    }

    private boolean isContained(INestable container, INestable contained) {
        Polygon containerInline;
        Rectangle containedBounds;
        boolean isContained = false;
        Rectangle containerBounds = container.getNestingInnerBounds();
        if (containerBounds != null && (containedBounds = contained.getNestingOuterBounds()) != null && containerBounds.isInside(containedBounds) && (containerInline = container.getNestingInline()) != null && containerInline.getPolygonCornerPointCount() > 2) {
            Polygon containedOutline = contained.getNestingOutline();
            isContained = containerInline.isInside(containedOutline);
        }
        return isContained;
    }

    public int getStructureTypeHint() {
        return 2;
    }

    public void createRelation(Relation relation) {
        assert (false) : "createRelation may not be called on NestigAgents";
    }

    public void removeRelation(Relation relation) {
        assert (false) : "removeRelation may not be called on NestigAgents";
    }

    public Collection<INestable> getAllNestingElements(Collection elements) {
        return this.structure.getAllDelegatedAncestors(elements);
    }

    public Collection<INestable> getAllNestedElements(Collection elements) {
        return this.structure.getAllDelegatedDescendants(elements);
    }
}

