/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanModelObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMSemanticalUnitRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.access.readwrite.IPlanModelMgrRW;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectCrosslinkException;
import com.arcway.planagent.planmodel.implementation.IPMSemanticalUnit;
import com.arcway.planagent.planmodel.implementation.IPlanModelObjectFactory;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class PMPlanModelObject
implements IPMPlanModelObjectRO,
IPMPlanModelObjectRW {
    private static final ILogger logger = Logger.getLogger(PMPlanModelObject.class);
    protected final Collection<PMPlanModelObject> THIS_COLLECTION = Collections.singleton(this);
    private final PlanModelMgr planModelMgr;

    protected PMPlanModelObject(PlanModelMgr planModelMgr) {
        assert (planModelMgr != null) : "planModelMgr is null";
        this.planModelMgr = planModelMgr;
    }

    public PlanModelMgr getPlanModelMgr() {
        return this.planModelMgr;
    }

    protected abstract void linkToParent(PMPlanModelObject var1);

    protected abstract void linkToChild(PMPlanModelObject var1);

    protected abstract void linkCrossLinks(PMPlanModelObject var1, LoadPlanModelObjectList var2) throws EXPlanModelObjectCrosslinkException;

    protected abstract List<PMPlanModelObject> getChildren();

    protected List<? extends Object> getCrosslinked() {
        return Collections.emptyList();
    }

    protected abstract EOPlanModelObject getPersistentPlanModelObject();

    protected void setUID(String newUID) {
        this.getPersistentPlanModelObject().setUid(newUID);
    }

    protected String getUid() {
        String uid = null;
        EOPlanModelObject persistent = this.getPersistentPlanModelObject();
        if (persistent != null) {
            uid = persistent.getUid();
        }
        return uid;
    }

    public abstract IPMSemanticalUnit getSemanticalUnit();

    @Override
    public IPMSemanticalUnitRO getISemanticalUnitRO() {
        return this.getSemanticalUnit();
    }

    @Override
    public IPMSemanticalUnitRW getISemanticalUnitRW() {
        return this.getSemanticalUnit();
    }

    @Override
    public IPlanModelMgrRW getIPlanModelMgrRW() {
        return this.getSemanticalUnit().getPlan();
    }

    protected String getTypeString() {
        String fullqualifiedClassName = this.getClass().getName();
        int position = fullqualifiedClassName.lastIndexOf(46);
        String className = fullqualifiedClassName.substring(position + 1);
        return className;
    }

    public String toString() {
        String uid = null;
        EOPlanModelObject persistent = this.getPersistentPlanModelObject();
        if (persistent != null) {
            uid = logger.isDebugEnabled(59) ? persistent.getUid() : persistent.getUidIfAvailable();
        }
        if (uid == null) {
            return String.valueOf(this.getTypeString()) + " (no UID) " + super.toString();
        }
        return String.valueOf(this.getTypeString()) + " (" + uid + ") " + super.toString();
    }

    static abstract class PlanModelObjectFactory
    implements IPlanModelObjectFactory {
        PlanModelObjectFactory() {
        }

        @Override
        public List<? extends EOEncodableObject> getChildren(EncodableObjectBase eo) {
            return new ArrayList();
        }
    }
}

