/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.geometry.polygon.PolygonCorner;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeMgrRO;
import com.arcway.planagent.planmodel.access.readonly.IPMContainmentRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeMgrRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMContainmentRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMViewableRW;
import com.arcway.planagent.planmodel.access.readwrite.IPlanModelMgrRW;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectFactoryException;
import com.arcway.planagent.planmodel.implementation.IPMSemanticalUnit;
import com.arcway.planagent.planmodel.implementation.IPlanModelObjectFactory;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.ModelChangeMgr;
import com.arcway.planagent.planmodel.implementation.PMAnchor;
import com.arcway.planagent.planmodel.implementation.PMContainment;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMFigurePlane;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PMViewable;
import com.arcway.planagent.planmodel.implementation.PlanElementFactoryDispatcher;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.nonpermanent.PMDecorator;
import com.arcway.planagent.planmodel.nonpermanent.PMHighlight;
import com.arcway.planagent.planmodel.persistent.EOPlanElement;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.routing.AbstractResizeSupplementRouter;
import com.arcway.planagent.planmodel.routing.DefaultResizeSupplementRouter;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;

public abstract class PMPlanElement
extends PMViewable
implements IPMSemanticalUnit,
IPMPlanElementRO,
IPMPlanElementRW {
    private final ModelChangeMgr modelChangeAgent = new ModelChangeMgr();
    private static HashMap<String, IPlanModelObjectFactory> factories = new HashMap();
    private final SortedMap<HighlightLevel, PMHighlight> highlights = new TreeMap<HighlightLevel, PMHighlight>();
    private PMDecorator decorator;
    private PMPlan plan;
    private final ArrayList<IPMFigureRW> figures = new ArrayList();
    private final ArrayList<PMPlanModelObject> containmentsAsContainer = new ArrayList();
    private final ArrayList<PMContainment> containmentsAsContained = new ArrayList();
    private final EOPlanElement persistent;

    protected static void registerFactory(String planElementType, IPlanModelObjectFactory factory) {
        factories.put(planElementType, factory);
    }

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOPlanElement.class, new PlanElementFactory());
    }

    protected EOPlanElement getPersistentPlanElement() {
        return this.persistent;
    }

    @Override
    protected EOPlanModelObject getPersistentPlanModelObject() {
        return this.getPersistentPlanElement();
    }

    protected PMPlanElement(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOPlanElement();
    }

    protected PMPlanElement(PlanModelMgr planModelMgr, EOPlanElement eo) {
        super(planModelMgr);
        assert (eo != null);
        this.persistent = eo;
    }

    @Override
    protected void linkToParent(PMPlanModelObject parent) {
        this.plan = (PMPlan)parent;
    }

    @Override
    protected void linkToChild(PMPlanModelObject child) {
        if (child instanceof PMFigure) {
            this.figures.add((IPMFigureRW)((Object)child));
        } else if (child instanceof PMContainment) {
            this.containmentsAsContainer.add(child);
        }
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) {
    }

    @Override
    protected List<PMPlanModelObject> getChildren() {
        ArrayList<PMPlanModelObject> children = new ArrayList<PMPlanModelObject>(this.getFigureCount() + this.getContainmentAsContainerCount());
        int i = 0;
        while (i < this.getFigureCount()) {
            children.add(this.getFigure(i));
            ++i;
        }
        i = 0;
        while (i < this.getContainmentAsContainerCount()) {
            children.add(this.getContainmentAsContainer(i));
            ++i;
        }
        return children;
    }

    protected void linkCrossLinkToContainment(PMContainment containment) {
        assert (containment != null);
        this.containmentsAsContained.add(containment);
    }

    @Override
    public PMPlan getPlan() {
        return this.plan;
    }

    @Override
    public IPMPlanRO getPlanRO() {
        return this.getPlan();
    }

    @Override
    public IPMPlanRW getPlanRW() {
        return this.getPlan();
    }

    public void setPlan(PMPlan plan) {
        this.setPlan((Object)plan);
    }

    @Override
    public void setPlan(IPMPlanRW plan) {
        this.setPlan((Object)plan);
    }

    private void setPlan(Object plan) {
        assert (plan == null || plan instanceof PMPlan);
        this.plan = (PMPlan)plan;
    }

    @Override
    public int getFigureCount() {
        return this.figures.size();
    }

    public int getFigureIndex(PMFigure figure) {
        return this.getFigureIndex((Object)figure);
    }

    @Override
    public int getFigureIndex(IPMFigureRO figure) {
        return this.getFigureIndex((Object)figure);
    }

    @Override
    public int getFigureIndex(IPMFigureRW figure) {
        return this.getFigureIndex((Object)figure);
    }

    private int getFigureIndex(Object figure) {
        assert (figure != null);
        assert (figure instanceof PMFigure);
        return this.figures.indexOf(figure);
    }

    public PMFigure getFigure(int i) {
        assert (i >= 0);
        assert (i < this.getFigureCount());
        return (PMFigure)this.figures.get(i);
    }

    @Override
    public IPMFigureRO getFigureRO(int i) {
        return this.getFigure(i);
    }

    @Override
    public IPMFigureRW getFigureRW(int i) {
        return this.getFigure(i);
    }

    @Override
    public List<IPMFigureRO> getFiguresRO(String role) {
        assert (role != null);
        ArrayList<IPMFigureRO> figuresFound = new ArrayList<IPMFigureRO>();
        int figureCount = this.getFigureCount();
        int i = 0;
        while (i < figureCount) {
            PMFigure figure = this.getFigure(i);
            if (figure.getRole().equals(role)) {
                figuresFound.add(figure);
            }
            ++i;
        }
        return figuresFound;
    }

    @Override
    public List<IPMFigureRW> getFiguresRW(String role) {
        assert (role != null);
        ArrayList<IPMFigureRW> figuresFound = new ArrayList<IPMFigureRW>();
        int i = 0;
        while (i < this.getFigureCount()) {
            PMFigure figure = this.getFigure(i);
            if (figure.getRole().equals(role)) {
                figuresFound.add(figure);
            }
            ++i;
        }
        return figuresFound;
    }

    @Override
    public Collection<? extends IPMFigureLineShapeRO> getLineShapeFiguresRO() {
        return Collections.emptyList();
    }

    public void addFigure(PMFigure figure, int index) {
        this.addFigure((Object)figure, index);
    }

    @Override
    public void addFigure(IPMFigureRW figure, int index) {
        this.addFigure((Object)figure, index);
    }

    private void addFigure(Object figure, int index) {
        assert (figure != null);
        assert (figure instanceof PMFigure);
        assert (index <= this.getFigureCount());
        PMFigure pMFigure = (PMFigure)figure;
        this.figures.add(index, pMFigure);
        this.getPersistentPlanElement().addFigure(pMFigure.getPersistentFigure(), index);
        this.flushGeometryCaches();
    }

    @Override
    public void removeFigure(int i) {
        assert (i >= 0);
        assert (i < this.getFigureCount());
        this.figures.remove(i);
        this.getPersistentPlanElement().removeFigure(i);
        this.flushGeometryCaches();
    }

    @Override
    public int getContainmentAsContainerCount() {
        return this.containmentsAsContainer.size();
    }

    public int getContainmentAsContainerIndex(PMContainment containment) {
        return this.getContainmentAsContainerIndex((Object)containment);
    }

    @Override
    public int getContainmentAsContainerIndex(IPMContainmentRO containment) {
        return this.getContainmentAsContainerIndex((Object)containment);
    }

    @Override
    public int getContainmentAsContainerIndex(IPMContainmentRW containment) {
        return this.getContainmentAsContainerIndex((Object)containment);
    }

    private int getContainmentAsContainerIndex(Object containment) {
        assert (containment != null);
        assert (containment instanceof PMContainment);
        return this.containmentsAsContainer.indexOf(containment);
    }

    public PMContainment getContainmentAsContainer(int i) {
        assert (i >= 0);
        assert (i < this.getContainmentAsContainerCount());
        return (PMContainment)this.containmentsAsContainer.get(i);
    }

    @Override
    public IPMContainmentRO getContainmentAsContainerRO(int i) {
        return this.getContainmentAsContainer(i);
    }

    @Override
    public IPMContainmentRW getContainmentAsContainerRW(int i) {
        return this.getContainmentAsContainer(i);
    }

    public void addContainmentsAsContainer(PMContainment containment, int index) {
        this.addContainmentsAsContainer((Object)containment, index);
    }

    @Override
    public void addContainmentsAsContainer(IPMContainmentRW containment, int index) {
        this.addContainmentsAsContainer((Object)containment, index);
    }

    private void addContainmentsAsContainer(Object containment, int index) {
        assert (containment != null);
        assert (containment instanceof PMContainment);
        assert (index <= this.getContainmentAsContainerCount());
        PMContainment pMContainment = (PMContainment)containment;
        this.containmentsAsContainer.add(index, pMContainment);
        this.getPersistentPlanElement().addContainment(pMContainment.getPersistentContainment(), index);
    }

    @Override
    public void removeContainmentsAsContainer(int index) {
        assert (index >= 0);
        assert (index < this.getContainmentAsContainerCount());
        this.containmentsAsContainer.remove(index);
        this.getPersistentPlanElement().removeContainment(index);
    }

    @Override
    public int getContainmentAsContainedCount() {
        return this.containmentsAsContained.size();
    }

    public int getContainmentAsContainedIndex(PMContainment containment) {
        return this.getContainmentAsContainedIndex((Object)containment);
    }

    @Override
    public int getContainmentAsContainedIndex(IPMContainmentRO containment) {
        return this.getContainmentAsContainedIndex((Object)containment);
    }

    @Override
    public int getContainmentAsContainedIndex(IPMContainmentRW containment) {
        return this.getContainmentAsContainedIndex((Object)containment);
    }

    private int getContainmentAsContainedIndex(Object containment) {
        assert (containment != null);
        assert (containment instanceof PMContainment);
        return this.containmentsAsContained.indexOf(containment);
    }

    public PMContainment getContainmentAsContained(int i) {
        assert (i >= 0);
        assert (i < this.getContainmentAsContainedCount());
        return this.containmentsAsContained.get(i);
    }

    @Override
    public IPMContainmentRO getContainmentAsContainedRO(int i) {
        return this.getContainmentAsContained(i);
    }

    @Override
    public IPMContainmentRW getContainmentAsContainedRW(int i) {
        return this.getContainmentAsContained(i);
    }

    public void addContainmentsAsContained(PMContainment containment, int index) {
        this.addContainmentsAsContained((Object)containment, index);
    }

    @Override
    public void addContainmentsAsContained(IPMContainmentRW containment, int index) {
        this.addContainmentsAsContained((Object)containment, index);
    }

    private void addContainmentsAsContained(Object containment, int index) {
        assert (containment != null);
        assert (containment instanceof PMContainment);
        assert (index <= this.getContainmentAsContainedCount());
        PMContainment pMContainment = (PMContainment)containment;
        this.containmentsAsContained.add(index, pMContainment);
    }

    @Override
    public void removeContainmentsAsContained(int index) {
        assert (index >= 0);
        assert (index < this.getContainmentAsContainedCount());
        this.containmentsAsContained.remove(index);
    }

    @Override
    public Collection<IPMPlanElementRW> getAllContainedRW() {
        return this.getAllContained();
    }

    @Override
    public Collection<IPMPlanElementRW> getAllContainersRW() {
        return this.getAllContainers();
    }

    @Override
    public Set<IPMPlanElementRO> getAllContainedRO() {
        return (Set)this.getAllContained();
    }

    @Override
    public Set<IPMPlanElementRO> getAllContainersRO() {
        return this.getAllContainers();
    }

    private Set<?> getAllContainers() {
        Set<IPMPlanElementRO> allContainers = this.getPlanRO().getAllContainers(Collections.singleton(this));
        allContainers.remove(this);
        return allContainers;
    }

    private Collection<?> getAllContained() {
        Set<IPMPlanElementRO> allContained = this.getPlanRO().getAllContained(Collections.singleton(this));
        allContained.remove(this);
        return allContained;
    }

    @Override
    public SortedMap<HighlightLevel, PMHighlight> getHighlights() {
        return this.highlights;
    }

    @Override
    public PMHighlight getHighlight(HighlightLevel highlightLevel) {
        return (PMHighlight)this.highlights.get(highlightLevel);
    }

    @Override
    public PMDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    public Collection<? extends IPMViewableRW> getChildViewables() {
        return this.figures;
    }

    @Override
    public PMViewable getParentViewable() {
        return this.plan;
    }

    @Override
    public int getNumberOfIncomingEdges() {
        return 0;
    }

    @Override
    public int getNumberOfOutgoingEdges() {
        return 0;
    }

    @Override
    public boolean isIncomingEdge(IPMFigureRO sourceFigure) {
        return false;
    }

    @Override
    public boolean isOutgoingEdge(IPMFigureRO sourceFigure) {
        return false;
    }

    protected PMPlanElement(PlanModelMgr planModelMgr, PMPlan plan) {
        super(planModelMgr);
        this.persistent = new EOPlanElement();
        this.setPlan(plan);
        plan.addPlanElement(this, plan.getPlanElementCount());
    }

    protected void setFigure(PMFigure figure) {
        assert (figure != null);
        this.figures.clear();
        this.figures.add(figure);
        while (this.getPersistentPlanElement().getFigureCount() > 0) {
            this.getPersistentPlanElement().removeFigure(0);
        }
        this.getPersistentPlanElement().addFigure(figure.getPersistentFigure(), 0);
        this.flushGeometryCaches();
    }

    protected void move(GeoVector v) {
        assert (v != null);
        int i = 0;
        while (i < this.getFigureCount()) {
            this.getFigure(i).move(v);
            ++i;
        }
    }

    protected void removeLinks() {
        while (this.getFigureCount() > 0) {
            this.removeFigure(0);
        }
        this.setPlan(null);
    }

    public void moveTransaction(GeoVector v) {
        this.move(v);
        this.flushGeometryCaches();
    }

    @Override
    public String getUid() {
        return this.getPersistentPlanElement().getUid();
    }

    @Override
    protected void setUID(String newPlanElementUID) {
        PMPlanElement thisPlanElement;
        String currentPlanElementUID = this.getUid();
        super.setUID(newPlanElementUID);
        if (this.plan != null && (thisPlanElement = this.plan.getPlanElement(currentPlanElementUID)) == this) {
            this.plan.planElementUIDChanged(currentPlanElementUID, newPlanElementUID);
        }
        for (PMContainment containment : this.containmentsAsContained) {
            containment.setContainedPlanElement(this);
        }
    }

    @Override
    public String getType() {
        return this.getPersistentPlanElement().getType();
    }

    protected void setType(String type) {
        this.getPersistentPlanElement().setType(type);
    }

    @Override
    public String getName() {
        return this.getPersistentPlanElement().getName();
    }

    @Override
    public void setName(String name) {
        this.getPersistentPlanElement().setName(name);
    }

    @Override
    public String getAspectID() {
        return this.getPersistentPlanElement().getAspectID();
    }

    @Override
    public void setAspectID(String aspectID) {
        this.getPersistentPlanElement().setAspectID(aspectID);
    }

    @Override
    public String getDescription() {
        return this.getPersistentPlanElement().getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.getPersistentPlanElement().setDescription(description);
    }

    @Override
    public Rectangle getProjectionArea() {
        Rectangle area = null;
        IPMPlanObjectRO projectionAreaDefiningPlanObject = this.getProjectionAreaDefiningPlanObject();
        if (projectionAreaDefiningPlanObject != null) {
            IPMPointListRO pointList = projectionAreaDefiningPlanObject.getPointListRO();
            Rectangle bounds = pointList.getPoints().getBounds();
            double bottomY = bounds.lowerRight.y;
            double peBottomLeftX = bounds.upperLeft.x;
            double peBottomRightX = bounds.lowerRight.x;
            double size = 0.0;
            if (pointList.getPointCount() > 0) {
                IPMPointRO firstPoint = pointList.getPointRO(0);
                IPMPointRO startPoint = firstPoint;
                boolean startPointIsOnBottom = this.isOnBottom(startPoint.getPosition(), bottomY, peBottomLeftX, peBottomRightX);
                if (startPointIsOnBottom) {
                    IPMLineRO line1st;
                    while ((line1st = startPoint.getLine1stRO()) != null) {
                        IPMPointRO point1st = line1st.getPoint1stRO();
                        if (point1st == firstPoint) {
                            startPoint = null;
                            break;
                        }
                        if (!this.isOnBottom(point1st.getPosition(), bottomY, peBottomLeftX, peBottomRightX)) break;
                        startPoint = point1st;
                    }
                }
                if (startPoint != null) {
                    IPMPointRO currentPoint = startPoint;
                    IPMPointRO bottomLineStartPoint = startPointIsOnBottom ? startPoint : null;
                    while (currentPoint != null) {
                        IPMPointRO bottomLineEndPoint;
                        IPMLineRO line2nd = currentPoint.getLine2ndRO();
                        if (line2nd == null) {
                            bottomLineEndPoint = bottomLineStartPoint != null ? currentPoint : null;
                            currentPoint = null;
                        } else {
                            IPMPointRO point2nd = line2nd.getPoint2ndRO();
                            if (point2nd == startPoint) {
                                bottomLineEndPoint = bottomLineStartPoint != null ? currentPoint : null;
                                currentPoint = null;
                            } else {
                                boolean point2ndIsOnBottom = this.isOnBottom(point2nd.getPosition(), bottomY, peBottomLeftX, peBottomRightX);
                                if (point2ndIsOnBottom && bottomLineStartPoint == null) {
                                    bottomLineStartPoint = point2nd;
                                    bottomLineEndPoint = null;
                                } else {
                                    bottomLineEndPoint = !point2ndIsOnBottom && bottomLineStartPoint != null ? currentPoint : null;
                                }
                                currentPoint = point2nd;
                            }
                        }
                        if (bottomLineEndPoint == null) continue;
                        assert (bottomLineStartPoint != null);
                        double bottomLineStartPointX = bottomLineStartPoint.getPosition().x;
                        double bottomLineEndPointX = bottomLineEndPoint.getPosition().x;
                        if (!Geo.equals((double)bottomLineStartPointX, (double)bottomLineEndPointX)) {
                            Point rightOppositeRealPosition;
                            Point leftOppositeRealPosition;
                            IPMPointRO rightOppositePoint;
                            IPMPointRO leftOppositePoint;
                            IPMLineRO line;
                            Point rightBottomRealPosition;
                            Point leftBottomRealPosition;
                            IPMPointRO rightBottomPoint;
                            IPMPointRO leftBottomPoint;
                            if (bottomLineStartPointX < bottomLineEndPointX) {
                                leftBottomPoint = bottomLineStartPoint;
                                rightBottomPoint = bottomLineEndPoint;
                            } else {
                                leftBottomPoint = bottomLineEndPoint;
                                rightBottomPoint = bottomLineStartPoint;
                            }
                            Point leftBottomPositon = leftBottomPoint.getPosition();
                            PolygonCorner polygonCorner = leftBottomPoint.getAnchoringDestinationPositionOnPolygon();
                            if (polygonCorner != null) {
                                leftBottomRealPosition = polygonCorner.getRealPosition();
                                if (leftBottomRealPosition.x < leftBottomPositon.x - 1.0E-10) {
                                    leftBottomRealPosition = leftBottomPositon;
                                }
                            } else {
                                leftBottomRealPosition = leftBottomPositon;
                            }
                            Point rightBottomPositon = rightBottomPoint.getPosition();
                            PolygonCorner polygonCorner2 = rightBottomPoint.getAnchoringDestinationPositionOnPolygon();
                            if (polygonCorner2 != null) {
                                rightBottomRealPosition = polygonCorner2.getRealPosition();
                                if (rightBottomRealPosition.x > rightBottomPositon.x + 1.0E-10) {
                                    rightBottomRealPosition = rightBottomPositon;
                                }
                            } else {
                                rightBottomRealPosition = rightBottomPositon;
                            }
                            if (leftBottomPoint == bottomLineStartPoint) {
                                line = bottomLineStartPoint.getLine1stRO();
                                leftOppositePoint = line != null ? line.getPoint1stRO() : null;
                                line = bottomLineEndPoint.getLine2ndRO();
                                rightOppositePoint = line != null ? line.getPoint2ndRO() : null;
                            } else {
                                line = bottomLineEndPoint.getLine2ndRO();
                                leftOppositePoint = line != null ? line.getPoint2ndRO() : null;
                                line = bottomLineStartPoint.getLine1stRO();
                                rightOppositePoint = line != null ? line.getPoint1stRO() : null;
                            }
                            if (leftOppositePoint != null) {
                                Point oppositePositon = leftOppositePoint.getPosition();
                                if (Geo.equals((double)oppositePositon.y, (double)bottomY)) {
                                    leftOppositeRealPosition = null;
                                } else {
                                    PolygonCorner polygonCorner3 = leftOppositePoint.getAnchoringDestinationPositionOnPolygon();
                                    if (polygonCorner3 != null) {
                                        leftOppositeRealPosition = polygonCorner3.getRealPosition();
                                        if (leftOppositeRealPosition.x < leftBottomPositon.x - 1.0E-10) {
                                            leftOppositeRealPosition = oppositePositon;
                                        }
                                    } else {
                                        leftOppositeRealPosition = oppositePositon;
                                    }
                                }
                            } else {
                                leftOppositeRealPosition = null;
                            }
                            if (rightOppositePoint != null) {
                                Point oppositePositon = rightOppositePoint.getPosition();
                                if (Geo.equals((double)oppositePositon.y, (double)bottomY)) {
                                    rightOppositeRealPosition = null;
                                } else {
                                    PolygonCorner polygonCorner4 = rightOppositePoint.getAnchoringDestinationPositionOnPolygon();
                                    if (polygonCorner4 != null) {
                                        rightOppositeRealPosition = polygonCorner4.getRealPosition();
                                        if (rightOppositeRealPosition.x > rightBottomPositon.x + 1.0E-10) {
                                            rightOppositeRealPosition = oppositePositon;
                                        }
                                    } else {
                                        rightOppositeRealPosition = oppositePositon;
                                    }
                                }
                            } else {
                                rightOppositeRealPosition = null;
                            }
                            double leftX = leftOppositeRealPosition != null ? Math.max(leftBottomRealPosition.x, leftOppositeRealPosition.x) : leftBottomRealPosition.x;
                            double rightX = rightOppositeRealPosition != null ? Math.min(rightBottomRealPosition.x, rightOppositeRealPosition.x) : rightBottomRealPosition.x;
                            double upperY = leftOppositeRealPosition != null && rightOppositeRealPosition != null ? Math.max(leftOppositeRealPosition.y, rightOppositeRealPosition.y) : (leftOppositeRealPosition != null ? leftOppositeRealPosition.y : (rightOppositeRealPosition != null ? rightOppositeRealPosition.y : bottomY));
                            double lowerY = Math.min(leftBottomRealPosition.y, rightBottomRealPosition.y);
                            double w = rightX - leftX;
                            double h = lowerY - upperY;
                            double currentSize = w * h;
                            if (area == null || currentSize > size) {
                                area = new Rectangle(leftX, upperY, rightX, lowerY);
                                size = currentSize;
                            }
                        }
                        bottomLineStartPoint = null;
                    }
                }
            }
        }
        if (area == null) {
            area = this.getNestingInnerBounds();
        }
        if (area == null) {
            area = this.getOuterBounds();
        }
        return area;
    }

    private boolean isOnBottom(Point p, double bottomY, double bottomLeftX, double bottomRightX) {
        return Geo.equals((double)p.y, (double)bottomY) && p.x > bottomLeftX - 1.0E-10 && p.x < bottomRightX + 1.0E-10;
    }

    protected abstract IPMPlanObjectRO getProjectionAreaDefiningPlanObject();

    @Override
    public AbstractResizeSupplementRouter getResizeSupplementRouter(IPMGraphicalSupplementRW graphSuppl) {
        assert (graphSuppl != null);
        assert (this.getPlanElementRW().equals(graphSuppl.getPlanElementRW())) : "the graSuppl does not belong to this planelement";
        return new DefaultResizeSupplementRouter();
    }

    @Override
    public IPMSemanticalUnit getSemanticalUnit() {
        return this;
    }

    public IPlanModelMgrRW getPlanModelMgrRW() {
        return this.getPlan();
    }

    public ModelChangeMgr getModelChangeAgent() {
        return this.modelChangeAgent;
    }

    @Override
    public IModelChangeMgrRO getModelChangeMgrRO() {
        return this.getModelChangeAgent();
    }

    @Override
    public IModelChangeMgrRW getModelChangeMgrRW() {
        return this.getModelChangeAgent();
    }

    public PMPlanElement getPlanElement() {
        return this;
    }

    @Override
    public IAnchoringSourcePoint getSourceEndPoint() {
        return null;
    }

    @Override
    public IAnchoringSourcePoint getSourceNoneEndPoint() {
        return null;
    }

    @Override
    public IAnchoringSourceLine getSourceLine() {
        return null;
    }

    @Override
    public Collection<? extends IAnchoringSourceContributor> getChildSourceContributors() {
        return this.figures;
    }

    @Override
    public Rectangle getSourceContributorOuterBounds() {
        return this.getOuterBounds();
    }

    @Override
    public IAnchoringDestinationFigure getDestinationFigure() {
        return null;
    }

    @Override
    public IAnchoringDestinationPoint getDestinationPoint() {
        return null;
    }

    @Override
    public IAnchoringDestinationLine getDestinationLine() {
        return null;
    }

    @Override
    public Collection<? extends IAnchoringDestinationContributor> getChildDestinationContributors() {
        return this.figures;
    }

    @Override
    public Rectangle getDestinationContributorOuterBounds() {
        return this.getOuterBounds();
    }

    public IAnchoringSource getRootSource(PMLine line) {
        return null;
    }

    @Override
    public IAnchoringSource getRootSource(IPMPointRO point) {
        return this.getRootSource((PMPoint)point);
    }

    public IAnchoringSource getRootSource(PMPoint point) {
        return null;
    }

    public Collection<IAnchoringSource> getChildSources(PMLine line) {
        return null;
    }

    public Collection<IAnchoringSource> getChildSources(PMPoint point) {
        return null;
    }

    public IAnchoringDestination getRootDestination(PMPoint point) {
        return null;
    }

    public IAnchoringDestination getRootDestination(PMFigure figure) {
        return null;
    }

    public IAnchoringDestination getRootDestination(PMLine line) {
        return null;
    }

    public IAnchoringDestination getRootDestination(PMAnchor anchor) {
        return null;
    }

    public IPMPlanElementRW getPlanElementRW() {
        return this;
    }

    @Override
    public Collection<PMPlanElement> getNestableContainedNestables() {
        int containments = this.getContainmentAsContainerCount();
        ArrayList<PMPlanElement> containedObjects = new ArrayList<PMPlanElement>(containments);
        int i = 0;
        while (i < containments) {
            PMContainment containment = this.getContainmentAsContainer(i);
            containedObjects.add(containment.getContainedPlanElement());
            ++i;
        }
        return containedObjects;
    }

    @Override
    public Collection<PMPlanElement> getNestableContainers() {
        int containments = this.getContainmentAsContainedCount();
        ArrayList<PMPlanElement> containerObjects = new ArrayList<PMPlanElement>(containments);
        int i = 0;
        while (i < containments) {
            PMContainment containment = this.getContainmentAsContained(i);
            containerObjects.add(containment.getContainingPlanElement());
            ++i;
        }
        return containerObjects;
    }

    @Override
    public Polygon getNestingInline() {
        Polygon inline = null;
        PMFigure nestingFigure = this.getNestingInlineFigure();
        if (nestingFigure != null) {
            inline = nestingFigure.getPolygon();
        }
        return inline;
    }

    @Override
    public Polygon getNestingOutline() {
        Polygon outline = null;
        PMFigure nestingFigure = this.getNestingOutlineFigure();
        if (nestingFigure != null) {
            outline = nestingFigure.getPolygon();
        }
        return outline;
    }

    @Override
    public Rectangle getNestingInnerBounds() {
        Rectangle innerBounds = null;
        PMFigure nestingFigure = this.getNestingInlineFigure();
        if (nestingFigure != null) {
            innerBounds = nestingFigure.getPointList().getPointsBounds();
        }
        return innerBounds;
    }

    @Override
    public Rectangle getNestingOuterBounds() {
        Rectangle outerBounds = null;
        PMFigure nestingFigure = this.getNestingOutlineFigure();
        if (nestingFigure != null) {
            outerBounds = nestingFigure.getPointList().getPointsBounds();
        }
        return outerBounds;
    }

    protected abstract PMFigure getNestingInlineFigure();

    protected abstract PMFigure getNestingOutlineFigure();

    @Override
    public boolean isComment() {
        return false;
    }

    @Override
    public Collection<? extends IPMFigureRO> getEditIPMFiguresRO() {
        return this.getEditFigures();
    }

    @Override
    public Collection<? extends IPMFigureRW> getEditIPMFiguresRW() {
        return this.getEditFigures();
    }

    public Collection getEditFigures() {
        return this.figures;
    }

    @Override
    public void setHighlight(HighlightLevel highlightLevel, PMHighlight highlight) {
        if (highlight == null) {
            this.highlights.remove(highlightLevel);
        } else {
            this.highlights.put(highlightLevel, highlight);
        }
    }

    @Override
    public void setDecorator(PMDecorator decorator) {
        this.decorator = decorator;
    }

    public IPMPlanObjectRO.PlanObjectEditType getFigureEditType(IPMFigureRO figure) {
        IPMPlanObjectRO.PlanObjectEditType editType = figure instanceof PMFigurePlane ? IPMPlanObjectRO.FIGURE_EDIT_TYPE_FULL_NODE : IPMPlanObjectRO.FIGURE_EDIT_TYPE_HALF_EDGE;
        return editType;
    }

    public IPMPlanObjectRO.PlanObjectEditType getGraphicalSupplementEditType() {
        IPMPlanObjectRO.PlanObjectEditType editType = IPMPlanObjectRO.FIGURE_EDIT_TYPE_FULL_EDGE;
        return editType;
    }

    public boolean isBendable(PMFigure figure) {
        assert (this.getFigureIndex(figure) >= 0);
        return false;
    }

    @Override
    public boolean isBendableRW(IPMFigureRW figure) {
        return this.isBendable((PMFigure)figure);
    }

    @Override
    public boolean isBendableRO(IPMFigureRO figure) {
        return this.isBendable((PMFigure)figure);
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        return null;
    }

    @Override
    public Rectangle getPointUnionWithoutChildren() {
        return null;
    }

    @Override
    public String getViewableName() {
        return this.getName();
    }

    @Override
    public String getViewableTypeID() {
        return this.getType();
    }

    @Override
    public String getViewableUID() {
        return this.getUid();
    }

    @Override
    public Rectangle calculateOuterBounds() {
        Rectangle outerBounds = null;
        int i = 0;
        while (i < this.getFigureCount()) {
            PMFigure figure = this.getFigure(i);
            Rectangle rec = figure.getOuterBounds();
            if (rec != null) {
                if (outerBounds == null) {
                    outerBounds = rec;
                } else {
                    outerBounds.union(rec);
                }
            }
            ++i;
        }
        return outerBounds;
    }

    @Override
    public Rectangle calculatePointUnion() {
        Rectangle pointUnion = null;
        int i = 0;
        while (i < this.getFigureCount()) {
            PMFigure figure = this.getFigure(i);
            Rectangle rec = figure.getPointUnion();
            if (rec != null) {
                if (pointUnion == null) {
                    pointUnion = rec;
                } else {
                    pointUnion.union(rec);
                }
            }
            ++i;
        }
        return pointUnion;
    }

    public boolean isHighlightableFigure(PMFigure fig) {
        assert (fig != null);
        return true;
    }

    @Override
    public TransformationAffiliate getOptionalTransformationForThisPlanElementAndItsChildren() {
        return null;
    }

    @Override
    public TransformationAffiliate calculateOptionalTransformation() {
        PMPlanElement planElementRO = this;
        Set<IPMPlanElementRO> allContainersRO = planElementRO.getAllContainersRO();
        ArrayList<IPMPlanElementRO> allTrafoCandidates = new ArrayList<IPMPlanElementRO>(allContainersRO.size() + 1);
        allTrafoCandidates.addAll(allContainersRO);
        allTrafoCandidates.add(planElementRO);
        Collections.sort(allTrafoCandidates, new Comparator<IPMPlanElementRO>(){

            @Override
            public int compare(IPMPlanElementRO o1, IPMPlanElementRO o2) {
                int index1 = PMPlanElement.this.plan.getPlanElementIndex(o1);
                int index2 = PMPlanElement.this.plan.getPlanElementIndex(o2);
                return index2 - index1;
            }
        });
        TransformationAffiliate trafo = null;
        for (IPMPlanElementRO trafoCandidate : allTrafoCandidates) {
            TransformationAffiliate optionalTransformation = trafoCandidate.getOptionalTransformationForThisPlanElementAndItsChildren();
            if (optionalTransformation == null) continue;
            trafo = trafo == null ? optionalTransformation : trafo.transform(optionalTransformation);
        }
        return trafo;
    }

    static class PlanElementFactory
    extends PMPlanModelObject.PlanModelObjectFactory {
        PlanElementFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) throws EXPlanModelObjectFactoryException {
            EOPlanElement eoPlanElement = (EOPlanElement)eo;
            try {
                return PlanElementFactoryDispatcher.getInstance().create(planModelMgr, eoPlanElement);
            }
            catch (CoreException e) {
                throw new EXPlanModelObjectFactoryException(e);
            }
            catch (PlugInClassExtensionFactoryException f) {
                throw new EXPlanModelObjectFactoryException(f);
            }
        }

        public List<EOEncodableObject> getChildren(EncodableObjectBase eo) {
            EOPlanElement eoPlanElement = (EOPlanElement)eo;
            List<EOEncodableObject> children = super.getChildren(eo);
            int figureIndex = 0;
            while (figureIndex < eoPlanElement.getFigureCount()) {
                children.add((EOEncodableObject)eoPlanElement.getFigure(figureIndex));
                ++figureIndex;
            }
            int containmentIndex = 0;
            while (containmentIndex < eoPlanElement.getContainmentCount()) {
                children.add((EOEncodableObject)eoPlanElement.getContainment(containmentIndex));
                ++containmentIndex;
            }
            return children;
        }
    }
}

