/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.polygon.PolygonLine;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchorRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringLineToLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointToLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringLineToLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.implementation.IPMSemanticalUnit;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMAnchor;
import com.arcway.planagent.planmodel.implementation.PMAnchoring;
import com.arcway.planagent.planmodel.implementation.PMAnchoringLine;
import com.arcway.planagent.planmodel.implementation.PMAnchoringLineToLine;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToLine;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPlanObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PMPointList;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.EOAnchoringLine;
import com.arcway.planagent.planmodel.persistent.EOLine;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import de.plans.lib.util.Ass;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PMLine
extends PMPlanModelObject
implements IPMLineRO,
IPMLineRW {
    public static final int FORCE_NONE = 1;
    public static final int FORCE_H = 2;
    public static final int FORCE_V = 3;
    private boolean polygonLineCacheIsValid = false;
    private PolygonLine polygonLineCache = null;
    private boolean boundsCacheIsValid = false;
    private Rectangle boundsCache = null;
    private boolean positionCacheIsValid = false;
    private Line positionCache = null;
    private boolean widthCacheIsValid = false;
    private Double widthCache = null;
    private PMPointList pointList = null;
    private PMPoint point1st = null;
    private PMPoint point2nd = null;
    private final ArrayList anchors = new ArrayList();
    private PMAnchoringLine anchoring = null;
    private final ArrayList pointToLineAnchorings = new ArrayList();
    private final ArrayList lineToLineAnchorings = new ArrayList();
    private final EOLine persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOLine.class, new LineFactory());
    }

    protected PMLine(PlanModelMgr planModelMgr, EOLine eo) {
        super(planModelMgr);
        this.persistent = eo;
    }

    protected EOLine getPersistentLine() {
        return this.persistent;
    }

    @Override
    protected EOPlanModelObject getPersistentPlanModelObject() {
        return this.getPersistentLine();
    }

    protected PMLine(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOLine();
    }

    @Override
    protected void linkToParent(PMPlanModelObject parent) {
        this.pointList = (PMPointList)parent;
    }

    @Override
    protected void linkToChild(PMPlanModelObject child) {
        if (child instanceof PMAnchor) {
            this.anchors.add(child);
        }
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) {
    }

    @Override
    protected List<PMPlanModelObject> getChildren() {
        ArrayList<PMPlanModelObject> children = new ArrayList<PMPlanModelObject>(0);
        int i = 0;
        while (i < this.getAnchorCount()) {
            children.add(this.getAnchor(i));
            ++i;
        }
        return children;
    }

    protected void linkCrossLinkToPoint1st(PMPoint point1st) {
        assert (point1st != null) : "point1st is null";
        this.point1st = point1st;
    }

    protected void linkCrossLinkToPoint2nd(PMPoint point2nd) {
        assert (point2nd != null) : "point2nd is null";
        this.point2nd = point2nd;
    }

    protected void linkCrossLinkToLineToLineAnchoring(PMAnchoringLineToLine anchoring) {
        assert (anchoring != null) : "anchoring is null";
        this.lineToLineAnchorings.add(anchoring);
    }

    protected void linkCrossLinkToPointToLineAnchoring(PMAnchoringPointToLine anchoring) {
        assert (anchoring != null) : "anchoring is null";
        this.pointToLineAnchorings.add(anchoring);
    }

    @Override
    protected void setUID(String newUID) {
        super.setUID(newUID);
        for (PMAnchoring anchoring : this.pointToLineAnchorings) {
            ((PMAnchoringPointToLine)anchoring).setTargetLine(this);
        }
        for (PMAnchoring anchoring : this.lineToLineAnchorings) {
            ((PMAnchoringLineToLine)anchoring).setTargetLine(this);
        }
    }

    public PMPointList getPointList() {
        return this.pointList;
    }

    @Override
    public IPMPointListRO getPointListRO() {
        return this.getPointList();
    }

    @Override
    public IPMPointListRW getPointListRW() {
        return this.getPointList();
    }

    public void setPointList(PMPointList pointList) {
        this.setPointList((Object)pointList);
    }

    @Override
    public void setPointList(IPMPointListRW pointList) {
        this.setPointList((Object)pointList);
    }

    private void setPointList(Object pointList) {
        assert (pointList == null || pointList instanceof PMPointList) : "list is not instance of PMPointList";
        this.pointList = (PMPointList)pointList;
    }

    public PMPoint getPoint1st() {
        return this.point1st;
    }

    @Override
    public IPMPointRO getPoint1stRO() {
        return this.getPoint1st();
    }

    @Override
    public IPMPointRW getPoint1stRW() {
        return this.getPoint1st();
    }

    public void setPoint1st(PMPoint point) {
        this.setPoint1st((Object)point);
    }

    @Override
    public void setPoint1st(IPMPointRW point) {
        this.setPoint1st((Object)point);
    }

    private void setPoint1st(Object point) {
        assert (point == null || point instanceof PMPoint) : "point is not instance of PMPoint";
        this.point1st = (PMPoint)point;
    }

    public PMPoint getPoint2nd() {
        return this.point2nd;
    }

    @Override
    public IPMPointRO getPoint2ndRO() {
        return this.getPoint2nd();
    }

    @Override
    public IPMPointRW getPoint2ndRW() {
        return this.getPoint2nd();
    }

    public void setPoint2nd(PMPoint point) {
        this.setPoint1st((Object)point);
    }

    @Override
    public void setPoint2nd(IPMPointRW point) {
        this.setPoint2nd((Object)point);
    }

    private void setPoint2nd(Object point) {
        assert (point == null || point instanceof PMPoint) : "point is not instance of PMPoint";
        this.point2nd = (PMPoint)point;
    }

    @Override
    public int getAnchorCount() {
        return this.anchors.size();
    }

    public int getAnchorIndex(PMAnchor anchor) {
        return this.getAnchorIndex((Object)anchor);
    }

    @Override
    public int getAnchorIndex(IPMAnchorRO anchor) {
        return this.getAnchorIndex((Object)anchor);
    }

    @Override
    public int getAnchorIndex(IPMAnchorRW anchor) {
        return this.getAnchorIndex((Object)anchor);
    }

    private int getAnchorIndex(Object anchor) {
        assert (anchor instanceof PMAnchor) : "anchor is not instance of PMAnchor";
        assert (anchor != null) : "anchor is null";
        return this.anchors.indexOf(anchor);
    }

    public PMAnchor getAnchor(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.getAnchorCount()) : "index >= getAnchorCount()";
        return (PMAnchor)this.anchors.get(index);
    }

    @Override
    public IPMAnchorRO getAnchorRO(int index) {
        return this.getAnchor(index);
    }

    @Override
    public IPMAnchorRW getAnchorRW(int index) {
        return this.getAnchor(index);
    }

    public void addAnchor(PMAnchor anchor, int i) {
        this.addAnchor((Object)anchor, i);
    }

    @Override
    public void addAnchor(IPMAnchorRW anchor, int i) {
        this.addAnchor((Object)anchor, i);
    }

    private void addAnchor(Object anchor, int i) {
        assert (anchor != null) : "anchor is null";
        assert (anchor instanceof PMAnchor) : "anchor is not instance of PMAnchor";
        assert (i >= 0 && i <= this.getAnchorCount()) : "i is out of bounds";
        PMAnchor pMAnchor = (PMAnchor)anchor;
        this.anchors.add(i, pMAnchor);
        this.getPersistentLine().addAnchor(pMAnchor.getPersistentAnchor(), i);
    }

    @Override
    public void removeAnchor(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getAnchorCount()) : "i >= getAnchorCount()";
        this.anchors.remove(i);
        this.getPersistentLine().removeAnchor(i);
    }

    public PMAnchoringLine getAnchoring() {
        return this.anchoring;
    }

    @Override
    public IPMAnchoringLineRO getAnchoringRO() {
        return this.getAnchoring();
    }

    @Override
    public IPMAnchoringLineRW getAnchoringRW() {
        return this.getAnchoring();
    }

    public void setAnchoring(PMAnchoringLine anchoring) {
        this.setAnchoring((Object)anchoring);
    }

    @Override
    public void setAnchoring(IPMAnchoringLineRW anchoring) {
        this.setAnchoring((Object)anchoring);
    }

    private void setAnchoring(Object anchoring) {
        PMAnchoringLine pMAnchoring;
        assert (anchoring == null || anchoring instanceof PMAnchoringLine) : "anchoring is not instance of PMAnchoringLine";
        this.anchoring = pMAnchoring = (PMAnchoringLine)anchoring;
        EOAnchoringLine eoanchoring = pMAnchoring == null ? null : pMAnchoring.getPersistentAnchoringLine();
        this.getPersistentLine().setAnchoring(eoanchoring);
    }

    @Override
    public int getPointToLineAnchoringCount() {
        return this.pointToLineAnchorings.size();
    }

    @Override
    public int getLineToLineAnchoringCount() {
        return this.lineToLineAnchorings.size();
    }

    public int getAnchoringIndex(PMAnchoringPointToLine anchoring) {
        return this.getPointToLineAnchoringIndex((Object)anchoring);
    }

    @Override
    public int getPointToLineAnchoringIndex(IPMAnchoringPointToLineRO anchoring) {
        return this.getPointToLineAnchoringIndex((Object)anchoring);
    }

    @Override
    public int getPointToLineAnchoringIndex(IPMAnchoringPointToLineRW anchoring) {
        return this.getPointToLineAnchoringIndex((Object)anchoring);
    }

    private int getPointToLineAnchoringIndex(Object anchoring) {
        assert (anchoring instanceof PMAnchoringPointToLine) : "anchoring is not instance of PMAnchoringPointToLine";
        assert (anchoring != null) : "anchoring is null";
        return this.pointToLineAnchorings.indexOf(anchoring);
    }

    public PMAnchoringPointToLine getPointToLineAnchoring(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.getPointToLineAnchoringCount()) : "index >= getPointToLineAnchoringCount()";
        return (PMAnchoringPointToLine)this.pointToLineAnchorings.get(index);
    }

    @Override
    public IPMAnchoringPointToLineRO getPointToLineAnchoringRO(int index) {
        return this.getPointToLineAnchoring(index);
    }

    @Override
    public IPMAnchoringPointToLineRW getPointToLineAnchoringRW(int index) {
        return this.getPointToLineAnchoring(index);
    }

    public void addPointToLineAnchoring(PMAnchoringPointToLine anchoring, int i) {
        this.addPointToLineAnchoring((Object)anchoring, i);
    }

    @Override
    public void addPointToLineAnchoring(IPMAnchoringPointToLineRW anchoring, int i) {
        this.addPointToLineAnchoring((Object)anchoring, i);
    }

    private void addPointToLineAnchoring(Object anchoring, int i) {
        assert (anchoring != null) : "anchoring is null";
        assert (anchoring instanceof PMAnchoringPointToLine) : "anchoring is not instance of PMAnchoringPointToLine";
        assert (Ass.ert((i >= 0 && i <= this.getPointToLineAnchoringCount() ? 1 : 0) != 0)) : "i is out of bounds";
        this.pointToLineAnchorings.add(i, anchoring);
    }

    @Override
    public void removePointToLineAnchoring(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getPointToLineAnchoringCount()) : "i >= getPointToLineAnchoringCount()";
        this.pointToLineAnchorings.remove(i);
    }

    @Override
    public int getLineToLineAnchoringIndex(IPMAnchoringLineToLineRO anchoring) {
        return this.getLineToLineAnchoringIndex((Object)anchoring);
    }

    @Override
    public int getLineToLineAnchoringIndex(IPMAnchoringLineToLineRW anchoring) {
        return this.getLineToLineAnchoringIndex((Object)anchoring);
    }

    private int getLineToLineAnchoringIndex(Object anchoring) {
        assert (anchoring instanceof PMAnchoringLineToLine) : "anchoring is not instance of PMAnchoringLineToLine";
        assert (anchoring != null) : "anchoring is null";
        return this.lineToLineAnchorings.indexOf(anchoring);
    }

    public PMAnchoringLineToLine getLineToLineAnchoring(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.getLineToLineAnchoringCount()) : "index >= getLineToLineAnchoringCount()";
        return (PMAnchoringLineToLine)this.lineToLineAnchorings.get(index);
    }

    @Override
    public IPMAnchoringLineToLineRO getLineToLineAnchoringRO(int index) {
        return this.getLineToLineAnchoring(index);
    }

    @Override
    public IPMAnchoringLineToLineRW getLineToLineAnchoringRW(int index) {
        return this.getLineToLineAnchoring(index);
    }

    public void addLineToLineAnchoring(PMAnchoringLineToLine anchoring, int i) {
        this.addLineToLineAnchoring((Object)anchoring, i);
    }

    @Override
    public void addLineToLineAnchoring(IPMAnchoringLineToLineRW anchoring, int i) {
        this.addLineToLineAnchoring((Object)anchoring, i);
    }

    private void addLineToLineAnchoring(Object anchoring, int i) {
        assert (anchoring != null) : "anchoring is null";
        assert (anchoring instanceof PMAnchoringLineToLine) : "anchoring is not instance of PMAnchoringLineToLine";
        assert (i >= 0 && i <= this.getLineToLineAnchoringCount()) : "i is out of bounds";
        this.lineToLineAnchorings.add(i, anchoring);
    }

    @Override
    public void removeLineToLineAnchoring(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getLineToLineAnchoringCount()) : "i >= getLineToLineAnchoringCount()";
        this.lineToLineAnchorings.remove(i);
    }

    public PMPlanObject getPlanObject() {
        return this.getPointList().getPlanObject();
    }

    @Override
    public IPMPlanObjectRO getPlanObjectRO() {
        return this.getPlanObject();
    }

    @Override
    public IPMPlanObjectRW getPlanObjectRW() {
        return this.getPlanObject();
    }

    public PMPlanElement getPlanElement() {
        return this.getPointList().getPlanElement();
    }

    @Override
    public IPMPlanElementRO getPlanElementRO() {
        return this.getPlanElement();
    }

    @Override
    public IPMPlanElementRW getPlanElementRW() {
        return this.getPlanElement();
    }

    protected void removeLinks() {
        while (this.getAnchorCount() > 0) {
            this.removeAnchor(0);
        }
        this.setPoint1st(null);
        this.setPoint2nd(null);
        this.setPointList(null);
    }

    protected PMLine(PlanModelMgr planModelMgr, PMPointList pointList) {
        super(planModelMgr);
        this.persistent = new EOLine();
        this.setPointList(pointList);
    }

    protected void deleteAllChildren() {
        this.deleteAllAnchors();
    }

    private void deleteAllAnchors() {
        while (this.getAnchorCount() > 0) {
            this.getAnchor(0).delete();
        }
    }

    protected void delete() {
        assert (this.pointList != null) : "pointList of this line object is null";
        assert (this.point1st != null) : "point1st is null";
        assert (this.point2nd != null) : "point2nd is null";
        assert (this.point1st.getLine1st() == null || this.point2nd.getLine2nd() == null) : "line has predecessor and sucessor";
        this.getPoint1st().setLine2nd(null);
        this.getPoint2nd().setLine1st(null);
        if (this.getPoint1st().getLine1st() == null) {
            this.getPoint1st().deleteAllChildren();
            this.getPoint1st().removeLinks();
            this.getPointList().removePoint(this.getPointList().getPointIndex(this.getPoint1st()));
        }
        if (this.getPoint2nd().getLine2nd() == null) {
            this.getPoint2nd().deleteAllChildren();
            this.getPoint2nd().removeLinks();
            this.getPointList().removePoint(this.getPointList().getPointIndex(this.getPoint2nd()));
        }
        this.deleteAllChildren();
        this.removeLinks();
        this.getPointList().removeLine(this.getPointList().getLineIndex(this));
    }

    protected void swapWithNext() {
        assert (this.pointList != null) : "pointList of this line object is null";
        assert (this.point1st != null) : "point1st is null";
        assert (this.point2nd != null) : "point2nd is null";
        assert (this.point2nd.getLine2nd() != null) : "line has no sucessor";
        PMLine line1st = this;
        PMLine line2nd = this.getPoint2nd().getLine2nd();
        PMPoint p1 = line1st.getPoint1st();
        PMPoint p2 = line1st.getPoint2nd();
        PMPoint p3 = line2nd.getPoint2nd();
        assert (p2 == line2nd.getPoint1st()) : "line is not joined with it's sucessor";
        assert (line1st.getForce() == 2 && line2nd.getForce() == 3 || line1st.getForce() == 3 && line2nd.getForce() == 2) : "wrong line force of one or both lines -> cannot swap";
        if (line1st.getForce() == 2) {
            p2.setPosition(new Point(p1.getPosition().x, p3.getPosition().y));
        } else {
            p2.setPosition(new Point(p3.getPosition().x, p1.getPosition().y));
        }
        p1.setLine2nd(line2nd);
        p2.setLine1st(line2nd);
        p2.setLine2nd(line1st);
        p3.setLine1st(line1st);
        line2nd.setPoint1st(p1);
        line2nd.setPoint2nd(p2);
        line1st.setPoint1st(p2);
        line1st.setPoint2nd(p3);
    }

    protected void joinWithNext() {
        double length;
        assert (this.pointList != null) : "pointList of this line object is null";
        assert (this.point1st != null) : "point1st is null";
        assert (this.point2nd != null) : "point2nd is null";
        assert (this.point2nd.getLine2nd() != null) : "line has no sucessor";
        PMLine lineToDelete = this.getPoint2nd().getLine2nd();
        PMPoint pointToDelete = lineToDelete.getPoint1st();
        if (this.getForce() != lineToDelete.getForce()) {
            this.setForce(1);
        }
        double devidingPosition = (length = this.getLength() + lineToDelete.getLength()) > 1.0E-10 ? this.getLength() / length : 0.5;
        int i = 0;
        while (i < this.getAnchorCount()) {
            PMAnchor anchor = this.getAnchor(i);
            double anchorPosition = anchor.getRelativePosition();
            anchor.setRelativePosition(anchorPosition * devidingPosition);
            ++i;
        }
        while (lineToDelete.getAnchorCount() > 0) {
            PMAnchor anchor = lineToDelete.getAnchor(0);
            double anchorPosition = anchor.getRelativePosition();
            anchor.setRelativePosition(devidingPosition + anchorPosition * (1.0 - devidingPosition));
            anchor.setLine(this);
            this.addAnchor(anchor, this.getAnchorCount());
            lineToDelete.removeAnchor(0);
        }
        this.setPoint2nd(lineToDelete.getPoint2nd());
        this.getPoint2nd().setLine1st(this);
        lineToDelete.deleteAllChildren();
        lineToDelete.removeLinks();
        pointToDelete.deleteAllChildren();
        pointToDelete.removeLinks();
        this.getPointList().removeLine(this.getPointList().getLineIndex(lineToDelete));
        this.getPointList().removePoint(this.getPointList().getPointIndex(pointToDelete));
    }

    private double getLength() {
        assert (this.point1st != null) : "point1st is null";
        assert (this.point2nd != null) : "point2nd is null";
        GeoVector d = new GeoVector(this.getPoint1st().getPosition(), this.getPoint2nd().getPosition());
        return d.abs();
    }

    protected PMLine devide(double position, PMPoint newPoint) {
        assert (newPoint != null) : "newPoint is null";
        assert (position > -1.0E-10) : "position < 0";
        assert (position < 1.0000000001) : "position > 1";
        assert (this.pointList != null) : "pointList of this line object is null";
        assert (this.point1st != null) : "point1st is null";
        assert (this.point2nd != null) : "point2nd is null";
        newPoint.setPosition(this.getAbsolutePosition(position));
        PMLine newLine = new PMLine(this.getPlanModelMgr(), this.getPointList());
        newLine.setPoint1st(newPoint);
        newLine.setPoint2nd(this.getPoint2nd());
        newLine.setForce(this.getForce());
        this.setPoint2nd(newPoint);
        newLine.getPoint1st().setLine1st(this);
        newLine.getPoint1st().setLine2nd(newLine);
        newLine.getPoint2nd().setLine1st(newLine);
        int i = 0;
        while (i < this.getAnchorCount()) {
            PMAnchor anchor = this.getAnchor(i);
            double anchorPosition = anchor.getRelativePosition();
            if (anchorPosition <= position) {
                if (position > 1.0E-10) {
                    anchor.setRelativePosition(anchorPosition / position);
                } else {
                    anchor.setRelativePosition(0.0);
                }
                ++i;
                continue;
            }
            if (position < 0.9999999999) {
                anchor.setRelativePosition((anchorPosition - position) / (1.0 - position));
            } else {
                anchor.setRelativePosition(1.0);
            }
            anchor.setLine(newLine);
            newLine.addAnchor(anchor, this.getAnchorCount());
            this.removeAnchor(i);
        }
        this.getPointList().add(this.getPoint1st(), newLine, newPoint);
        return newLine;
    }

    private Point getAbsolutePosition(double position) {
        assert (position > -1.0E-10) : "position < 0";
        assert (position < 1.0000000001) : "position > 1";
        Point p1 = this.getPoint1st().getPosition();
        Point p2 = this.getPoint2nd().getPosition();
        GeoVector start = new GeoVector(p1);
        GeoVector d = new GeoVector(p1, p2);
        d.scale(position / d.abs());
        return new Point(GeoVector.add((GeoVector)start, (GeoVector)d));
    }

    public PMAnchor createAnchor(double position) {
        PMAnchor anchor = new PMAnchor(this.getPlanModelMgr(), this);
        anchor.setRelativePosition(position);
        this.addAnchor(anchor, this.getAnchorCount());
        return anchor;
    }

    @Override
    public IPMSemanticalUnit getSemanticalUnit() {
        return this.getPlanElement();
    }

    @Override
    public IPMFigureRO getAnchoringFigure() {
        return this.getPointList().getRelatedFigure();
    }

    @Override
    public IAnchoringSource getRootSource() {
        return this.getPlanElement().getRootSource(this);
    }

    public Collection getChildSources() {
        return this.getPlanElement().getChildSources(this);
    }

    @Override
    public IAnchoringDestinationContributor getSourceRelatedDestinationContributor() {
        PMFigure relatedDestinations = null;
        PMPlanObject planObject = this.getPlanObject();
        if (planObject instanceof PMFigure) {
            PMFigure figure;
            relatedDestinations = figure = (PMFigure)planObject;
        }
        return relatedDestinations;
    }

    @Override
    public IAnchoring getIAnchoring() {
        return this.anchoring;
    }

    @Override
    public Line getAnchoringSourcePosition() {
        return this.getPosition();
    }

    @Override
    public PolygonLine getAnchoringSourcePositionOnPolygon() {
        return this.getPolygonLine();
    }

    @Override
    public Double getAnchoringSourceWidth() {
        return this.getWidth();
    }

    @Override
    public Rectangle getAnchoringSourceOuterBounds() {
        return this.getOuterBounds();
    }

    @Override
    public IAnchoringSourcePoint getSourceEndPoint() {
        return null;
    }

    @Override
    public IAnchoringSourcePoint getSourceNoneEndPoint() {
        return null;
    }

    @Override
    public IAnchoringSourceLine getSourceLine() {
        return this;
    }

    public Collection getChildSourceContributors() {
        return null;
    }

    @Override
    public Rectangle getSourceContributorOuterBounds() {
        return this.getOuterBounds();
    }

    @Override
    public IAnchoringDestination getRootDestination() {
        return this.getPlanElement().getRootDestination(this);
    }

    @Override
    public IAnchoringSourceContributor getDestinationRelatedSourceContributor() {
        PMFigure relatedDestinations = null;
        PMPlanObject planObject = this.getPlanObject();
        if (planObject instanceof PMFigure) {
            PMFigure figure;
            relatedDestinations = figure = (PMFigure)planObject;
        }
        return relatedDestinations;
    }

    public Collection getIAnchorings() {
        ArrayList anchorings = new ArrayList(this.lineToLineAnchorings.size() + this.pointToLineAnchorings.size());
        anchorings.addAll(this.lineToLineAnchorings);
        anchorings.addAll(this.pointToLineAnchorings);
        return anchorings;
    }

    @Override
    public Line getAnchoringDestinationPosition() {
        return this.getPosition();
    }

    @Override
    public PolygonLine getAnchoringDestinationPositionOnPolygon() {
        return this.getPolygonLine();
    }

    @Override
    public Double getAnchoringDestinationWidth() {
        return this.getWidth();
    }

    @Override
    public Rectangle getAnchoringDestinationOuterBounds() {
        return this.getOuterBounds();
    }

    @Override
    public IAnchoringDestinationFigure getDestinationFigure() {
        return null;
    }

    @Override
    public IAnchoringDestinationPoint getDestinationPoint() {
        return null;
    }

    @Override
    public IAnchoringDestinationLine getDestinationLine() {
        return this;
    }

    public Collection getChildDestinationContributors() {
        return this.anchors;
    }

    @Override
    public Rectangle getDestinationContributorOuterBounds() {
        return this.getOuterBounds();
    }

    private Line getPosition() {
        this.updatePositionCache();
        return this.positionCache;
    }

    private Double getWidth() {
        this.updateWidthCache();
        return this.widthCache;
    }

    private Rectangle getOuterBounds() {
        this.updateOuterBoundsCache();
        return this.boundsCache;
    }

    @Override
    public int getForce() {
        return this.persistent.getForce();
    }

    @Override
    public void setForce(int force) {
        assert (force == 1 || force == 2 || force == 3) : "force is out of range";
        this.persistent.setForce(force);
    }

    public Point getPoint(double relativePosition) {
        Point position;
        PolygonLine polygonLine = this.getPolygonLine();
        if (polygonLine != null) {
            position = polygonLine.getPoint(relativePosition);
        } else {
            Line line = this.getPosition();
            position = line.getPoint(relativePosition * line.arcLength());
        }
        return position;
    }

    private PolygonLine getPolygonLine() {
        this.updatePolygonLineCache();
        return this.polygonLineCache;
    }

    protected void flushGeometryCaches() {
        this.polygonLineCacheIsValid = false;
        this.widthCacheIsValid = false;
        this.positionCacheIsValid = false;
        this.boundsCacheIsValid = false;
    }

    private void updatePolygonLineCache() {
        if (!this.polygonLineCacheIsValid) {
            this.polygonLineCache = this.getPlanObject().getPolygonLine(this);
            this.polygonLineCacheIsValid = true;
        }
    }

    private void updateWidthCache() {
        if (!this.widthCacheIsValid) {
            this.widthCache = null;
            PMPlanObject planObject = this.getPlanObject();
            if (planObject != null) {
                this.widthCache = planObject.getWidth();
            }
            this.widthCacheIsValid = true;
        }
    }

    private void updatePositionCache() {
        if (!this.positionCacheIsValid) {
            Point p1st = this.getPoint1st().getPosition();
            Point p2nd = this.getPoint2nd().getPosition();
            this.positionCache = new Line(p1st, p2nd);
            this.positionCacheIsValid = true;
        }
    }

    private void updateOuterBoundsCache() {
        if (!this.boundsCacheIsValid) {
            this.boundsCache = this.polygonLineCache != null ? this.getPolygonLine().getOuterBounds() : this.getPosition().getBounds();
            this.boundsCacheIsValid = true;
        }
    }

    static class LineFactory
    extends PMPlanModelObject.PlanModelObjectFactory {
        LineFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) {
            return new PMLine(planModelMgr, (EOLine)eo);
        }

        public List getChildren(EncodableObjectBase eo) {
            EOLine eoPointList = (EOLine)eo;
            List<? extends EOEncodableObject> children = super.getChildren(eo);
            int anchorIndex = 0;
            while (anchorIndex < eoPointList.getAnchorCount()) {
                children.add((EOEncodableObject)eoPointList.getAnchor(anchorIndex));
                ++anchorIndex;
            }
            return children;
        }
    }
}

