/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMGraphicalSupplementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMReferenceGraphicalSupplementToFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IRequestFlow;
import com.arcway.planagent.planmodel.access.readonly.IText;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMReferenceGraphicalSupplementToFigureRW;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectFactoryException;
import com.arcway.planagent.planmodel.implementation.GraphicalSupplementFactoryDispatcher;
import com.arcway.planagent.planmodel.implementation.IPMSemanticalUnit;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPlanObject;
import com.arcway.planagent.planmodel.implementation.PMReferenceGraphicalSupplementToFigure;
import com.arcway.planagent.planmodel.implementation.PMViewable;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.EOData;
import com.arcway.planagent.planmodel.persistent.EOGraphicalSupplement;
import com.arcway.planagent.planmodel.persistent.EOGraphicalSupplementDataRoot;
import com.arcway.planagent.planmodel.persistent.EOPlanObject;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;

public abstract class PMGraphicalSupplement
extends PMPlanObject
implements IPMGraphicalSupplementRO,
IPMGraphicalSupplementRW {
    private PMFigure figure;
    private final ArrayList references = new ArrayList();
    private final EOGraphicalSupplement persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOGraphicalSupplement.class, new GraphicalSupplementFactory());
    }

    protected EOGraphicalSupplement getPersistentGraphicalSupplement() {
        return this.persistent;
    }

    @Override
    protected EOPlanObject getPersistentPlanObject() {
        return this.getPersistentGraphicalSupplement();
    }

    protected PMGraphicalSupplement(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOGraphicalSupplement();
        this.persistent.setData(new EOGraphicalSupplementDataRoot(this.persistent));
    }

    protected PMGraphicalSupplement(PlanModelMgr planModelMgr, EOGraphicalSupplement eo) {
        super(planModelMgr);
        assert (eo != null) : "EOPlanElement must not be null";
        this.persistent = eo;
    }

    @Override
    protected void linkToParent(PMPlanModelObject parent) {
        this.figure = (PMFigure)parent;
    }

    @Override
    protected void linkToChild(PMPlanModelObject child) {
        if (child instanceof PMReferenceGraphicalSupplementToFigure) {
            this.references.add(child);
        } else {
            super.linkToChild(child);
        }
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) {
    }

    @Override
    protected List<PMPlanModelObject> getChildren() {
        List<PMPlanModelObject> children = super.getChildren();
        int i = 0;
        while (i < this.getReferenceCount()) {
            children.add(this.getReference(i));
            ++i;
        }
        return children;
    }

    public PMFigure getFigure() {
        return this.figure;
    }

    @Override
    public IPMFigureRO getFigureRO() {
        return this.getFigure();
    }

    @Override
    public IPMFigureRW getFigureRW() {
        return this.getFigure();
    }

    @Override
    public String getRole() {
        return this.getPersistentGraphicalSupplement().getRole();
    }

    public void setFigure(PMFigure figure) {
        this.setFigure((Object)figure);
    }

    @Override
    public void setFigure(IPMFigureRW figure) {
        this.setFigure((Object)figure);
    }

    private void setFigure(Object figure) {
        assert (figure == null || figure instanceof PMFigure) : "figure is not instance of PMFigure";
        this.figure = (PMFigure)figure;
    }

    @Override
    public void setRole(String role) {
        this.getPersistentGraphicalSupplement().setRole(role);
    }

    @Override
    public int getReferenceCount() {
        return this.references.size();
    }

    public int getReferenceIndex(PMReferenceGraphicalSupplementToFigure reference) {
        return this.getReferenceIndex((Object)reference);
    }

    @Override
    public int getReferenceIndex(IPMReferenceGraphicalSupplementToFigureRW reference) {
        return this.getReferenceIndex((Object)reference);
    }

    @Override
    public int getReferenceIndex(IPMReferenceGraphicalSupplementToFigureRO reference) {
        return this.getReferenceIndex((Object)reference);
    }

    private int getReferenceIndex(Object reference) {
        assert (reference instanceof PMReferenceGraphicalSupplementToFigure) : "reference is not instance of PMReferenceGraphicalSupplementToFigure";
        assert (reference != null) : "reference is null";
        return this.references.indexOf(reference);
    }

    public PMReferenceGraphicalSupplementToFigure getReference(int index) {
        assert (index >= 0) : "index<0";
        assert (index < this.getReferenceCount()) : "index >= getReferenceCount()";
        return (PMReferenceGraphicalSupplementToFigure)this.references.get(index);
    }

    @Override
    public IPMReferenceGraphicalSupplementToFigureRO getReferenceRO(int index) {
        return this.getReference(index);
    }

    @Override
    public IPMReferenceGraphicalSupplementToFigureRW getReferenceRW(int index) {
        return this.getReference(index);
    }

    public List getReferences(String role) {
        assert (role != null) : "role is null";
        ArrayList<PMReferenceGraphicalSupplementToFigure> referencesFound = new ArrayList<PMReferenceGraphicalSupplementToFigure>();
        int i = 0;
        while (i < this.getReferenceCount()) {
            PMReferenceGraphicalSupplementToFigure reference = this.getReference(i);
            if (reference.getRole().equals(role)) {
                referencesFound.add(reference);
            }
            ++i;
        }
        return referencesFound;
    }

    public void addReference(PMReferenceGraphicalSupplementToFigure reference, int index) {
        this.addReference((Object)reference, index);
    }

    @Override
    public void addReference(IPMReferenceGraphicalSupplementToFigureRW reference, int index) {
        this.addReference((Object)reference, index);
    }

    private void addReference(Object reference, int index) {
        assert (reference instanceof PMReferenceGraphicalSupplementToFigure) : "reference in not instance of PMReferenceGraphicalSupplementToFigure";
        assert (reference != null) : "reference is null";
        assert (index <= this.getReferenceCount()) : "index > getReferenceCount()";
        PMReferenceGraphicalSupplementToFigure pMReference = (PMReferenceGraphicalSupplementToFigure)reference;
        this.references.add(index, pMReference);
        this.getPersistentGraphicalSupplement().addReference(pMReference.getPersistentReferenceToFigure(), index);
    }

    @Override
    public void removeReference(int index) {
        assert (index >= 0) : "i<0";
        assert (index < this.getReferenceCount()) : "index >= getReferenceCount()";
        this.references.remove(index);
        this.getPersistentGraphicalSupplement().removeReference(index);
    }

    public PMPlanElement getPlanElement() {
        return this.figure.getPlanElement();
    }

    @Override
    public IPMPlanElementRO getPlanElementRO() {
        return this.getPlanElement();
    }

    @Override
    public IPMPlanElementRW getPlanElementRW() {
        return this.getPlanElement();
    }

    @Override
    public Collection getChildViewables() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public PMViewable getParentViewable() {
        return this.figure;
    }

    protected void constructPMGraphicalSupplement(PMFigure figure) {
        this.setFigure(figure);
        super.constructPMPlanObject();
    }

    protected void move(GeoVector v) {
        assert (v != null) : "v = null";
        this.getPointList().move(v);
    }

    @Override
    protected void removeLinks() {
        super.removeLinks();
        this.setFigure(null);
    }

    @Override
    public IPMSemanticalUnit getSemanticalUnit() {
        return this.getFigure().getPlanElement();
    }

    @Override
    public String getType() {
        return this.getPersistentGraphicalSupplement().getType();
    }

    protected void setType(String type) {
        this.getPersistentGraphicalSupplement().setType(type);
    }

    public EOData[] getDatas() {
        return this.getPersistentGraphicalSupplement().getDataRoot().getChildren();
    }

    public void setDatas(EOData[] datas) {
        this.getPersistentGraphicalSupplement().getDataRoot().setChildren(datas);
    }

    @Override
    public IPMPlanObjectRO.PlanObjectEditType getPlanObjectEditType() {
        return this.getPlanElement().getGraphicalSupplementEditType();
    }

    @Override
    public Collection<? extends IText> getTexts() {
        return Collections.emptyList();
    }

    @Override
    protected Polygon createPolygon() {
        return null;
    }

    @Override
    protected Double getWidth() {
        return null;
    }

    @Override
    public Collection<? extends IRequestFlow> getRequestFlows() {
        return Collections.emptyList();
    }

    static class GraphicalSupplementFactory
    extends PMPlanObject.PlanObjectFactory {
        GraphicalSupplementFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) throws EXPlanModelObjectFactoryException {
            EOGraphicalSupplement graphicalSupplement = (EOGraphicalSupplement)eo;
            try {
                return GraphicalSupplementFactoryDispatcher.getInstance().create(planModelMgr, graphicalSupplement);
            }
            catch (CoreException e) {
                throw new EXPlanModelObjectFactoryException(e);
            }
            catch (PlugInClassExtensionFactoryException f) {
                throw new EXPlanModelObjectFactoryException(f);
            }
        }

        public List getChildren(EncodableObjectBase eo) {
            EOGraphicalSupplement eoGraphicalSupplement = (EOGraphicalSupplement)eo;
            List<? extends EOEncodableObject> children = super.getChildren(eo);
            int referenceIndex = 0;
            while (referenceIndex < eoGraphicalSupplement.getReferenceCount()) {
                children.add((EOEncodableObject)eoGraphicalSupplement.getReference(referenceIndex));
                ++referenceIndex;
            }
            return children;
        }
    }
}

