/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointToFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMGraphicalSupplementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMReferenceGraphicalSupplementToFigureRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMReferenceGraphicalSupplementToFigureRW;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearance;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.implementation.IPMSemanticalUnit;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMAnchor;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToFigure;
import com.arcway.planagent.planmodel.implementation.PMGraphicalSupplement;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPlanObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PMPointList;
import com.arcway.planagent.planmodel.implementation.PMReferenceGraphicalSupplementToFigure;
import com.arcway.planagent.planmodel.implementation.PMViewable;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EALineAppearance;
import com.arcway.planagent.planmodel.persistent.EOFigure;
import com.arcway.planagent.planmodel.persistent.EOPlanObject;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class PMFigure
extends PMPlanObject
implements IPMFigureRO,
IPMFigureRW {
    private final ILineAppearance lineAppearanceProxy = new LineAppearanceProxy();
    private PMPlanElement planElement;
    private final ArrayList<PMGraphicalSupplement> graphicalSupplements = new ArrayList();
    private final ArrayList<PMReferenceGraphicalSupplementToFigure> references = new ArrayList();
    private final ArrayList<Object> anchorings = new ArrayList();

    protected abstract EOFigure getPersistentFigure();

    @Override
    protected EOPlanObject getPersistentPlanObject() {
        return this.getPersistentFigure();
    }

    protected PMFigure(PlanModelMgr planModelMgr) {
        super(planModelMgr);
    }

    @Override
    protected void linkToParent(PMPlanModelObject parent) {
        this.planElement = (PMPlanElement)parent;
    }

    @Override
    protected void linkToChild(PMPlanModelObject child) {
        if (child instanceof PMGraphicalSupplement) {
            this.graphicalSupplements.add((PMGraphicalSupplement)child);
        } else {
            super.linkToChild(child);
        }
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) {
    }

    @Override
    protected List<PMPlanModelObject> getChildren() {
        List<PMPlanModelObject> children = super.getChildren();
        int i = 0;
        while (i < this.getGraphicalSupplementCount()) {
            children.add(this.getGraphicalSupplement(i));
            ++i;
        }
        return children;
    }

    protected void linkCrossLinkToReference(PMReferenceGraphicalSupplementToFigure reference) {
        assert (reference != null) : "reference is null";
        this.references.add(reference);
    }

    protected void linkCrossLinkToPointToFigureAnchoring(PMAnchoringPointToFigure anchoring) {
        assert (anchoring != null) : "anchoring is null";
        this.anchorings.add(anchoring);
    }

    @Override
    protected void setUID(String newUID) {
        super.setUID(newUID);
        Iterator<Object> iterator = this.references.iterator();
        while (iterator.hasNext()) {
            PMReferenceGraphicalSupplementToFigure pMReferenceGraphicalSupplementToFigure;
            PMReferenceGraphicalSupplementToFigure reference = pMReferenceGraphicalSupplementToFigure = iterator.next();
            reference.setFigure(this);
        }
        for (Object object : this.anchorings) {
            PMAnchoringPointToFigure anchoring = (PMAnchoringPointToFigure)object;
            anchoring.setFigure(this);
        }
    }

    public PMPlanElement getPlanElement() {
        return this.planElement;
    }

    @Override
    public IPMPlanElementRO getPlanElementRO() {
        return this.getPlanElement();
    }

    @Override
    public IPMPlanElementRW getPlanElementRW() {
        return this.getPlanElement();
    }

    @Override
    public String getRole() {
        return this.getPersistentFigure().getRole();
    }

    public void setPlanElement(PMPlanElement planElement) {
        this.setPlanElement((Object)planElement);
    }

    @Override
    public void setPlanElement(IPMPlanElementRW planElement) {
        this.setPlanElement((Object)planElement);
    }

    private void setPlanElement(Object planElement) {
        assert (planElement == null || planElement instanceof PMPlanElement) : "planElement is not instance of PMPlanElement";
        this.planElement = (PMPlanElement)planElement;
    }

    @Override
    public void setRole(String role) {
        this.getPersistentFigure().setRole(role);
    }

    @Override
    public int getGraphicalSupplementCount() {
        return this.graphicalSupplements.size();
    }

    public int getGraphicalSupplementIndex(PMGraphicalSupplement graphicalSupplement) {
        return this.getGraphicalSupplementIndex((Object)graphicalSupplement);
    }

    @Override
    public int getGraphicalSupplementIndex(IPMGraphicalSupplementRO graphicalSupplement) {
        return this.getGraphicalSupplementIndex((Object)graphicalSupplement);
    }

    @Override
    public int getGraphicalSupplementIndex(IPMGraphicalSupplementRW graphicalSupplement) {
        return this.getGraphicalSupplementIndex((Object)graphicalSupplement);
    }

    private int getGraphicalSupplementIndex(Object graphicalSupplement) {
        assert (graphicalSupplement != null) : "graphicalSupplement is null";
        assert (graphicalSupplement instanceof PMGraphicalSupplement) : "graphicalSupplement is not instance of PMGraphicalSupplement";
        return this.graphicalSupplements.indexOf(graphicalSupplement);
    }

    public List getGraphicalSupplements(String role) {
        assert (role != null) : "role is null";
        ArrayList<PMGraphicalSupplement> graphicalSupplementsFound = new ArrayList<PMGraphicalSupplement>();
        int i = 0;
        while (i < this.getGraphicalSupplementCount()) {
            PMGraphicalSupplement graphicalSupplement = this.getGraphicalSupplement(i);
            if (graphicalSupplement.getRole().equals(role)) {
                graphicalSupplementsFound.add(graphicalSupplement);
            }
            ++i;
        }
        return graphicalSupplementsFound;
    }

    public <T> List<T> getGraphicalSupplementsTyped(String role, Class<T> clazz) {
        assert (role != null) : "role is null";
        ArrayList<PMGraphicalSupplement> graphicalSupplementsFound = new ArrayList<PMGraphicalSupplement>();
        int i = 0;
        while (i < this.getGraphicalSupplementCount()) {
            PMGraphicalSupplement graphicalSupplement = this.getGraphicalSupplement(i);
            if (graphicalSupplement.getRole().equals(role) && clazz.isInstance(graphicalSupplement)) {
                graphicalSupplementsFound.add(graphicalSupplement);
            }
            ++i;
        }
        return graphicalSupplementsFound;
    }

    public PMGraphicalSupplement getGraphicalSupplement(int index) {
        assert (index >= 0) : "index<0";
        assert (index < this.getGraphicalSupplementCount()) : "index >= getGraphicalSupplementCount()";
        return this.graphicalSupplements.get(index);
    }

    @Override
    public IPMGraphicalSupplementRO getGraphicalSupplementRO(int index) {
        return this.getGraphicalSupplement(index);
    }

    @Override
    public IPMGraphicalSupplementRW getGraphicalSupplementRW(int index) {
        return this.getGraphicalSupplement(index);
    }

    @Override
    public void addGraphicalSupplement(IPMGraphicalSupplementRW graphicalSupplement, int index) {
        assert (graphicalSupplement != null) : "graphicalSupplement is null";
        assert (graphicalSupplement instanceof PMGraphicalSupplement) : "graphicalSupplement in not instance of PMGraphicalSupplement";
        assert (index <= this.getGraphicalSupplementCount()) : "index > getGraphicalSupplementCount()";
        PMGraphicalSupplement pMGraphicalSupplement = (PMGraphicalSupplement)graphicalSupplement;
        this.graphicalSupplements.add(index, (PMGraphicalSupplement)graphicalSupplement);
        this.getPersistentFigure().addGraphicalSupplement(pMGraphicalSupplement.getPersistentGraphicalSupplement(), index);
        this.flushGeometryCaches();
    }

    @Override
    public void removeGraphicalSupplement(int index) {
        assert (index >= 0) : "i<0";
        assert (index < this.getGraphicalSupplementCount()) : "index >= getGraphicalSupplementCount()";
        this.graphicalSupplements.remove(index);
        this.getPersistentFigure().removeGraphicalSupplement(index);
        this.flushGeometryCaches();
    }

    @Override
    public int getReferenceCount() {
        return this.references.size();
    }

    public int getReferenceIndex(PMReferenceGraphicalSupplementToFigure reference) {
        return this.getReferenceIndex((Object)reference);
    }

    @Override
    public int getReferenceIndex(IPMReferenceGraphicalSupplementToFigureRW reference) {
        return this.getReferenceIndex((Object)reference);
    }

    @Override
    public int getReferenceIndex(IPMReferenceGraphicalSupplementToFigureRO reference) {
        return this.getReferenceIndex((Object)reference);
    }

    private int getReferenceIndex(Object reference) {
        assert (reference != null) : "reference is null";
        assert (reference instanceof PMReferenceGraphicalSupplementToFigure) : "reference is not instance of PMReferenceGraphicalSupplementToFigure";
        return this.references.indexOf(reference);
    }

    public PMReferenceGraphicalSupplementToFigure getReference(int index) {
        assert (index >= 0) : "index<0";
        assert (index < this.getReferenceCount()) : "index >= getReferenceCount()";
        return this.references.get(index);
    }

    @Override
    public IPMReferenceGraphicalSupplementToFigureRO getReferenceRO(int index) {
        return this.getReference(index);
    }

    @Override
    public IPMReferenceGraphicalSupplementToFigureRW getReferenceRW(int index) {
        return this.getReference(index);
    }

    public List getReferences(String role) {
        assert (role != null) : "role is null";
        ArrayList<PMReferenceGraphicalSupplementToFigure> referencesFound = new ArrayList<PMReferenceGraphicalSupplementToFigure>();
        int i = 0;
        while (i < this.getReferenceCount()) {
            PMReferenceGraphicalSupplementToFigure reference = this.getReference(i);
            if (reference.getRole().equals(role)) {
                referencesFound.add(reference);
            }
            ++i;
        }
        return referencesFound;
    }

    public void addReference(PMReferenceGraphicalSupplementToFigure reference, int index) {
        this.addReference((Object)reference, index);
    }

    @Override
    public void addReference(IPMReferenceGraphicalSupplementToFigureRW reference, int index) {
        this.addReference((Object)reference, index);
    }

    private void addReference(Object reference, int index) {
        assert (reference != null) : "reference is null";
        assert (reference instanceof PMReferenceGraphicalSupplementToFigure) : "reference in not instance of PMReferenceGraphicalSupplementToFigure";
        assert (index <= this.getReferenceCount()) : "index > getReferenceCount()";
        PMReferenceGraphicalSupplementToFigure pMReference = (PMReferenceGraphicalSupplementToFigure)reference;
        this.references.add(index, pMReference);
    }

    @Override
    public void removeReference(int index) {
        assert (index >= 0) : "i<0";
        assert (index < this.getReferenceCount()) : "index >= getReferenceCount()";
        this.references.remove(index);
    }

    @Override
    public int getAnchoringCount() {
        return this.anchorings.size();
    }

    public int getAnchoringIndex(PMAnchoringPointToFigure anchoring) {
        return this.getAnchoringIndex((Object)anchoring);
    }

    @Override
    public int getAnchoringIndex(IPMAnchoringPointToFigureRO anchoring) {
        return this.getAnchoringIndex((Object)anchoring);
    }

    @Override
    public int getAnchoringIndex(IPMAnchoringPointToFigureRW anchoring) {
        return this.getAnchoringIndex((Object)anchoring);
    }

    private int getAnchoringIndex(Object anchoring) {
        assert (anchoring != null) : "anchoring is null";
        assert (anchoring instanceof PMAnchoringPointToFigure) : "anchoring is not instance of PMAnchoringFigure";
        return this.anchorings.indexOf(anchoring);
    }

    public PMAnchoringPointToFigure getAnchoring(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.getAnchoringCount()) : "index >= getAnchoringCount()";
        return (PMAnchoringPointToFigure)this.anchorings.get(index);
    }

    @Override
    public IPMAnchoringPointToFigureRO getAnchoringRO(int index) {
        return this.getAnchoring(index);
    }

    @Override
    public IPMAnchoringPointToFigureRW getAnchoringRW(int index) {
        return this.getAnchoring(index);
    }

    public void addAnchoring(PMAnchoringPointToFigure anchoring, int index) {
        this.addAnchoring((Object)anchoring, index);
    }

    @Override
    public void addAnchoring(IPMAnchoringPointToFigureRW anchoring, int index) {
        this.addAnchoring((Object)anchoring, index);
    }

    private void addAnchoring(Object anchoring, int index) {
        assert (anchoring != null) : "anchoring is null";
        assert (anchoring instanceof PMAnchoringPointToFigure) : "anchoring is not instance of PMAnchoringPointToFigure";
        assert (index >= 0 && index <= this.getAnchoringCount()) : "index is out of bounds";
        this.anchorings.add(index, anchoring);
    }

    @Override
    public void removeAnchoring(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getAnchoringCount()) : "i >= getAnchoringCount()";
        this.anchorings.remove(i);
    }

    @Override
    public Collection getChildViewables() {
        return this.graphicalSupplements;
    }

    @Override
    public PMViewable getParentViewable() {
        return this.planElement;
    }

    protected void constructPMFigure(PMPlanElement pe) {
        this.setPlanElement(pe);
        super.constructPMPlanObject();
    }

    protected void move(GeoVector v) {
        assert (v != null) : "v = null";
        this.getPointList().move(v);
        int i = 0;
        while (i < this.getGraphicalSupplementCount()) {
            this.getGraphicalSupplement(i).move(v);
            ++i;
        }
    }

    @Override
    protected void removeLinks() {
        super.removeLinks();
        while (this.getGraphicalSupplementCount() > 0) {
            this.removeGraphicalSupplement(0);
        }
        while (this.getAnchoringCount() > 0) {
            this.removeAnchoring(0);
        }
        this.setPlanElement(null);
    }

    @Override
    public IPMSemanticalUnit getSemanticalUnit() {
        return this.getPlanElement();
    }

    @Override
    public IPMFigureRO getAnchoringFigure() {
        return this;
    }

    @Override
    public IAnchoringSourcePoint getSourceEndPoint() {
        return null;
    }

    @Override
    public IAnchoringSourcePoint getSourceNoneEndPoint() {
        return null;
    }

    @Override
    public IAnchoringSourceLine getSourceLine() {
        return null;
    }

    public Collection getChildSourceContributors() {
        return this.getPointList().getSourceContributorsToAnchor();
    }

    @Override
    public Rectangle getSourceContributorOuterBounds() {
        return this.getOuterBounds();
    }

    @Override
    public IAnchoringDestination getRootDestination() {
        return this.getPlanElement().getRootDestination(this);
    }

    @Override
    public IAnchoringSourceContributor getDestinationRelatedSourceContributor() {
        return this;
    }

    public Collection getIAnchorings() {
        return this.anchorings;
    }

    @Override
    public Points getAnchoringDestinationPosition() {
        return this.getPointList().getPoints();
    }

    @Override
    public boolean isAnchoringDestinationClosedDraw() {
        return this.isClosedDraw();
    }

    @Override
    public Polygon getAnchoringDestinationPositionAsPolygon() {
        return this.getPolygon();
    }

    @Override
    public Double getAnchoringDestinationWidth() {
        return this.getWidth();
    }

    @Override
    public Rectangle getAnchoringDestinationOuterBounds() {
        return this.getOuterBoundsWithoutChildren();
    }

    @Override
    public IAnchoringDestinationFigure getDestinationFigure() {
        return this;
    }

    @Override
    public IAnchoringDestinationPoint getDestinationPoint() {
        return null;
    }

    @Override
    public IAnchoringDestinationLine getDestinationLine() {
        return null;
    }

    public Collection getChildDestinationContributors() {
        return this.getPointList().getDestinationContributorsToAnchor();
    }

    @Override
    public Rectangle getDestinationContributorOuterBounds() {
        return this.getOuterBounds();
    }

    @Override
    protected String getUid() {
        return this.getPersistentFigure().getUid();
    }

    public ILineAppearance getLineAppearance() {
        return this.lineAppearanceProxy;
    }

    @Override
    public ILineAppearanceRO getLineAppearanceRO() {
        return this.getLineAppearance();
    }

    @Override
    public ILineAppearance getLineAppearanceRW() {
        return this.getLineAppearance();
    }

    @Override
    public IPMPlanObjectRO.PlanObjectEditType getPlanObjectEditType() {
        return this.getPlanElement().getFigureEditType(this);
    }

    public List getAllAnchors() {
        ArrayList<PMAnchor> anchors = new ArrayList<PMAnchor>();
        PMPointList pointList = this.getPointList();
        int lineCount = pointList.getLineCount();
        int lineIdx = 0;
        while (lineIdx < lineCount) {
            PMLine line = pointList.getLine(lineIdx);
            int anchorCount = line.getAnchorCount();
            int anchorIdx = 0;
            while (anchorIdx < anchorCount) {
                PMAnchor anchor = line.getAnchor(anchorIdx);
                anchors.add(anchor);
                ++anchorIdx;
            }
            ++lineIdx;
        }
        return anchors;
    }

    public Points getPoints() {
        return this.getPointList().getPoints();
    }

    public Corners getCorners() {
        PMPointList pointList = this.getPointList();
        int pointCount = pointList.getPointCount();
        Corners corners = new Corners(pointCount);
        int pointIdx = 0;
        while (pointIdx < pointCount) {
            PMPoint point = pointList.getPoint(pointIdx);
            Point position = point.getPosition();
            Corner corner = position instanceof Corner ? new Corner((Corner)position) : (this.getLineAppearance().getCornerRadiusInfinity() ? new Corner(position) : new Corner(position, this.getLineAppearance().getCornerRadius()));
            corners.add((Point)corner);
            ++pointIdx;
        }
        return corners;
    }

    @Override
    protected Double getWidth() {
        return new Double(this.getLineAppearance().getLineThickness() * this.getLineAppearance().getLineStyle().getWidthFactor());
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        Polygon outline = this.getPolygon();
        Rectangle outerBounds = outline != null ? outline.getBounds() : this.getPointList().getPoints().getBounds();
        int i = 0;
        while (i < this.getPointList().getLineCount()) {
            PMLine line = this.getPointList().getLine(i);
            int j = 0;
            while (j < line.getAnchorCount()) {
                PMAnchor anchor = line.getAnchor(j);
                outerBounds = outerBounds == null ? anchor.getDestinationContributorOuterBounds() : outerBounds.union(anchor.getDestinationContributorOuterBounds());
                ++j;
            }
            ++i;
        }
        if (outerBounds != null) {
            EALineAppearance lineAppearance = this.getPersistentFigure().getLineAppearance();
            double lineWidth = lineAppearance.getLineThickness();
            double lineWidthFactor = lineAppearance.getLineStyle().getWidthFactor();
            double lineWidthExpansion = lineWidth * lineWidthFactor / 2.0;
            outerBounds = outerBounds.expand(lineWidthExpansion, lineWidthExpansion, lineWidthExpansion, lineWidthExpansion);
        }
        return outerBounds;
    }

    @Override
    protected Polygon createPolygon() {
        return new Polygon(this.getCorners(), this.isClosedDraw());
    }

    protected abstract boolean isClosedDraw();

    @Override
    public boolean isHighlightable() {
        return this.planElement.isHighlightableFigure(this);
    }

    static abstract class FigureFactory
    extends PMPlanObject.PlanObjectFactory {
        FigureFactory() {
        }

        @Override
        public List<? extends EOEncodableObject> getChildren(EncodableObjectBase eo) {
            EOFigure eoFigure = (EOFigure)eo;
            List<? extends EOEncodableObject> children = super.getChildren(eo);
            int supplementIndex = 0;
            while (supplementIndex < eoFigure.getGraphicalSupplementCount()) {
                children.add((EOEncodableObject)eoFigure.getGraphicalSupplement(supplementIndex));
                ++supplementIndex;
            }
            return children;
        }
    }

    private class LineAppearanceProxy
    implements ILineAppearance {
        private LineAppearanceProxy() {
        }

        @Override
        public double getCornerRadius() {
            return PMFigure.this.getPersistentFigure().getLineAppearance().getCornerRadius();
        }

        @Override
        public boolean getCornerRadiusInfinity() {
            return PMFigure.this.getPersistentFigure().getLineAppearance().getCornerRadiusInfinity();
        }

        @Override
        public Color getLineColor() {
            return PMFigure.this.getPersistentFigure().getLineAppearance().getLineColor();
        }

        @Override
        public double getLineThickness() {
            return PMFigure.this.getPersistentFigure().getLineAppearance().getLineThickness();
        }

        @Override
        public void setCornerRadius(double cornerRadius) {
            PMFigure.this.getPersistentFigure().getLineAppearance().setCornerRadius(cornerRadius);
            PMFigure.this.flushGeometryCaches();
        }

        @Override
        public void setCornerRadiusInfinity() {
            PMFigure.this.getPersistentFigure().getLineAppearance().setCornerRadiusInfinity();
            PMFigure.this.flushGeometryCaches();
        }

        @Override
        public void setLineColor(Color lineColor) {
            PMFigure.this.getPersistentFigure().getLineAppearance().setLineColor(lineColor);
        }

        @Override
        public void setLineThickness(double lineThickness) {
            PMFigure.this.getPersistentFigure().getLineAppearance().setLineThickness(lineThickness);
            PMFigure.this.flushGeometryCaches();
        }

        @Override
        public void setLineStyle(LineStyle lineStyle) {
            assert (lineStyle != null) : "lineStyle is null";
            PMFigure.this.getPersistentFigure().getLineAppearance().setLineStyle(lineStyle);
        }

        @Override
        public LineStyle getLineStyle() {
            return PMFigure.this.getPersistentFigure().getLineAppearance().getLineStyle();
        }

        @Override
        public void setAppearanceFrom(IAppearanceRO appearance) {
            if (!(appearance instanceof ILineAppearanceRO)) {
                return;
            }
            ILineAppearanceRO lineAppearance = (ILineAppearanceRO)appearance;
            LineAppearance.copy(lineAppearance, this);
        }

        @Override
        public IAppearanceRO getAppearanceAsCopy() {
            return new LineAppearance(this);
        }
    }
}

