/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.planagent.planmodel.access.readonly.IPMAnchorRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointToAnchorRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToAnchorRW;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectCrosslinkException;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectLinker;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMAnchor;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPoint;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.EOAnchoringPoint;
import com.arcway.planagent.planmodel.persistent.EOAnchoringPointToAnchor;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.List;

public class PMAnchoringPointToAnchor
extends PMAnchoringPoint
implements IPMAnchoringPointToAnchorRO,
IPMAnchoringPointToAnchorRW {
    private PMAnchor anchor = null;
    private final EOAnchoringPointToAnchor persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOAnchoringPointToAnchor.class, new AnchoringPointToAnchorFactory());
    }

    protected PMAnchoringPointToAnchor(PlanModelMgr planModelMgr, EOAnchoringPointToAnchor eo) {
        super(planModelMgr);
        this.persistent = eo;
    }

    protected EOAnchoringPointToAnchor getPersistentAnchoringPointToAnchor() {
        return this.persistent;
    }

    @Override
    protected EOAnchoringPoint getPersistentAnchoringPoint() {
        return this.getPersistentAnchoringPointToAnchor();
    }

    protected PMAnchoringPointToAnchor(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOAnchoringPointToAnchor();
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) throws EXPlanModelObjectCrosslinkException {
        PMAnchor anch = (PMAnchor)LoadPlanModelObjectLinker.getObjectByUIDAndCheckType(objectList, this.getPersistentAnchoringPointToAnchor().getAnchorUid(), PMAnchor.class, "anchor");
        anch.linkCrossLinkToPointToAnchorAnchoring(this);
        this.anchor = anch;
    }

    @Override
    protected List<? extends Object> getCrosslinked() {
        List crosslinked = super.getCrosslinked();
        crosslinked.add(this.anchor);
        return crosslinked;
    }

    public PMAnchor getAnchor() {
        return this.anchor;
    }

    @Override
    public IPMAnchorRO getAnchorRO() {
        return this.getAnchor();
    }

    @Override
    public IPMAnchorRW getAnchorRW() {
        return this.getAnchor();
    }

    public void setAnchor(PMAnchor anchor) {
        this.setAnchor((Object)anchor);
    }

    @Override
    public void setAnchor(IPMAnchorRW anchor) {
        this.setAnchor((Object)anchor);
    }

    private void setAnchor(Object anchor) {
        PMAnchor pMAnchor;
        assert (anchor == null || anchor instanceof PMAnchor) : "anchor is not instance of PMAnchor";
        this.anchor = pMAnchor = (PMAnchor)anchor;
        if (anchor == null) {
            this.getPersistentAnchoringPointToAnchor().setAnchorUid(null);
        } else {
            this.getPersistentAnchoringPointToAnchor().setAnchorUid(pMAnchor.getPersistentAnchor().getUid());
        }
    }

    @Override
    protected void removeLinks() {
        super.removeLinks();
        this.setAnchor(null);
    }

    protected PMAnchoringPointToAnchor(PlanModelMgr planModelMgr, PMPoint point, PMAnchor anchor) {
        super(planModelMgr);
        this.persistent = new EOAnchoringPointToAnchor();
        this.constructPMAnchoring(point);
        this.setAnchor(anchor);
    }

    @Override
    public void delete() {
        super.delete();
        if (this.getAnchor() != null) {
            this.getAnchor().removeAnchoring(this);
            this.setAnchor(null);
        }
    }

    @Override
    public IAnchoringDestination getAnchoringDestination() {
        return this.getAnchoringDestinationPoint();
    }

    @Override
    public IAnchoringDestinationPoint getAnchoringDestinationPoint() {
        return this.getAnchor();
    }

    @Override
    public boolean isDesirable() {
        return this.getPoint().getPlanElement().getPlan().getAnchoringDecider().isDesirableAnchoring(this.getAnchoringSource(), this.getAnchoringDestination());
    }

    @Override
    public boolean isValid() {
        if (this.getPoint() == null || this.getPoint().getAnchoring() != this) {
            return false;
        }
        return this.getAnchor() != null && this.getAnchor().getAnchoringIndex(this) >= 0;
    }

    static class AnchoringPointToAnchorFactory
    extends PMAnchoringPoint.AnchoringPointFactory {
        AnchoringPointToAnchorFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) {
            return new PMAnchoringPointToAnchor(planModelMgr, (EOAnchoringPointToAnchor)eo);
        }

        @Override
        public List getChildren(EncodableObjectBase eo) {
            return super.getChildren(eo);
        }
    }
}

