/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.polygon.PolygonCorner;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchorRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointToAnchorRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import com.arcway.planagent.planmodel.implementation.IPMSemanticalUnit;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPoint;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToAnchor;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPlanObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.EOAnchor;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PMAnchor
extends PMPlanModelObject
implements IPMAnchorRO,
IPMAnchorRW {
    private PMLine line = null;
    private final ArrayList<PMAnchoringPointToAnchor> anchorings = new ArrayList();
    private final EOAnchor persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOAnchor.class, new AnchorFactory());
    }

    protected PMAnchor(PlanModelMgr planModelMgr, EOAnchor eo) {
        super(planModelMgr);
        this.persistent = eo;
    }

    protected EOAnchor getPersistentAnchor() {
        return this.persistent;
    }

    @Override
    protected EOPlanModelObject getPersistentPlanModelObject() {
        return this.getPersistentAnchor();
    }

    protected PMAnchor(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOAnchor();
    }

    @Override
    protected void linkToParent(PMPlanModelObject parent) {
        this.line = (PMLine)parent;
    }

    @Override
    protected void linkToChild(PMPlanModelObject child) {
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) {
    }

    @Override
    protected List<PMPlanModelObject> getChildren() {
        ArrayList<PMPlanModelObject> children = new ArrayList<PMPlanModelObject>(0);
        return children;
    }

    protected void linkCrossLinkToPointToAnchorAnchoring(PMAnchoringPointToAnchor anchoring) {
        assert (anchoring != null) : "anchoring is null";
        this.anchorings.add(anchoring);
    }

    protected void linkToAnchoring(PMAnchoringPointToAnchor anchoring) {
        this.anchorings.add(anchoring);
    }

    @Override
    protected void setUID(String newUID) {
        super.setUID(newUID);
        for (PMAnchoringPointToAnchor anchoring : this.anchorings) {
            anchoring.setAnchor(this);
        }
    }

    public PMLine getLine() {
        return this.line;
    }

    @Override
    public IPMLineRO getLineRO() {
        return this.getLine();
    }

    @Override
    public IPMLineRW getLineRW() {
        return this.getLine();
    }

    public void setLine(PMLine line) {
        this.setLine((Object)line);
    }

    @Override
    public void setLine(IPMLineRW line) {
        this.setLine((Object)line);
    }

    private void setLine(Object line) {
        assert (line == null || line instanceof PMLine) : "line is not instance of PMLine";
        this.line = (PMLine)line;
    }

    @Override
    public int getAnchoringCount() {
        return this.anchorings.size();
    }

    public int getAnchoringIndex(PMAnchoringPointToAnchor anchoring) {
        return this.getAnchoringIndex((Object)anchoring);
    }

    @Override
    public int getAnchoringIndex(IPMAnchoringPointToAnchorRO anchoring) {
        return this.getAnchoringIndex((Object)anchoring);
    }

    @Override
    public int getAnchoringIndex(IPMAnchoringPointToAnchorRW anchoring) {
        return this.getAnchoringIndex((Object)anchoring);
    }

    private int getAnchoringIndex(Object anchoring) {
        assert (anchoring != null) : "anchoring is null";
        assert (anchoring instanceof PMAnchoringPointToAnchor) : "anchoring is not instance of PMAnchoringAnchor";
        return this.anchorings.indexOf(anchoring);
    }

    public PMAnchoringPointToAnchor getAnchoring(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.getAnchoringCount()) : "index >= getAnchoringCount()";
        return this.anchorings.get(index);
    }

    @Override
    public IPMAnchoringPointToAnchorRO getAnchoringRO(int index) {
        return this.getAnchoring(index);
    }

    @Override
    public IPMAnchoringPointToAnchorRW getAnchoringRW(int index) {
        return this.getAnchoring(index);
    }

    public void addAnchoring(PMAnchoringPointToAnchor anchoring, int i) {
        this.addAnchoring((Object)anchoring, i);
    }

    @Override
    public void addAnchoring(IPMAnchoringPointToAnchorRW anchoring, int i) {
        this.addAnchoring((Object)anchoring, i);
    }

    private void addAnchoring(Object anchoring, int i) {
        assert (anchoring != null) : "anchoring is null";
        assert (anchoring instanceof PMAnchoringPointToAnchor) : "anchoring is not instance of PMAnchoringAnchor";
        assert (i >= 0 && i <= this.getAnchoringCount()) : "i is out of bounds";
        this.anchorings.add(i, (PMAnchoringPointToAnchor)anchoring);
    }

    protected void removeAnchoring(PMAnchoringPointToAnchor anchoring) {
        assert (this.anchorings.indexOf(anchoring) >= 0) : "anchoring is not related to this anchor";
        this.anchorings.remove(anchoring);
    }

    @Override
    public void removeAnchoring(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getAnchoringCount()) : "i >= getAnchoringCount()";
        this.anchorings.remove(i);
    }

    private PMPlanObject getPlanObject() {
        return this.getLine().getPlanObject();
    }

    @Override
    public IPMPlanObjectRO getPlanObjectRO() {
        return this.getPlanObject();
    }

    @Override
    public IPMPlanObjectRW getPlanObjectRW() {
        return this.getPlanObject();
    }

    private PMPlanElement getPlanElement() {
        return this.getLine().getPlanElement();
    }

    @Override
    public IPMPlanElementRO getPlanElementRO() {
        return this.getPlanElement();
    }

    @Override
    public IPMPlanElementRW getPlanElementRW() {
        return this.getPlanElement();
    }

    protected void removeLinks() {
        while (this.getAnchoringCount() > 0) {
            this.removeAnchoring(0);
        }
        this.setLine(null);
    }

    protected PMAnchor(PlanModelMgr planModelMgr, PMLine line) {
        super(planModelMgr);
        this.persistent = new EOAnchor();
        this.setLine(line);
    }

    protected void deleteAllChildren() {
        this.deleteAllAnchorings();
    }

    private void deleteAllAnchorings() {
        while (this.getAnchoringCount() > 0) {
            PMAnchoringPointToAnchor anchoring = this.getAnchoring(0);
            ((PMAnchoringPoint)anchoring).delete();
        }
    }

    public void delete() {
        this.deleteAllAnchorings();
        this.getLine().removeAnchor(this.getLine().getAnchorIndex(this));
        this.setLine(null);
    }

    public PMAnchoringPointToAnchor createAnchoring(PMPoint point) {
        PMAnchoringPointToAnchor anchoring = new PMAnchoringPointToAnchor(this.getPlanModelMgr(), point, this);
        this.addAnchoring(anchoring, this.getAnchoringCount());
        point.setAnchoring(anchoring);
        return anchoring;
    }

    @Override
    public IPMSemanticalUnit getSemanticalUnit() {
        return this.getPlanElement();
    }

    @Override
    public IPMFigureRO getAnchoringFigure() {
        return this.getLine().getAnchoringFigure();
    }

    @Override
    public IAnchoringDestination getRootDestination() {
        return this.getPlanElement().getRootDestination(this);
    }

    @Override
    public IAnchoringSourceContributor getDestinationRelatedSourceContributor() {
        PMFigure relatedDestinations = null;
        PMPlanObject planObject = this.getPlanObject();
        if (planObject instanceof PMFigure) {
            PMFigure figure;
            relatedDestinations = figure = (PMFigure)planObject;
        }
        return relatedDestinations;
    }

    @Override
    public Collection<? extends IAnchoring> getIAnchorings() {
        return this.anchorings;
    }

    @Override
    public Point getAnchoringDestinationPosition() {
        return this.getAbsolutePosition();
    }

    @Override
    public PolygonCorner getAnchoringDestinationPositionOnPolygon() {
        return null;
    }

    @Override
    public Double getAnchoringDestinationWidth() {
        return null;
    }

    @Override
    public Rectangle getAnchoringDestinationOuterBounds() {
        return this.getOuterBounds();
    }

    @Override
    public IAnchoringDestinationFigure getDestinationFigure() {
        return null;
    }

    @Override
    public IAnchoringDestinationPoint getDestinationPoint() {
        return this;
    }

    @Override
    public IAnchoringDestinationLine getDestinationLine() {
        return null;
    }

    @Override
    public Collection<? extends IAnchoringDestinationContributor> getChildDestinationContributors() {
        return null;
    }

    @Override
    public Rectangle getDestinationContributorOuterBounds() {
        return this.getOuterBounds();
    }

    private Rectangle getOuterBounds() {
        Point anchorPosition = this.getAnchoringDestinationPosition();
        return new Rectangle(anchorPosition, new Dimension(0.0, 0.0));
    }

    @Override
    protected String getUid() {
        return this.getPersistentAnchor().getUid();
    }

    @Override
    public double getRelativePosition() {
        return this.persistent.getPosition();
    }

    @Override
    public void setRelativePosition(double position) {
        assert (position > -1.0E-10) : "position < 0";
        assert (position < 1.0000000001) : "position > 1";
        this.persistent.setPosition(position);
    }

    @Override
    public GeoVector getOffset() {
        return this.persistent.getOffset();
    }

    @Override
    public void setOffset(GeoVector offset) {
        this.persistent.setOffset(offset);
    }

    @Override
    public Point getAbsolutePosition() {
        Point directionEndPoint;
        Point startPoint = this.getLine().getPoint(this.getRelativePosition());
        Point directionStartPoint = this.getLine().getPoint1stRO().getPosition();
        if (GeoVector.getDistance((Point)directionStartPoint, (Point)(directionEndPoint = this.getLine().getPoint2ndRO().getPosition())) <= 1.0E-10) {
            return Point.getAsPoint((Point)startPoint);
        }
        GeoVector offset = this.getOffset().turn(GeoVector.getDifferenceVectorAngle((Point)directionStartPoint, (Point)directionEndPoint));
        return startPoint.movePoint(offset);
    }

    static class AnchorFactory
    extends PMPlanModelObject.PlanModelObjectFactory {
        AnchorFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) {
            return new PMAnchor(planModelMgr, (EOAnchor)eo);
        }

        @Override
        public List<? extends EOEncodableObject> getChildren(EncodableObjectBase eo) {
            return super.getChildren(eo);
        }
    }
}

