/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeListener;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeMgrRO;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeMgrRW;
import com.arcway.planagent.planmodel.implementation.ModelChange;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ModelChangeMgr
implements IModelChangeMgrRO,
IModelChangeMgrRW {
    private static final ILogger logger = Logger.getLogger(ModelChangeMgr.class);
    private final Set<IModelChangeListener> modelChangeListeners = new HashSet<IModelChangeListener>();

    @Override
    public void addModelChangeListener(IModelChangeListener modelChangeListener) {
        this.modelChangeListeners.add(modelChangeListener);
    }

    @Override
    public void removeModelChangeListener(IModelChangeListener modelChangeListener) {
        this.modelChangeListeners.remove(modelChangeListener);
    }

    public void fireModelChanged(Set modelChanges) {
        IModelChangeListener modelChangeListener;
        IModelChangeListener element;
        Iterator<IModelChangeListener> iterator;
        if (logger.isDebugEnabled(55)) {
            logger.debug(55, "   __ Fire Model Change Events: ");
            for (ModelChange modelChange : modelChanges) {
                logger.debug(55, "      - " + modelChange.toString());
            }
            logger.debug(55, "      to listeners: ");
            iterator = this.modelChangeListeners.iterator();
            while (iterator.hasNext()) {
                modelChangeListener = element = iterator.next();
                logger.debug(55, "      - " + modelChangeListener.toString());
            }
        }
        if (modelChanges.size() > 0) {
            iterator = this.modelChangeListeners.iterator();
            while (iterator.hasNext()) {
                modelChangeListener = element = iterator.next();
                modelChangeListener.modelChanged(modelChanges);
            }
        }
    }
}

