/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectCrosslinkException;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import java.util.List;

public class LoadPlanModelObjectLinker {
    private final LoadPlanModelObjectList objectList;

    public LoadPlanModelObjectLinker(LoadPlanModelObjectList objectList) {
        this.objectList = objectList;
    }

    public static void linkParentChild(PMPlanModelObject parent, PMPlanModelObject child) {
        if (child != null && parent != null) {
            child.linkToParent(parent);
            parent.linkToChild(child);
        }
    }

    public void linkCrossLinks(PMPlanModelObject root) throws EXPlanModelObjectCrosslinkException {
        assert (root != null) : "root must not be null";
        root.linkCrossLinks(root, this.objectList);
        List<PMPlanModelObject> children = root.getChildren();
        for (PMPlanModelObject child : children) {
            this.linkCrossLinks(child);
        }
    }

    public static PMPlanModelObject getObjectByUIDAndCheckType(LoadPlanModelObjectList objectList, String uid, Class expectedClass, String errorMessage) throws EXPlanModelObjectCrosslinkException {
        assert (PMPlanModelObject.class.isAssignableFrom(expectedClass)) : "expectedClass is not assignable to PMPlanModelObject";
        PMPlanModelObject destination = objectList.get(uid);
        if (destination == null) {
            throw new EXPlanModelObjectCrosslinkException("No object with UID " + uid + " was found.");
        }
        if (!expectedClass.isInstance(destination)) {
            if (errorMessage == null) {
                throw new EXPlanModelObjectCrosslinkException("The object with UID " + uid + " is not of expected type.");
            }
            throw new EXPlanModelObjectCrosslinkException("The object with UID " + uid + " is not of type " + errorMessage + ".");
        }
        return destination;
    }
}

