/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.appearance;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearance;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;

public class LineAppearance
implements ILineAppearance {
    private LineStyle lineStyle = DEFAULT_LINESTYLE;
    private double lineThickness = 0.35277777777777775;
    private int lineColorRed = 0;
    private int lineColorGreen = 0;
    private int lineColorBlue = 0;
    private boolean lineColorTransparent = false;
    private double cornerRadius = 0.0;
    private boolean cornerRadiusInfinity = false;

    public static void copy(ILineAppearanceRO source, ILineAppearance target) {
        target.setLineStyle(source.getLineStyle());
        target.setLineThickness(source.getLineThickness());
        target.setLineColor(source.getLineColor());
        if (source.getCornerRadiusInfinity()) {
            target.setCornerRadiusInfinity();
        } else {
            target.setCornerRadius(source.getCornerRadius());
        }
    }

    public LineAppearance() {
    }

    public LineAppearance(ILineAppearanceRO source) {
        this.setAppearanceFrom(source);
    }

    public LineAppearance(Color color, LineStyle lineStyle, double lineWidth) {
        this.setLineColor(color);
        this.setLineStyle(lineStyle);
        this.setLineThickness(lineWidth);
    }

    @Override
    public double getLineThickness() {
        return this.lineThickness;
    }

    @Override
    public Color getLineColor() {
        if (this.lineColorTransparent) {
            return new Color(Color.TRANSPARENT);
        }
        return new Color(this.lineColorRed, this.lineColorGreen, this.lineColorBlue);
    }

    @Override
    public double getCornerRadius() {
        return this.cornerRadius;
    }

    @Override
    public boolean getCornerRadiusInfinity() {
        return this.cornerRadiusInfinity;
    }

    @Override
    public void setLineThickness(double lineThickness) {
        assert (lineThickness > -1.0E-10);
        this.lineThickness = lineThickness;
    }

    @Override
    public void setLineColor(Color lineColor) {
        assert (lineColor != null);
        this.lineColorRed = lineColor.r;
        this.lineColorGreen = lineColor.g;
        this.lineColorBlue = lineColor.b;
        this.lineColorTransparent = lineColor.transparent;
    }

    @Override
    public void setCornerRadius(double cornerRadius) {
        assert (cornerRadius > -1.0E-10);
        this.cornerRadiusInfinity = false;
        this.cornerRadius = cornerRadius;
    }

    @Override
    public void setCornerRadiusInfinity() {
        this.cornerRadiusInfinity = true;
    }

    @Override
    public void setLineStyle(LineStyle lineStyle) {
        assert (lineStyle != null);
        this.lineStyle = lineStyle;
    }

    @Override
    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof ILineAppearanceRO)) {
            return;
        }
        ILineAppearanceRO line = (ILineAppearanceRO)appearance;
        this.setCornerRadius(line.getCornerRadius());
        if (line.getCornerRadiusInfinity()) {
            this.setCornerRadiusInfinity();
        }
        this.setLineColor(line.getLineColor());
        this.setLineStyle(line.getLineStyle());
        this.setLineThickness(line.getLineThickness());
    }

    @Override
    public IAppearanceRO getAppearanceAsCopy() {
        return new LineAppearance(this);
    }
}

