/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.anchoring;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.geometry.polygon.PolygonCorner;
import com.arcway.lib.geometry.polygon.PolygonLine;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.AnchoringContributorTraverser;
import com.arcway.planagent.planmodel.anchoring.AnchoringDecision;
import com.arcway.planagent.planmodel.anchoring.AnchoringProposal;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringContext;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringManager;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceVisitor;
import com.arcway.planagent.planmodel.anchoring.VisitAnchoringPossibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AnchoringAgent {
    private static final ILogger logger = Logger.getLogger(AnchoringAgent.class);
    private final IAnchoringManager anchoringManager;

    public AnchoringAgent(IAnchoringManager anchoringManager) {
        this.anchoringManager = anchoringManager;
    }

    public ActionIterator removeAnchorings(Collection<? extends IAnchoringSourceContributor> sourceContributors, Collection<? extends IAnchoringDestinationContributor> destinationContributorsToProtect, ActionContext actionContext) {
        if (logger.isDebugEnabled(56)) {
            logger.debug(56, "  ~ **** Starting anchoring agent: remove anchorings **** ");
        }
        PredeterminedActionIterator removeAnchoringActions = new PredeterminedActionIterator();
        RemoveAnchoringVisitor visitor = new RemoveAnchoringVisitor(destinationContributorsToProtect, actionContext, removeAnchoringActions);
        AnchoringContributorTraverser.traverseSourcesAll(sourceContributors, null, (IAnchoringSourceVisitor)visitor);
        if (logger.isDebugEnabled(56)) {
            logger.debug(56, "  ~ **** Anchoring agent finished **** ");
        }
        return removeAnchoringActions;
    }

    private static Action createRemoveAnchoringAction(IAnchoringSource source, ActionContext actionContext) {
        if (logger.isDebugEnabled(56)) {
            logger.debug(56, "  ~ ~ root anchoring action removed: " + source + " --> " + source.getIAnchoring().getAnchoringDestination());
        }
        return ActionFactory.createACRemoveAnchoring(actionContext, source.getIAnchoring());
    }

    public ActionIterator createAnchorings(Collection<? extends IAnchoringSourceContributor> sourceContributors, Collection<? extends IAnchoringDestinationContributor> destinationContributors, ActionContext actionContext) {
        IAnchoringContext anchoringContext = actionContext.getActionParameters().getAnchoringContext();
        if (logger.isDebugEnabled(56)) {
            logger.debug(56, "  ~ **** Starting anchoring agent: create anchorings **** ");
        }
        List<? extends IAnchoringSourceContributor> sourceContributorsOnPlan = this.anchoringManager.getAnchoringSourceContributors();
        List<? extends IAnchoringDestinationContributor> destinationContributorsOnPlan = this.anchoringManager.getAnchoringDestinationContributors();
        Collection<IAnchoringSourceContributor> filteredSourceContributorsOnPlan = this.filterIrrelevantSourceContributors(destinationContributors, sourceContributorsOnPlan, anchoringContext);
        Collection<IAnchoringDestinationContributor> filteredDestinationContributorsOnPlan = this.filterIrrelevantDestinationContributors(sourceContributors, destinationContributorsOnPlan, anchoringContext);
        HashMap<IAnchoringSource, Map<IAnchoringDestination, AnchoringProposal>> rootSourceToAnchoringProposals = new HashMap<IAnchoringSource, Map<IAnchoringDestination, AnchoringProposal>>(1000);
        CheckAnchoring checkToAnchorVisitor = new CheckAnchoring(anchoringContext, rootSourceToAnchoringProposals);
        AnchoringContributorTraverser.traverseAllAnchoringPossibilitesForSourceContributors(sourceContributors, filteredDestinationContributorsOnPlan, checkToAnchorVisitor, anchoringContext);
        AnchoringContributorTraverser.traverseAllAnchoringPossibilitesForSourceContributors(filteredSourceContributorsOnPlan, destinationContributors, checkToAnchorVisitor, anchoringContext);
        if (logger.isDebugEnabled(56)) {
            logger.debug(56, "  ~ Number of rootSources with anchoring proposals: " + rootSourceToAnchoringProposals.size());
        }
        if (logger.isDebugEnabled(56)) {
            logger.debug(56, "  ~ **** Anchoring agent finished **** ");
        }
        return this.decideAnchorings(rootSourceToAnchoringProposals, actionContext);
    }

    private Collection<IAnchoringSourceContributor> filterIrrelevantSourceContributors(Collection<? extends IAnchoringDestinationContributor> destinationContributors, Collection<? extends IAnchoringSourceContributor> sourceContributorsOnPlan, IAnchoringContext anchoringContext) {
        double anchoringTolerance = anchoringContext.getAnchoringTolerance();
        Rectangle destinationBounds = null;
        for (IAnchoringDestinationContributor iAnchoringDestinationContributor : destinationContributors) {
            destinationBounds = destinationBounds == null ? iAnchoringDestinationContributor.getDestinationContributorOuterBounds() : destinationBounds.union(iAnchoringDestinationContributor.getDestinationContributorOuterBounds());
        }
        if (destinationBounds != null) {
            destinationBounds = destinationBounds.expand(anchoringTolerance + anchoringTolerance);
        }
        ArrayList<IAnchoringSourceContributor> arrayList = new ArrayList<IAnchoringSourceContributor>();
        if (destinationBounds != null) {
            for (IAnchoringSourceContributor iAnchoringSourceContributor : sourceContributorsOnPlan) {
                Rectangle sourceBounds = iAnchoringSourceContributor.getSourceContributorOuterBounds();
                if (sourceBounds == null || !destinationBounds.intersects(sourceBounds)) continue;
                arrayList.add(iAnchoringSourceContributor);
            }
        }
        return arrayList;
    }

    private Collection<IAnchoringDestinationContributor> filterIrrelevantDestinationContributors(Collection<? extends IAnchoringSourceContributor> sourceContributors, Collection<? extends IAnchoringDestinationContributor> destinationContributorsOnPlan, IAnchoringContext anchoringContext) {
        double anchoringTolerance = anchoringContext.getAnchoringTolerance();
        Rectangle sourceBounds = null;
        for (IAnchoringSourceContributor iAnchoringSourceContributor : sourceContributors) {
            sourceBounds = sourceBounds == null ? iAnchoringSourceContributor.getSourceContributorOuterBounds() : sourceBounds.union(iAnchoringSourceContributor.getSourceContributorOuterBounds());
        }
        if (sourceBounds != null) {
            sourceBounds = sourceBounds.expand(anchoringTolerance + anchoringTolerance);
        }
        ArrayList<IAnchoringDestinationContributor> arrayList = new ArrayList<IAnchoringDestinationContributor>();
        if (sourceBounds != null) {
            for (IAnchoringDestinationContributor iAnchoringDestinationContributor : destinationContributorsOnPlan) {
                Rectangle destinationBounds = iAnchoringDestinationContributor.getDestinationContributorOuterBounds();
                if (destinationBounds == null || !sourceBounds.intersects(destinationBounds)) continue;
                arrayList.add(iAnchoringDestinationContributor);
            }
        }
        return arrayList;
    }

    private ActionIterator decideAnchorings(Map<IAnchoringSource, Map<IAnchoringDestination, AnchoringProposal>> rootSourceToAnchoringProposals, ActionContext actionContext) {
        PredeterminedActionIterator anchoringsActionIterator = new PredeterminedActionIterator(rootSourceToAnchoringProposals.size());
        for (Map.Entry<IAnchoringSource, Map<IAnchoringDestination, AnchoringProposal>> entry : rootSourceToAnchoringProposals.entrySet()) {
            IAnchoringSource rootSource = entry.getKey();
            Collection<AnchoringProposal> proposals = entry.getValue().values();
            AnchoringDecision decision = this.anchoringManager.getAnchoringDecider().decideAnchoring(rootSource, proposals);
            if (decision == null || !decision.isToAnchor()) continue;
            if (logger.isDebugEnabled(56)) {
                logger.debug(56, "  ~ anchoring decided: " + decision.getRootSource() + " --> " + decision.getRootDestination());
            }
            Collection<Action> anchoringActions = this.anchor(decision, actionContext);
            anchoringsActionIterator.addActions(anchoringActions);
        }
        return anchoringsActionIterator;
    }

    private Collection<Action> anchor(AnchoringDecision decision, ActionContext actionContext) {
        IAnchoringSource rootSource = decision.getRootSource();
        IAnchoringDestination rootDestination = decision.getRootDestination();
        ArrayList<Action> anchoringActions = new ArrayList<Action>(1);
        Action rootAnchoringAction = ActionFactory.createACCreateAnchoring(actionContext, rootSource, rootDestination);
        if (rootAnchoringAction != null) {
            anchoringActions.add(rootAnchoringAction);
            if (logger.isDebugEnabled(56)) {
                logger.debug(56, "  ~ ~ root anchoring action added: " + rootSource + " --> " + rootDestination);
            }
        }
        return anchoringActions;
    }

    private static void checkSourceAndDestination(IAnchoringSource source, IAnchoringDestination destination, IAnchoringContext anchoringContext, Map<IAnchoringSource, Map<IAnchoringDestination, AnchoringProposal>> rootSourceToAnchoringProposals) {
        boolean rootDestinationIsRelatedToSource;
        IAnchoringDestination rootDestination;
        IAnchoringSource rootSource;
        if (logger.isDebugEnabled(56)) {
            logger.debug(56, "  ~ check source vs. destination: " + source + " --> " + destination);
        }
        if ((rootSource = source.getRootSource()) == null) {
            rootSource = source;
        }
        if ((rootDestination = destination.getRootDestination()) == null) {
            rootDestination = destination;
        }
        ArrayList<IAnchoringDestinationContributor> sourceRelatedDestinations = new ArrayList<IAnchoringDestinationContributor>();
        AnchoringAgent.addSourceRelatedDestinations(rootSource, sourceRelatedDestinations);
        Collection<IAnchoringSource> childSources = rootSource.getChildSources();
        if (childSources != null) {
            Iterator<IAnchoringSource> iterator = childSources.iterator();
            while (iterator.hasNext()) {
                IAnchoringSource iAnchoringSource;
                IAnchoringSource childSource = iAnchoringSource = iterator.next();
                AnchoringAgent.addSourceRelatedDestinations(childSource, sourceRelatedDestinations);
            }
        }
        if (!(rootDestinationIsRelatedToSource = AnchoringContributorTraverser.isDestinationContained(sourceRelatedDestinations, rootDestination))) {
            AnchoringProposal proposal;
            if (logger.isDebugEnabled(56)) {
                logger.debug(56, "  ~ ~ root destination is not related to root source");
            }
            if ((proposal = AnchoringAgent.doTouch(source, destination, anchoringContext)) != null) {
                if (logger.isDebugEnabled(56)) {
                    logger.debug(56, "  ~ ~ source touches destination");
                }
                AnchoringAgent.addAnchoringProposal(rootSource, proposal, rootSourceToAnchoringProposals);
            }
        }
    }

    private static void addSourceRelatedDestinations(IAnchoringSource source, Collection<IAnchoringDestinationContributor> destinationContributors) {
        IAnchoringDestinationContributor sourceRelatedDestinations = source.getSourceRelatedDestinationContributor();
        if (sourceRelatedDestinations != null) {
            destinationContributors.add(sourceRelatedDestinations);
        }
    }

    private static void addAnchoringProposal(IAnchoringSource rootSource, AnchoringProposal newProposal, Map<IAnchoringSource, Map<IAnchoringDestination, AnchoringProposal>> rootSourceToAnchoringProposals) {
        AnchoringProposal oldProposal;
        Map<IAnchoringDestination, AnchoringProposal> proposals = rootSourceToAnchoringProposals.get(rootSource);
        if (proposals == null) {
            proposals = new HashMap<IAnchoringDestination, AnchoringProposal>();
            rootSourceToAnchoringProposals.put(rootSource, proposals);
        }
        if ((oldProposal = proposals.get(newProposal.getDestination())) == null) {
            proposals.put(newProposal.getDestination(), newProposal);
            if (logger.isDebugEnabled(56)) {
                logger.debug(56, "  ~ ~ *** -> Proposal added: " + newProposal);
            }
        } else if (newProposal.getDestination() == oldProposal.getDestination()) {
            oldProposal.merge(newProposal);
            if (logger.isDebugEnabled(56)) {
                logger.debug(56, "  ~ ~ *** -> Proposal merged: " + oldProposal);
            }
        } else assert (false) : "old proposal found, but with wrong destination";
    }

    private static AnchoringProposal doTouch(IAnchoringSource source, IAnchoringDestination destination, IAnchoringContext anchoringContext) {
        if (logger.isDebugEnabled(56)) {
            logger.debug(56, "  ~ ~ check if source touches destination: " + source + " --> " + destination);
        }
        double distance = Double.POSITIVE_INFINITY;
        double anchoringTolerance = anchoringContext.getAnchoringTolerance();
        if (source instanceof IAnchoringSourcePoint) {
            if (destination instanceof IAnchoringDestinationFigure) {
                distance = AnchoringAgent.getDistance((IAnchoringSourcePoint)source, (IAnchoringDestinationFigure)destination);
            } else if (destination instanceof IAnchoringDestinationLine) {
                distance = AnchoringAgent.getDistance((IAnchoringSourcePoint)source, (IAnchoringDestinationLine)destination);
            } else if (destination instanceof IAnchoringDestinationPoint) {
                distance = AnchoringAgent.getDistance((IAnchoringSourcePoint)source, (IAnchoringDestinationPoint)destination);
            }
        } else if (source instanceof IAnchoringSourceLine && destination instanceof IAnchoringDestinationLine) {
            distance = AnchoringAgent.getDistance((IAnchoringSourceLine)source, (IAnchoringDestinationLine)destination);
        }
        AnchoringProposal proposal = null;
        if (distance < anchoringTolerance + 1.0E-10) {
            proposal = new AnchoringProposal(destination, distance);
            if (logger.isDebugEnabled(56)) {
                logger.debug(56, "  ~ ~ ~ ---> distance " + distance + " <= anchoringTolerance " + anchoringTolerance + " ==> proposal created");
            }
        } else if (logger.isDebugEnabled(56)) {
            logger.debug(56, "  ~ ~ ~ ---> distance " + distance + " > anchoringTolerance " + anchoringTolerance + " ==> no proposal created");
        }
        return proposal;
    }

    public static double getDistance(IAnchoringSourcePoint sourcePoint, IAnchoringDestinationFigure destinationFigure) {
        double distance = Double.POSITIVE_INFINITY;
        Polygon polygon = destinationFigure.getAnchoringDestinationPositionAsPolygon();
        if (polygon != null) {
            distance = polygon.getDistanceToBorder(sourcePoint.getAnchoringSourcePosition());
        } else {
            boolean closed = destinationFigure.isAnchoringDestinationClosedDraw();
            distance = destinationFigure.getAnchoringDestinationPosition().getDistanceToBorder(sourcePoint.getAnchoringSourcePosition(), closed);
        }
        distance = AnchoringAgent.subtractHalfLineWidth(distance, sourcePoint.getAnchoringSourceWidth());
        distance = AnchoringAgent.subtractHalfLineWidth(distance, destinationFigure.getAnchoringDestinationWidth());
        return distance;
    }

    public static double getDistance(IAnchoringSourcePoint sourcePoint, IAnchoringDestinationLine destinationLine) {
        double distance = Double.POSITIVE_INFINITY;
        PolygonLine polygonLine = destinationLine.getAnchoringDestinationPositionOnPolygon();
        distance = polygonLine != null ? polygonLine.getDistanceToBorder(sourcePoint.getAnchoringSourcePosition()) : destinationLine.getAnchoringDestinationPosition().getDistance(sourcePoint.getAnchoringSourcePosition());
        distance = AnchoringAgent.subtractHalfLineWidth(distance, sourcePoint.getAnchoringSourceWidth());
        distance = AnchoringAgent.subtractHalfLineWidth(distance, destinationLine.getAnchoringDestinationWidth());
        return distance;
    }

    public static double getDistance(IAnchoringSourcePoint sourcePoint, IAnchoringDestinationPoint destinationPoint) {
        double distance = Double.POSITIVE_INFINITY;
        PolygonCorner point = destinationPoint.getAnchoringDestinationPositionOnPolygon();
        distance = point != null ? new GeoVector(sourcePoint.getAnchoringSourcePosition(), (Point)point).abs() : new GeoVector(sourcePoint.getAnchoringSourcePosition(), destinationPoint.getAnchoringDestinationPosition()).abs();
        distance = AnchoringAgent.subtractHalfLineWidth(distance, sourcePoint.getAnchoringSourceWidth());
        distance = AnchoringAgent.subtractHalfLineWidth(distance, destinationPoint.getAnchoringDestinationWidth());
        return distance;
    }

    public static double getDistance(IAnchoringSourceLine sourceLine, IAnchoringDestinationLine destinationLine) {
        Line destinationLineLine;
        double distance = Double.POSITIVE_INFINITY;
        Line sourceLineLine = sourceLine.getAnchoringSourcePosition();
        if (sourceLineLine.isParallel(destinationLineLine = destinationLine.getAnchoringDestinationPosition())) {
            distance = Math.min(distance, sourceLineLine.getDistance(destinationLineLine.start));
            distance = Math.min(distance, sourceLineLine.getDistance(destinationLineLine.end));
            distance = Math.min(distance, destinationLineLine.getDistance(sourceLineLine.start));
            distance = Math.min(distance, destinationLineLine.getDistance(sourceLineLine.end));
        }
        distance = AnchoringAgent.subtractHalfLineWidth(distance, sourceLine.getAnchoringSourceWidth());
        distance = AnchoringAgent.subtractHalfLineWidth(distance, destinationLine.getAnchoringDestinationWidth());
        return distance;
    }

    private static double subtractHalfLineWidth(double val, Double lineWidth) {
        double value = val;
        if (lineWidth != null) {
            value = (value -= lineWidth / 2.0) <= 1.0E-10 ? 0.0 : value;
        }
        return value;
    }

    private static class CheckAnchoring
    implements VisitAnchoringPossibility {
        private final IAnchoringContext anchoringContext;
        private final Map<IAnchoringSource, Map<IAnchoringDestination, AnchoringProposal>> rootSourceToAnchoringProposals;

        public CheckAnchoring(IAnchoringContext anchoringContext, Map<IAnchoringSource, Map<IAnchoringDestination, AnchoringProposal>> rootSourceToAnchoringProposals) {
            this.anchoringContext = anchoringContext;
            this.rootSourceToAnchoringProposals = rootSourceToAnchoringProposals;
        }

        @Override
        public boolean visit(IAnchoringSource source, IAnchoringDestination destination) {
            AnchoringAgent.checkSourceAndDestination(source, destination, this.anchoringContext, this.rootSourceToAnchoringProposals);
            return false;
        }
    }

    private static class RemoveAnchoringVisitor
    implements IAnchoringSourceVisitor {
        private final Collection<? extends IAnchoringDestinationContributor> destinationContributorsToProtect;
        private final ActionContext actionContext;
        private final PredeterminedActionIterator removeAnchoringActions;

        public RemoveAnchoringVisitor(Collection<? extends IAnchoringDestinationContributor> destinationContributorsToProtect, ActionContext actionContext, PredeterminedActionIterator removeAnchoringActions) {
            this.destinationContributorsToProtect = destinationContributorsToProtect;
            this.actionContext = actionContext;
            this.removeAnchoringActions = removeAnchoringActions;
        }

        @Override
        public boolean visit(IAnchoringSource source) {
            IAnchoringDestination destination;
            IAnchoring anchoring = source.getIAnchoring();
            if (anchoring != null && !AnchoringContributorTraverser.isDestinationContained(this.destinationContributorsToProtect, destination = anchoring.getAnchoringDestination())) {
                Action removeAnchoringAction = AnchoringAgent.createRemoveAnchoringAction(source, this.actionContext);
                this.removeAnchoringActions.addAction(removeAnchoringAction);
            }
            return false;
        }
    }
}

