/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionIterator;

public abstract class DelayingActionIterator
extends ActionIterator {
    private static final ILogger logger = Logger.getLogger(DelayingActionIterator.class);
    private ActionIterator actionIterator = null;

    @Override
    public final boolean hasNext() {
        if (logger.isTraceEnabled()) {
            logger.trace("Delaying Action Iterator - hasNext() - start " + this);
        }
        this.setActionIterator();
        boolean hasNext = this.actionIterator.hasNext();
        if (logger.isTraceEnabled()) {
            logger.trace("Delaying Action Iterator - hasNext() - end; return: " + hasNext);
        }
        return hasNext;
    }

    @Override
    public final Action next() {
        if (logger.isTraceEnabled()) {
            logger.trace("Delaying Action Iterator - next() - start " + this);
        }
        this.setActionIterator();
        Action next = this.actionIterator.next();
        if (logger.isTraceEnabled()) {
            logger.trace("Delaying Action Iterator - next() - end; return: " + next);
        }
        return next;
    }

    private void setActionIterator() {
        if (this.actionIterator == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Delaying Action Iterator - createActionIterator() - start " + this);
            }
            this.actionIterator = this.createActionIterator();
            if (this.actionIterator == null) {
                this.actionIterator = ActionIterator.EMPTY_ACTION_ITERATOR;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Delaying Action Iterator - createActionIterator() - end; created: " + this.actionIterator);
            }
        }
    }

    protected abstract ActionIterator createActionIterator();
}

