/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import java.util.Iterator;
import java.util.List;

public class CheckerTool {
    public static boolean checkContainsIPMPlanElementRWsOnly(List planElements) {
        for (Object obj : planElements) {
            assert (obj instanceof IPMPlanElementRW) : "obj ist not instance of IPMPlanElementRW";
            if (obj instanceof IPMPlanElementRW) continue;
            return false;
        }
        return true;
    }

    public static boolean checkPlanElementIsValid(IPMPlanElementRW planElement) {
        assert (planElement.getPlanRW() != null) : "planElement is not linked to a plan";
        IPMPlanRW plan = planElement.getPlanRW();
        return plan.getPlanElementIndex(planElement) != -1;
    }

    public static boolean checkPlanElementsAreValid(List planElements) {
        assert (planElements.size() > 0) : "size of planElements <= 0";
        assert (CheckerTool.checkContainsIPMPlanElementRWsOnly(planElements));
        Iterator i = planElements.iterator();
        while (i.hasNext()) {
            if (CheckerTool.checkPlanElementIsValid((IPMPlanElementRW)i.next())) continue;
            return false;
        }
        Iterator k = planElements.iterator();
        IPMPlanElementRW planElement2 = (IPMPlanElementRW)k.next();
        IPMPlanRW plan = planElement2.getPlanRW();
        for (IPMPlanElementRW planElement2 : planElements) {
            if (planElement2.getPlanRW() == plan) continue;
            return false;
        }
        return true;
    }
}

