/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IActionTypeAgentManager;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectFactoryRW;
import com.arcway.planagent.planmodel.access.readwrite.IPlanModelMgrRW;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.actions.ActionTypeManager;

public class ActionContext {
    private static final boolean POSTPROCESSING_ENABLED = true;
    private final IPlanModelMgrRW planModelMgr;
    private final ActionParameters actionParameters;
    private ProcessingScope processingScope = ProcessingScope.MAINPROCESSORS;

    public ActionContext(ActionParameters actionParameters, IPlanModelMgrRW planModelMgr) {
        assert (actionParameters != null) : "actionParameters is null";
        assert (planModelMgr != null) : "planModelMgr is null";
        this.actionParameters = actionParameters;
        this.planModelMgr = planModelMgr;
    }

    public IPMPlanModelObjectFactoryRW getPlanModelObjectFactory() {
        return this.planModelMgr.getPlanModelObjectFactoryRW();
    }

    public IPlanModelMgrRW getPlanModelMgr() {
        return this.planModelMgr;
    }

    public ActionParameters getActionParameters() {
        return this.actionParameters;
    }

    public IActionTypeAgentManager getActionTypeAgentManager() {
        return ActionTypeManager.getInstance();
    }

    public ProcessingScope getProcessingScope() {
        return this.processingScope;
    }

    public void enablePostProcessorsOnly() {
        this.processingScope = ProcessingScope.POSTPROCESSORS;
    }

    public void enableAllProcessors() {
        this.processingScope = ProcessingScope.ALL;
    }

    public static enum ProcessingScope {
        MAINPROCESSORS,
        POSTPROCESSORS,
        ALL;

    }
}

