/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectFactoryRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.access.readwrite.IPlanModelMgrRW;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.Collection;
import java.util.Set;

public abstract class Action {
    public static final ILogger logger = Logger.getLogger(Action.class);
    private boolean firstDo = true;
    private boolean isValid = true;
    private final ActionContext actionContext;
    private Exception creationStackTrace = null;

    public Action(ActionContext actionContext) {
        if (logger.isDebugEnabled(52)) {
            this.creationStackTrace = new Exception();
            logger.debug("  ... Action: constructing " + this.getClass().getName(), (Throwable)this.creationStackTrace);
        }
        this.actionContext = actionContext;
    }

    public abstract boolean isDupe(Action var1);

    public abstract boolean isNop();

    public abstract ActionIterator getPreActionIterator();

    public final boolean validateAction() {
        if (!this.isValid) {
            logger.warn("Action " + this.toString() + " is not valid!");
        }
        return this.isValid;
    }

    protected final void setInvalid() {
        assert (this.firstDo) : "setInvalid called during or after action execution";
        this.isValid = false;
    }

    public final void dodo() {
        if (logger.isDebugEnabled(52)) {
            logger.debug(52, "  <... Action: do   " + this.toString());
        }
        this.firstDo = false;
        this.initializeState();
        this.setStateToPost();
        if (logger.isDebugEnabled(52)) {
            logger.debug(52, "  ...> Action: do   finished " + this.toString());
        }
    }

    public final void undo() {
        if (logger.isDebugEnabled(52)) {
            logger.debug(52, "  ... Action: undo " + this.toString());
        }
        this.setStateToPre();
    }

    public final void redo() {
        if (logger.isDebugEnabled(52)) {
            logger.debug(52, "  ... Action: redo " + this.toString());
        }
        this.setStateToPost();
    }

    protected abstract void setStateToPre();

    protected abstract void setStateToPost();

    protected void initializeState() {
    }

    public abstract Set<IModelChangeRW> getChanges();

    public abstract Collection<IEntryOfCompressedList> getEntriesForCompressedReactionList();

    public abstract IPMSemanticalUnitRW getSemanticalUnit();

    protected final ActionContext getActionContext() {
        return this.actionContext;
    }

    protected final IPMPlanModelObjectFactoryRW getIPlanModelObjectFactoryRW() {
        return this.getActionContext().getPlanModelObjectFactory();
    }

    public final IPlanModelMgrRW getPlanModelMgr() {
        return this.getActionContext().getPlanModelMgr();
    }
}

