/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.IActionTypeAgent;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import com.arcway.planagent.planmodel.reactions.IReactionPostprocessing;
import com.arcway.planagent.planmodel.reactions.ReactionAgentRegistry;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractActionTypeAgent
implements IActionTypeAgent {
    private final List allReactionAgents = new ArrayList();
    private final List mainProcessingReactionAgents = new ArrayList();
    private final List postProcessingReactionAgents = new ArrayList();

    protected AbstractActionTypeAgent() {
        List<Object> unfiltered = ReactionAgentRegistry.getInstance().getAllReactionAgents();
        int i = 0;
        while (i < unfiltered.size()) {
            Object reactionAgent = unfiltered.get(i);
            if (this.getFilterInterface().isAssignableFrom(reactionAgent.getClass())) {
                this.allReactionAgents.add(reactionAgent);
                if (reactionAgent instanceof IReactionPostprocessing) {
                    this.postProcessingReactionAgents.add(reactionAgent);
                } else {
                    this.mainProcessingReactionAgents.add(reactionAgent);
                }
            }
            ++i;
        }
    }

    protected List getReactionAgents(ActionContext actionContext) {
        List reactionAgents;
        ActionContext.ProcessingScope processingScope = actionContext.getProcessingScope();
        switch (processingScope) {
            case MAINPROCESSORS: {
                reactionAgents = this.mainProcessingReactionAgents;
                break;
            }
            case POSTPROCESSORS: {
                reactionAgents = this.postProcessingReactionAgents;
                break;
            }
            default: {
                reactionAgents = this.allReactionAgents;
            }
        }
        return reactionAgents;
    }

    protected abstract class AbstractEntryOfCompressedList
    implements IEntryOfCompressedList {
        @Override
        public Class<?> getActionType() {
            return AbstractActionTypeAgent.this.getFilterInterface();
        }
    }
}

