/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.java.New;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class ACSetPositionAnchor
extends Action {
    private final IPMAnchorRW anchor;

    public ACSetPositionAnchor(ActionContext actionContext, IPMAnchorRW anchor) {
        super(actionContext);
        assert (anchor != null) : "ref to anchor is null";
        this.anchor = anchor;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.anchor, 2));
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        IPMLineRW line = this.anchor.getLineRW();
        IPMPlanObjectRW planObject = line.getPlanObjectRW();
        if (planObject instanceof IPMFigureRW) {
            IPMFigureRW figure = (IPMFigureRW)planObject;
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionChangeGeometryAttributeFigureAgent().getEntryForCompressedList(figure, this.getActionContext()));
        }
        if (planObject instanceof IPMGraphicalSupplementRW) {
            HashMap changedSupplements = New.hashMap((int)1);
            changedSupplements.put((IPMGraphicalSupplementRW)planObject, null);
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionModifySupplementAgent().getEntryForCompressedList(changedSupplements, this.getActionContext()));
        }
        assert (false) : "line not part of supplement or figure";
        return null;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.anchor.getPlanElementRW();
    }

    public IPMAnchorRW getAnchor() {
        return this.anchor;
    }
}

