/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ACSetDescriptionPlanElement
extends Action {
    private final IPMPlanElementRW planElement;
    private final String newDesciption;
    private String oldDesciption;

    public ACSetDescriptionPlanElement(ActionContext actionContext, IPMPlanElementRW planElement, String description) {
        super(actionContext);
        assert (planElement != null) : "ref to planElement is null";
        this.planElement = planElement;
        this.newDesciption = description;
    }

    @Override
    protected void initializeState() {
        this.oldDesciption = this.planElement.getDescription();
    }

    @Override
    protected void setStateToPost() {
        this.planElement.setDescription(this.newDesciption);
    }

    @Override
    protected void setStateToPre() {
        this.planElement.setDescription(this.oldDesciption);
    }

    @Override
    public boolean isDupe(Action a) {
        ACSetDescriptionPlanElement dupeA;
        boolean isDupe = false;
        if (a instanceof ACSetDescriptionPlanElement && (dupeA = (ACSetDescriptionPlanElement)a).getPlanElement().equals(this.getPlanElement()) && dupeA.getNewDescription().equals(this.getNewDescription())) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    @Override
    public Set<IModelChangeRW> getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.planElement, 2));
        return changes;
    }

    @Override
    public Collection<IEntryOfCompressedList> getEntriesForCompressedReactionList() {
        return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionSetDescriptionAgent().getEntryForCompressedList(this.getPlanElement(), this.newDesciption, this.getActionContext()));
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.planElement;
    }

    public String getNewDescription() {
        return this.newDesciption;
    }

    public IPMPlanElementRW getPlanElement() {
        return this.planElement;
    }

    public String toString() {
        return "ACSetDescriptionPlanElement (plan element " + this.planElement + ", new description" + this.newDesciption + ")";
    }
}

