/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ACSetAspectIDPlanElement
extends Action {
    private final IPMPlanElementRW planElement;
    private final String newAspectID;
    private String oldAspectID;

    public ACSetAspectIDPlanElement(ActionContext actionContext, IPMPlanElementRW planElement, String aspectID) {
        super(actionContext);
        assert (planElement != null) : "ref to planElement is null";
        this.planElement = planElement;
        this.newAspectID = aspectID;
    }

    @Override
    protected void initializeState() {
        this.oldAspectID = this.planElement.getAspectID();
    }

    @Override
    protected void setStateToPost() {
        this.planElement.setAspectID(this.newAspectID);
    }

    @Override
    protected void setStateToPre() {
        this.planElement.setAspectID(this.oldAspectID);
    }

    @Override
    public boolean isDupe(Action a) {
        ACSetAspectIDPlanElement dupeA;
        boolean isDupe = false;
        if (a instanceof ACSetAspectIDPlanElement && (dupeA = (ACSetAspectIDPlanElement)a).getPlanElement().equals(this.getPlanElement()) && dupeA.getNewAspectID().equals(this.getNewAspectID())) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    @Override
    public Set<IModelChangeRW> getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.planElement, 2));
        return changes;
    }

    @Override
    public Collection<IEntryOfCompressedList> getEntriesForCompressedReactionList() {
        return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionSetAspectIDAgent().getEntryForCompressedList(this.getPlanElement(), this.newAspectID, this.getActionContext()));
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.planElement;
    }

    public String getNewAspectID() {
        return this.newAspectID;
    }

    public IPMPlanElementRW getPlanElement() {
        return this.planElement;
    }

    public String toString() {
        return "ACSetAspectIDPlanElement (plan element " + this.planElement + ", new aspect ID" + this.newAspectID + ")";
    }
}

