/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ACReorderPlanElementStructure
extends Action {
    private final List planElements;
    private final int newIndex;
    private boolean stateIsInitialized = false;
    private int[] planElementRemoveIndex;
    private int[] planElementInsertIndex;

    public ACReorderPlanElementStructure(ActionContext actionContext, Collection planElements, int newIndex) {
        super(actionContext);
        assert (planElements != null) : "planElements is null";
        assert (planElements.size() > 0) : "there is no sense in reordering 0 planElements";
        assert (newIndex >= 0) : "newIndex < 0";
        assert (this.checkNewIndexIsSmallerThanPlanElementCountOfPlan(planElements, newIndex)) : "newIndex is not smaller than planElementCount of Plan";
        this.planElements = new ArrayList(planElements);
        this.newIndex = newIndex;
    }

    @Override
    protected void initializeState() {
        Comparator comperator = new Comparator(){

            public int compare(Object o1, Object o2) {
                IPMPlanElementRW planElement1 = (IPMPlanElementRW)o1;
                IPMPlanElementRW planElement2 = (IPMPlanElementRW)o2;
                return ACReorderPlanElementStructure.getIndex(planElement1) - ACReorderPlanElementStructure.getIndex(planElement2);
            }
        };
        Collections.sort(this.planElements, comperator);
    }

    @Override
    protected void setStateToPost() {
        if (!this.planElements.isEmpty()) {
            IPMPlanElementRW firstPlanElement = (IPMPlanElementRW)this.planElements.get(0);
            IPMPlanRW plan = firstPlanElement.getPlanRW();
            if (!this.stateIsInitialized) {
                this.planElementRemoveIndex = new int[this.planElements.size()];
                this.planElementInsertIndex = new int[this.planElements.size()];
                int insertIdx = this.newIndex;
                int listIdx = 0;
                while (listIdx < this.planElements.size()) {
                    IPMPlanElementRW currentPlanElement = (IPMPlanElementRW)this.planElements.get(listIdx);
                    int removeIdx = ACReorderPlanElementStructure.getIndex(currentPlanElement);
                    plan.removePlanElement(removeIdx);
                    this.planElementRemoveIndex[listIdx] = removeIdx;
                    if (removeIdx < insertIdx) {
                        --insertIdx;
                    }
                    plan.addPlanElement(currentPlanElement, insertIdx);
                    this.planElementInsertIndex[listIdx] = insertIdx++;
                    ++listIdx;
                }
                this.stateIsInitialized = true;
            } else {
                int listIdx = 0;
                while (listIdx < this.planElements.size()) {
                    IPMPlanElementRW currentPlanElement = (IPMPlanElementRW)this.planElements.get(listIdx);
                    plan.removePlanElement(this.planElementRemoveIndex[listIdx]);
                    plan.addPlanElement(currentPlanElement, this.planElementInsertIndex[listIdx]);
                    ++listIdx;
                }
            }
        }
        if (logger.isDebugEnabled(52)) {
            logger.debug(52, "--> ReorderAction : setStateToPost() - end");
        }
    }

    @Override
    protected void setStateToPre() {
        if (!this.planElements.isEmpty()) {
            IPMPlanElementRW firstPlanElement = (IPMPlanElementRW)this.planElements.get(0);
            IPMPlanRW plan = firstPlanElement.getPlanRW();
            int listIdx = this.planElements.size() - 1;
            while (listIdx >= 0) {
                IPMPlanElementRW currentPlanElement = (IPMPlanElementRW)this.planElements.get(listIdx);
                plan.removePlanElement(this.planElementInsertIndex[listIdx]);
                plan.addPlanElement(currentPlanElement, this.planElementRemoveIndex[listIdx]);
                --listIdx;
            }
        }
    }

    private static int getIndex(IPMPlanElementRW planElement) {
        return planElement.getPlanRW().getPlanElementIndex(planElement);
    }

    @Override
    public boolean isDupe(Action a) {
        ACReorderPlanElementStructure dupeA;
        boolean isDupe = false;
        if (a instanceof ACReorderPlanElementStructure && (dupeA = (ACReorderPlanElementStructure)a).getNewIndex() == this.getNewIndex() && dupeA.getPlanElements() == this.getPlanElements()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        boolean isNop = false;
        if (this.planElements.isEmpty()) {
            isNop = true;
        }
        return isNop;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        if (!this.planElements.isEmpty()) {
            IPMPlanElementRW firstPlanElement = (IPMPlanElementRW)this.planElements.get(0);
            IPMPlanRW plan = firstPlanElement.getPlanRW();
            changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(plan, 2));
        }
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        IPMPlanRW plan = null;
        if (!this.planElements.isEmpty()) {
            IPMPlanElementRW firstPlanElement = (IPMPlanElementRW)this.planElements.get(0);
            plan = firstPlanElement.getPlanRW();
        }
        return plan;
    }

    public List getReorderdPlanElements() {
        return this.planElements;
    }

    public String toString() {
        if (this.planElements == null) {
            return "ACReorderPlanElementStructure";
        }
        return "ACReorderPlanElementStructure (number of plan elements: " + this.planElements.size() + ", target index: " + this.newIndex + ")";
    }

    private boolean checkNewIndexIsSmallerThanPlanElementCountOfPlan(Collection pes, int index) {
        Iterator i = pes.iterator();
        IPMPlanElementRW planElement = (IPMPlanElementRW)i.next();
        IPMPlanRW plan = planElement.getPlanRW();
        return index <= plan.getPlanElementCount();
    }

    public int getNewIndex() {
        return this.newIndex;
    }

    public List getPlanElements() {
        return this.planElements;
    }
}

