/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.java.New;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACAbstractModifyGeometryPointsInvariant;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ACRemovePoint
extends Action {
    private final IPMPointRW point;
    private List preStateGoemetry;

    public ACRemovePoint(ActionContext actionContext, IPMPointRW point) {
        super(actionContext);
        assert (point != null) : "ref to point is null";
        this.point = point;
    }

    public IPMPointRW getPoint() {
        return this.point;
    }

    @Override
    protected void initializeState() {
        this.preStateGoemetry = ACAbstractModifyGeometryPointsInvariant.getPreStateGeometry(this.point.getPlanObjectRW());
        super.initializeState();
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.point.getPlanElementRW();
    }

    @Override
    public boolean isNop() {
        return false;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.point.getPointListRW(), 2));
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        if (this.point.getPlanObjectRW() instanceof IPMFigureRW) {
            IPMFigureRW changedFigure = (IPMFigureRW)this.point.getPlanObjectRW();
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionChangeGeometryFigureAgent().getEntryForCompressedList(changedFigure, this.preStateGoemetry, this.getActionContext()));
        }
        if (this.point.getPlanObjectRW() instanceof IPMGraphicalSupplementRW) {
            HashMap changedSupplements = New.hashMap((int)1);
            changedSupplements.put((IPMGraphicalSupplementRW)this.point.getPlanObjectRW(), this.preStateGoemetry);
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionModifySupplementAgent().getEntryForCompressedList(changedSupplements, this.getActionContext()));
        }
        assert (false) : "point not part of supplement or figure";
        return null;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return new PredeterminedActionIterator();
    }
}

