/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringLineToLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACRemoveAnchoringLine;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import java.util.HashSet;
import java.util.Set;

public class ACRemoveAnchoringLineToLine
extends ACRemoveAnchoringLine {
    private IPMLineRW targetLine;
    private int targetIndex;

    public ACRemoveAnchoringLineToLine(ActionContext context, IPMAnchoringLineToLineRW anchoringLineToLine) {
        super(context, anchoringLineToLine);
        assert (anchoringLineToLine != null) : "ref to anchoringLineToLine is null";
    }

    @Override
    protected void initializeState() {
        super.initializeState();
        this.targetLine = this.getAnchoringLineToLine().getTargetLineRW();
        this.targetIndex = this.targetLine.getLineToLineAnchoringIndex(this.getAnchoringLineToLine());
    }

    @Override
    protected void setStateToPost() {
        super.setStateToPost();
        assert (this.targetIndex == this.targetLine.getLineToLineAnchoringIndex(this.getAnchoringLineToLine())) : "anchoring is not at the expected index of targetLine";
        this.targetLine.removeLineToLineAnchoring(this.targetIndex);
    }

    @Override
    protected void setStateToPre() {
        super.setStateToPre();
        this.targetLine.addLineToLineAnchoring(this.getAnchoringLineToLine(), this.targetIndex);
    }

    @Override
    public boolean isDupe(Action a) {
        ACRemoveAnchoringLineToLine dupeA;
        boolean isDupe = false;
        if (a instanceof ACRemoveAnchoringLineToLine && (dupeA = (ACRemoveAnchoringLineToLine)a).getAnchoringLineToLine() == this.getAnchoringLineToLine()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.getAnchoringLineToLine(), 3));
        return changes;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        assert (this.getAnchoringLineToLine().getLineRW().getPlanElementRW().getPlanRW() == this.getAnchoringLineToLine().getTargetLineRW().getPlanElementRW().getPlanRW()) : "the plan should be unique";
        return this.getAnchoringLineToLine().getLineRW().getPlanElementRW().getPlanRW();
    }

    public IPMAnchoringLineToLineRW getAnchoringLineToLine() {
        return (IPMAnchoringLineToLineRW)this.getAnchoringLine();
    }

    public String toString() {
        return "ACRemoveAnchoringLineToLine ()";
    }
}

