/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACRemoveAnchoringPointToAnchor;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ACRemoveAnchor
extends Action {
    private final IPMAnchorRW anchor;
    private IPMLineRW line;
    private int index;

    public ACRemoveAnchor(ActionContext actionContext, IPMAnchorRW anchor) {
        super(actionContext);
        assert (anchor != null) : "ref to anchor is null";
        this.anchor = anchor;
    }

    @Override
    protected void initializeState() {
        this.line = this.anchor.getLineRW();
        this.index = this.line.getAnchorIndex(this.anchor);
    }

    @Override
    protected void setStateToPost() {
        assert (this.index == this.line.getAnchorIndex(this.anchor)) : "anchor is not at the expected index";
        this.line.removeAnchor(this.index);
    }

    @Override
    protected void setStateToPre() {
        this.line.addAnchor(this.anchor, this.index);
    }

    @Override
    public boolean isDupe(Action a) {
        ACRemoveAnchor dupeA;
        boolean isDupe = false;
        if (a instanceof ACRemoveAnchor && (dupeA = (ACRemoveAnchor)a).getAnchor() == this.getAnchor()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        PredeterminedActionIterator preActions = new PredeterminedActionIterator(this.anchor.getAnchoringCount());
        int i = 0;
        while (i < this.anchor.getAnchoringCount()) {
            preActions.addAction(new ACRemoveAnchoringPointToAnchor(this.getActionContext(), this.anchor.getAnchoringRW(i)));
            ++i;
        }
        return preActions;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.anchor, 3));
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.anchor.getPlanElementRW();
    }

    public IPMAnchorRW getAnchor() {
        return this.anchor;
    }

    public String toString() {
        return "ACRemoveAnchor (anchor " + this.anchor + ")";
    }
}

