/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionTool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ACMovePlanObject
extends Action {
    private final List<? extends IPMPlanObjectRW> planObjects;
    private final GeoVector distance;
    private List sourcePositionArrayList;
    private List targetPositionArrayList;

    public ACMovePlanObject(ActionContext actionContext, List<? extends IPMPlanObjectRW> planObjects, GeoVector distance) {
        super(actionContext);
        assert (!planObjects.isEmpty()) : "the list of planObjects is empty";
        int i = 0;
        while (i < planObjects.size()) {
            assert (planObjects.get(i) instanceof IPMPlanObjectRW) : "List element is not of type IPMPlanObjectRW";
            ++i;
        }
        this.planObjects = planObjects;
        assert (distance != null) : "ref to distance is null";
        this.distance = distance;
    }

    @Override
    protected void initializeState() {
        this.sourcePositionArrayList = new ArrayList(this.planObjects.size());
        int i = 0;
        while (i < this.planObjects.size()) {
            this.sourcePositionArrayList.add(i, ActionTool.initializeSourcePositionsOfPlanObject(this.planObjects.get(i)));
            ++i;
        }
        this.targetPositionArrayList = new ArrayList(this.planObjects.size());
        i = 0;
        while (i < this.planObjects.size()) {
            this.targetPositionArrayList.add(i, ActionTool.calculateTargetPositionOfPlanObject(this.planObjects.get(i), this.distance));
            ++i;
        }
    }

    @Override
    protected void setStateToPost() {
        int i = 0;
        while (i < this.planObjects.size()) {
            ActionTool.setPositionOfPlanElement(this.planObjects.get(i), (Point[])this.targetPositionArrayList.get(i));
            ++i;
        }
    }

    @Override
    protected void setStateToPre() {
        int i = 0;
        while (i < this.planObjects.size()) {
            ActionTool.setPositionOfPlanElement(this.planObjects.get(i), (Point[])this.sourcePositionArrayList.get(i));
            ++i;
        }
    }

    @Override
    public boolean isNop() {
        boolean isNop = false;
        if (this.distance.abs() <= 1.0E-10) {
            isNop = true;
        }
        return isNop;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(this.planObjects.size());
        int i = 0;
        while (i < this.planObjects.size()) {
            IPMPlanObjectRW planObject = this.planObjects.get(i);
            changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(planObject.getPointListRW(), 2));
            ++i;
        }
        return changes;
    }

    public GeoVector getDistance() {
        return this.distance;
    }

    public List<? extends IPMPlanObjectRW> getPlanObjects() {
        return this.planObjects;
    }
}

