/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACAbstractModifyGeometryPointsInvariant;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import de.plans.lib.util.Ass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ACMoveLine
extends ACAbstractModifyGeometryPointsInvariant {
    private final IPMLineRW line;
    private final GeoVector distance;
    private IPMPointRW Point1st;
    private Point sourcePositionPoint1st;
    private Point targetPositionPoint1st;
    private IPMPointRW Point2nd;
    private Point sourcePositionPoint2nd;
    private Point targetPositionPoint2nd;

    public ACMoveLine(ActionContext actionContext, IPMLineRW line, GeoVector distance, boolean removeSourceAnchorings) {
        super(line.getPlanObjectRW(), removeSourceAnchorings, actionContext);
        Ass.ert((distance != null ? 1 : 0) != 0);
        this.line = line;
        this.distance = distance;
    }

    @Override
    protected void initializeState() {
        IPMLineRW line2nd;
        super.initializeState();
        this.Point1st = this.line.getPoint1stRW();
        this.sourcePositionPoint1st = this.Point1st.getPosition();
        this.Point2nd = this.line.getPoint2ndRW();
        this.sourcePositionPoint2nd = this.Point2nd.getPosition();
        GeoVector distance1st = this.distance;
        GeoVector distance2nd = this.distance;
        IPMLineRW line1st = this.Point1st.getLine1stRW();
        if (line1st != null) {
            if (line1st.getForce() == 2) {
                distance1st = new GeoVector(distance1st.x, 0.0);
            } else if (line1st.getForce() == 3) {
                distance1st = new GeoVector(0.0, distance1st.y);
            }
        }
        if ((line2nd = this.Point2nd.getLine2ndRW()) != null) {
            if (line2nd.getForce() == 2) {
                distance2nd = new GeoVector(distance2nd.x, 0.0);
            } else if (line2nd.getForce() == 3) {
                distance2nd = new GeoVector(0.0, distance2nd.y);
            }
        }
        this.targetPositionPoint1st = this.sourcePositionPoint1st.movePoint(distance1st);
        this.targetPositionPoint2nd = this.sourcePositionPoint2nd.movePoint(distance2nd);
    }

    @Override
    protected void setStateToPost() {
        this.Point1st.setPosition(this.targetPositionPoint1st);
        this.Point2nd.setPosition(this.targetPositionPoint2nd);
    }

    @Override
    protected void setStateToPre() {
        this.Point1st.setPosition(this.sourcePositionPoint1st);
        this.Point2nd.setPosition(this.sourcePositionPoint2nd);
    }

    @Override
    public boolean isDupe(Action a) {
        ACMoveLine dupeA;
        boolean isDupe = false;
        if (a instanceof ACMoveLine && (dupeA = (ACMoveLine)a).getLine() == this.getLine() && dupeA.getDistance() == this.getDistance()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        boolean isNop = false;
        if (this.distance.abs() <= 1.0E-10) {
            isNop = true;
        }
        return isNop;
    }

    @Override
    protected Collection getPrimaryAnchoringSourceContributors() {
        ArrayList<IAnchoringDestinationContributor> anchoringContributors = new ArrayList<IAnchoringDestinationContributor>(3);
        anchoringContributors.add(this.line);
        anchoringContributors.add(this.line.getPoint1stRW());
        anchoringContributors.add(this.line.getPoint2ndRW());
        return anchoringContributors;
    }

    @Override
    protected Collection getSecondaryAnchoringSourceContributors() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected Collection getAnchoringDestinationContributors() {
        ArrayList<IAnchoringDestinationContributor> anchoringContributors = new ArrayList<IAnchoringDestinationContributor>(3);
        anchoringContributors.add(this.line);
        anchoringContributors.add(this.line.getPoint1stRW());
        anchoringContributors.add(this.line.getPoint2ndRW());
        return anchoringContributors;
    }

    public IPMLineRW getLine() {
        return this.line;
    }

    public GeoVector getDistance() {
        return this.distance;
    }

    public String toString() {
        return "ACMoveLine (line " + this.line + ", distance" + this.distance + ")";
    }
}

