/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.java.New;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACMovePlanObject;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionTool;
import com.arcway.planagent.planmodel.anchoring.AnchoringAgent;
import com.arcway.planagent.planmodel.reactions.FigureMovements;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ACMoveFigures
extends ACMovePlanObject {
    private final List<IPMGraphicalSupplementRW> planObjectsGraphicalSupplements;
    private final boolean removeSourceAnchorings;
    private List sourcePositionArrayGraphicalSupplementList;
    private List targetPositionArrayGraphicalSupplementList;
    private final Map<IPMGraphicalSupplementRW, List<PositionAndPoint>> changes;

    public ACMoveFigures(ActionContext actionContext, List figures, GeoVector distance, boolean removeSourceAnchorings) {
        super(actionContext, figures, distance);
        int i = 0;
        while (i < figures.size()) {
            assert (figures.get(i) instanceof IPMFigureRW) : "List element is not of type IPMPFigureRW";
            ++i;
        }
        this.planObjectsGraphicalSupplements = new ArrayList<IPMGraphicalSupplementRW>();
        i = 0;
        while (i < figures.size()) {
            IPMFigureRW figure = (IPMFigureRW)figures.get(i);
            int j = 0;
            while (j < figure.getGraphicalSupplementCount()) {
                this.planObjectsGraphicalSupplements.add(figure.getGraphicalSupplementRW(j));
                ++j;
            }
            ++i;
        }
        this.changes = New.hashMap((int)this.planObjectsGraphicalSupplements.size());
        for (IPMGraphicalSupplementRW supplement : this.planObjectsGraphicalSupplements) {
            this.changes.put(supplement, null);
        }
        this.removeSourceAnchorings = removeSourceAnchorings;
    }

    @Override
    public boolean isDupe(Action a) {
        ACMoveFigures dupeA;
        boolean isDupe = false;
        if (a instanceof ACMoveFigures && (dupeA = (ACMoveFigures)a).getFigures() == this.getFigures() && dupeA.getDistance() == this.getDistance()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        IPMFigureRW figure = (IPMFigureRW)this.getFigures().get(0);
        return figure.getPlanElementRW().getPlanRW();
    }

    public List getFigures() {
        return this.getPlanObjects();
    }

    @Override
    protected void initializeState() {
        super.initializeState();
        this.sourcePositionArrayGraphicalSupplementList = new ArrayList(this.planObjectsGraphicalSupplements.size());
        int i = 0;
        while (i < this.planObjectsGraphicalSupplements.size()) {
            this.sourcePositionArrayGraphicalSupplementList.add(i, ActionTool.initializeSourcePositionsOfPlanObject(this.planObjectsGraphicalSupplements.get(i)));
            ++i;
        }
        this.targetPositionArrayGraphicalSupplementList = new ArrayList(this.planObjectsGraphicalSupplements.size());
        i = 0;
        while (i < this.planObjectsGraphicalSupplements.size()) {
            this.targetPositionArrayGraphicalSupplementList.add(i, ActionTool.calculateTargetPositionOfPlanObject(this.planObjectsGraphicalSupplements.get(i), this.getDistance()));
            ++i;
        }
    }

    @Override
    protected void setStateToPost() {
        super.setStateToPost();
        int i = 0;
        while (i < this.planObjectsGraphicalSupplements.size()) {
            ActionTool.setPositionOfPlanElement(this.planObjectsGraphicalSupplements.get(i), (Point[])this.targetPositionArrayGraphicalSupplementList.get(i));
            ++i;
        }
    }

    @Override
    protected void setStateToPre() {
        super.setStateToPre();
        int i = 0;
        while (i < this.planObjectsGraphicalSupplements.size()) {
            ActionTool.setPositionOfPlanElement(this.planObjectsGraphicalSupplements.get(i), (Point[])this.sourcePositionArrayGraphicalSupplementList.get(i));
            ++i;
        }
    }

    @Override
    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(this.planObjectsGraphicalSupplements.size());
        int i = 0;
        while (i < this.planObjectsGraphicalSupplements.size()) {
            IPMPlanObjectRW planObject = this.planObjectsGraphicalSupplements.get(i);
            changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(planObject.getPointListRW(), 2));
            ++i;
        }
        changes.addAll(super.getChanges());
        return changes;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        ActionIterator preActionIterator;
        if (!this.isNop() && this.removeSourceAnchorings) {
            ActionIterator removeAnchoringActionIterator;
            AnchoringAgent anchoringAgent = this.getPlanModelMgr().getAnchoringAgent();
            List figures = this.getFigures();
            preActionIterator = removeAnchoringActionIterator = anchoringAgent.removeAnchorings(figures, figures, this.getActionContext());
        } else {
            preActionIterator = ActionIterator.EMPTY_ACTION_ITERATOR;
        }
        return preActionIterator;
    }

    public Collection getEntriesForCompressedReactionList() {
        FigureMovements figureMovements = new FigureMovements();
        for (IPMPlanObjectRW iPMPlanObjectRW : this.getPlanObjects()) {
            IPMFigureRW figure = (IPMFigureRW)iPMPlanObjectRW;
            figureMovements.addMovement(figure, this.getDistance());
        }
        HashSet<IEntryOfCompressedList> hashSet = new HashSet<IEntryOfCompressedList>();
        hashSet.add(this.getActionContext().getActionTypeAgentManager().getReactionMoveFiguresAgent().getEntryForCompressedList(figureMovements, this.getActionContext()));
        hashSet.add(this.getActionContext().getActionTypeAgentManager().getReactionModifySupplementAgent().getEntryForCompressedList(this.changes, this.getActionContext()));
        return hashSet;
    }

    public String toString() {
        return "ACMoveFigure ()";
    }
}

