/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import java.util.ArrayList;
import java.util.Collection;

public class ACMove3Points2Lines
extends ACMovePoint {
    private final IPMLineRW firstLine = this.getPoint().getLine1stRW();
    private final IPMLineRW secondLine = this.getPoint().getLine2ndRW();
    private final IPMPointRW firstPoint = this.firstLine.getPoint1stRW();
    private Point sourcePositionFirstPoint;
    private Point targetPositionFirstPoint;
    private final IPMPointRW secondPoint;
    private Point sourcePositionSecondPoint;
    private Point targetPositionSecondPoint;

    public ACMove3Points2Lines(ActionContext context, IPMPointRW point, GeoVector distance, boolean removeSourceAnchorings) {
        super(context, point, distance, removeSourceAnchorings);
        assert (!this.firstPoint.equals(this.getPoint())) : "point should not be firstPoint";
        this.secondPoint = this.secondLine.getPoint2ndRW();
        assert (!this.secondPoint.equals(this.getPoint())) : "point should not be secondPoint";
    }

    @Override
    protected void initializeState() {
        GeoVector v_vector;
        GeoVector h_vector;
        super.initializeState();
        this.sourcePositionFirstPoint = this.firstPoint.getPosition();
        if (this.firstLine.getForce() == 2) {
            h_vector = new GeoVector(0.0, this.getDistance().y);
            this.targetPositionFirstPoint = this.sourcePositionFirstPoint.movePoint(h_vector);
        } else {
            assert (this.firstLine.getForce() == 3) : "line should have vertical force";
            v_vector = new GeoVector(this.getDistance().x, 0.0);
            this.targetPositionFirstPoint = this.sourcePositionFirstPoint.movePoint(v_vector);
        }
        this.sourcePositionSecondPoint = this.secondPoint.getPosition();
        if (this.secondLine.getForce() == 2) {
            h_vector = new GeoVector(0.0, this.getDistance().y);
            this.targetPositionSecondPoint = this.sourcePositionSecondPoint.movePoint(h_vector);
        } else {
            assert (this.secondLine.getForce() == 3) : "line should have vertical force";
            v_vector = new GeoVector(this.getDistance().x, 0.0);
            this.targetPositionSecondPoint = this.sourcePositionSecondPoint.movePoint(v_vector);
        }
    }

    @Override
    protected void setStateToPost() {
        super.setStateToPost();
        this.firstPoint.setPosition(this.targetPositionFirstPoint);
        this.secondPoint.setPosition(this.targetPositionSecondPoint);
    }

    @Override
    protected void setStateToPre() {
        super.setStateToPre();
        this.firstPoint.setPosition(this.sourcePositionFirstPoint);
        this.secondPoint.setPosition(this.sourcePositionSecondPoint);
    }

    @Override
    public boolean isDupe(Action a) {
        ACMove3Points2Lines dupeA;
        boolean isDupe = false;
        if (a instanceof ACMove3Points2Lines && (dupeA = (ACMove3Points2Lines)a).getPoint() == this.getPoint() && dupeA.getDistance() == this.getDistance()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    protected Collection getPrimaryAnchoringSourceContributors() {
        return super.getPrimaryAnchoringSourceContributors();
    }

    @Override
    protected Collection getSecondaryAnchoringSourceContributors() {
        ArrayList<IAnchoringDestinationContributor> anchoringContributors = new ArrayList<IAnchoringDestinationContributor>(super.getSecondaryAnchoringSourceContributors());
        anchoringContributors.add(this.firstPoint);
        if (this.firstPoint.getLine1stRW() != null) {
            anchoringContributors.add(this.firstPoint.getLine1stRW());
        }
        anchoringContributors.add(this.secondPoint);
        if (this.secondPoint.getLine2ndRW() != null) {
            anchoringContributors.add(this.secondPoint.getLine2ndRW());
        }
        return anchoringContributors;
    }

    @Override
    protected Collection getAnchoringDestinationContributors() {
        ArrayList<IAnchoringDestinationContributor> anchoringContributors = new ArrayList<IAnchoringDestinationContributor>(super.getAnchoringDestinationContributors());
        anchoringContributors.add(this.firstPoint);
        if (this.firstPoint.getLine1stRW() != null) {
            anchoringContributors.add(this.firstPoint.getLine1stRW());
        }
        anchoringContributors.add(this.secondPoint);
        if (this.secondPoint.getLine2ndRW() != null) {
            anchoringContributors.add(this.secondPoint.getLine2ndRW());
        }
        return anchoringContributors;
    }

    @Override
    public String toString() {
        return "ACMove3Points2Lines ()";
    }
}

