/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMReferenceGraphicalSupplementToFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ACCreateReference
extends Action {
    private final IPMGraphicalSupplementRW graphicalSupplement;
    private final IPMFigureRW figure;
    private final String role;
    private IPMReferenceGraphicalSupplementToFigureRW referenceGraphicalSupplementToFigure;
    private int indexFigure;
    private int indexGraSuppl;

    public ACCreateReference(ActionContext actionContext, IPMFigureRW figure, IPMGraphicalSupplementRW graphicalSupplement, String role) {
        super(actionContext);
        assert (figure != null) : "ref to figure is null";
        assert (graphicalSupplement != null) : "ref to graphicalSupplement is null";
        this.figure = figure;
        this.graphicalSupplement = graphicalSupplement;
        this.role = role;
    }

    @Override
    protected void initializeState() {
        assert (!this.checkForReference(this.figure, this.graphicalSupplement)) : "reference already exists";
        this.referenceGraphicalSupplementToFigure = this.getIPlanModelObjectFactoryRW().createPMReferenceGraphicalSupplementToFigureRW();
        this.referenceGraphicalSupplementToFigure.setFigure(this.figure);
        this.indexFigure = this.figure.getReferenceCount();
        this.referenceGraphicalSupplementToFigure.setGraphicalSupplement(this.graphicalSupplement);
        this.indexGraSuppl = this.graphicalSupplement.getReferenceCount();
        this.referenceGraphicalSupplementToFigure.setRole(this.role);
    }

    @Override
    protected void setStateToPost() {
        this.figure.addReference(this.referenceGraphicalSupplementToFigure, this.indexFigure);
        this.graphicalSupplement.addReference(this.referenceGraphicalSupplementToFigure, this.indexGraSuppl);
    }

    @Override
    protected void setStateToPre() {
        assert (this.figure.getReferenceIndex(this.referenceGraphicalSupplementToFigure) == this.indexFigure) : "reference is not at the expected index";
        this.figure.removeReference(this.indexFigure);
        assert (this.graphicalSupplement.getReferenceIndex(this.referenceGraphicalSupplementToFigure) == this.indexGraSuppl) : "refrence is not at the expected index";
        this.graphicalSupplement.removeReference(this.indexGraSuppl);
    }

    @Override
    public boolean isDupe(Action a) {
        ACCreateReference dupeA;
        boolean isDupe = false;
        if (a instanceof ACCreateReference && (dupeA = (ACCreateReference)a).getFigure() == this.getFigure() && dupeA.getGraphicalSupplement() == this.getGraphicalSupplement()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.referenceGraphicalSupplementToFigure, 1));
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.figure.getPlanElementRW();
    }

    public IPMFigureRW getFigure() {
        return this.figure;
    }

    public IPMGraphicalSupplementRW getGraphicalSupplement() {
        return this.graphicalSupplement;
    }

    public IPMReferenceGraphicalSupplementToFigureRW getReferenceGraphicalSupplementToFigure() {
        return this.referenceGraphicalSupplementToFigure;
    }

    public String toString() {
        return "ACCreateReference (figure " + this.figure + ", graphical supplement " + this.graphicalSupplement + ", role" + this.role + ")";
    }

    private boolean checkForReference(IPMFigureRW fig, IPMGraphicalSupplementRW supplement) {
        int i = 0;
        while (i < fig.getReferenceCount()) {
            if (fig.getReferenceRW(i).getGraphicalSupplementRW() != supplement) continue;
            return true;
        }
        return false;
    }
}

