/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;

public abstract class ACCreatePlanObject
extends Action {
    private final Points points;
    private final int[] force;
    private IPMPointListRW pointList;
    private boolean closedDraw;

    public ACCreatePlanObject(ActionContext actionContext, Points points, int[] force) {
        super(actionContext);
        assert (points != null) : "points is null";
        assert (force != null) : "force is null";
        assert (points.size() == force.length || points.size() == force.length + 1) : "it should be a closed line chain or an open line chain";
        assert (this.isForceArrayValid(force, points.size() == force.length)) : "in force array the line forces are not alternating or set to no forces";
        this.points = points;
        this.force = force;
    }

    @Override
    protected void initializeState() {
        this.initializePointList();
    }

    private void initializePointList() {
        this.pointList = this.getIPlanModelObjectFactoryRW().createPMPointListRW();
        this.pointList.setPlanObject(this.getPlanObject());
        this.closedDraw = this.points.size() == this.force.length;
        int lastPointIndex = this.points.size() - 1;
        IPMPointRW firstPoint = null;
        IPMPointRW prevPoint = null;
        int i = 0;
        while (i <= lastPointIndex) {
            IPMPointRW newPoint = this.createPMPointObject(this.points.get(i));
            if (i == 0) {
                firstPoint = newPoint;
            } else {
                this.createPMLineObject(this.force[i - 1], prevPoint, newPoint);
            }
            prevPoint = newPoint;
            ++i;
        }
        if (this.closedDraw && lastPointIndex > 0) {
            this.createPMLineObject(this.force[lastPointIndex], prevPoint, firstPoint);
        }
    }

    private IPMPointRW createPMPointObject(Point position) {
        IPMPointRW newPoint = this.getIPlanModelObjectFactoryRW().createPMPointRW();
        newPoint.setPointList(this.pointList);
        newPoint.setPosition(position);
        if (position instanceof Corner) {
            Corner corner = (Corner)position;
            if (corner.radiusInfinity) {
                newPoint.setCornerRadiusInfinity();
            } else {
                newPoint.setCornerRadius(corner.radius);
            }
        } else {
            newPoint.setCornerRadiusInherited();
        }
        this.pointList.addPoint(newPoint, this.pointList.getPointCount());
        return newPoint;
    }

    private void createPMLineObject(int lineForce, IPMPointRW prevPoint, IPMPointRW succPoint) {
        IPMLineRW newLine = this.getIPlanModelObjectFactoryRW().createPMLineRW();
        newLine.setPointList(this.pointList);
        newLine.setPoint1st(prevPoint);
        newLine.setPoint2nd(succPoint);
        newLine.setForce(lineForce);
        prevPoint.setLine2nd(newLine);
        succPoint.setLine1st(newLine);
        this.pointList.addLine(newLine, this.pointList.getLineCount());
    }

    private boolean isForceArrayValid(int[] forces, boolean closeDraw) {
        boolean noForcesAtAll = true;
        int[] nArray = forces;
        int n = forces.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (element != 1) {
                noForcesAtAll = false;
                break;
            }
            ++n2;
        }
        if (noForcesAtAll) {
            return true;
        }
        boolean isAlternating = true;
        int newForce = 0;
        if (forces.length > 1) {
            int prevForce;
            int firstForce = prevForce = forces[0];
            int i = 1;
            while (i < forces.length) {
                newForce = forces[i];
                if (prevForce == newForce) {
                    if (prevForce == 1) {
                        prevForce = newForce;
                        ++i;
                        continue;
                    }
                    isAlternating = false;
                    break;
                }
                prevForce = newForce;
                ++i;
            }
            if (closeDraw && isAlternating && firstForce == newForce) {
                isAlternating = false;
            }
        }
        return isAlternating;
    }

    public abstract IPMPlanObjectRW getPlanObject();

    public int[] getForce() {
        return this.force;
    }

    public IPMPointListRW getPointList() {
        return this.pointList;
    }

    public Points getPoints() {
        return this.points;
    }
}

