/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectFactoryException;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ACCreatePlanElement
extends Action {
    private final IPMPlanRW plan;
    private final String planElementTypeID;
    private IPMPlanElementRW planElement;

    public ACCreatePlanElement(ActionContext actionContext, IPMPlanRW plan, String planElementTypeID) {
        super(actionContext);
        assert (plan != null) : "ref to plan is null";
        this.plan = plan;
        this.planElementTypeID = planElementTypeID;
        try {
            this.planElement = this.getIPlanModelObjectFactoryRW().createPMPlanElementRW(planElementTypeID);
        }
        catch (EXPlanModelObjectFactoryException e) {
            this.setInvalid();
        }
    }

    @Override
    protected void initializeState() {
        this.planElement.setPlan(this.plan);
    }

    @Override
    public boolean isDupe(Action a) {
        return false;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    @Override
    protected void setStateToPre() {
        assert (this.plan.getPlanElementIndex(this.planElement) == this.plan.getPlanElementCount() - 1) : "planelement is not at the expected index";
        this.plan.removePlanElement(this.plan.getPlanElementCount() - 1);
    }

    @Override
    protected void setStateToPost() {
        this.plan.addPlanElement(this.planElement, this.plan.getPlanElementCount());
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.planElement, 1));
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        ArrayList<IPMFigureRW> createdFigures = new ArrayList<IPMFigureRW>();
        ArrayList<IPMGraphicalSupplementRW> createdSupplements = new ArrayList<IPMGraphicalSupplementRW>();
        IPMPlanElementRW pe = this.getCreatedPlanElement();
        int i = 0;
        while (i < pe.getFigureCount()) {
            IPMFigureRW figure = pe.getFigureRW(i);
            createdFigures.add(figure);
            int j = 0;
            while (j < figure.getGraphicalSupplementCount()) {
                createdSupplements.add(figure.getGraphicalSupplementRW(j));
                ++j;
            }
            ++i;
        }
        HashSet<IEntryOfCompressedList> reactions = new HashSet<IEntryOfCompressedList>();
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionCreateFigureAgent().getEntryForCompressedList(createdFigures, this.getActionContext()));
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionCreateSupplementAgent().getEntryForCompressedList(createdSupplements, this.getActionContext()));
        return reactions;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.plan;
    }

    public IPMPlanElementRW getCreatedPlanElement() {
        return this.planElement;
    }

    public String toString() {
        return "ACCreatePlanElement (plan " + this.plan + ", plan element type ID " + this.planElementTypeID + ")";
    }
}

