/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACCreatePlanObject;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class ACCreateGraphicalSupplement
extends ACCreatePlanObject {
    private final IPMFigureRW figure;
    private final String role;
    private int index;

    public ACCreateGraphicalSupplement(ActionContext actionContext, Points points, int[] force, IPMFigureRW figure, String role) {
        super(actionContext, points, force);
        assert (figure != null) : "ref to figure is null";
        this.figure = figure;
        this.role = role;
    }

    @Override
    protected void initializeState() {
        super.initializeState();
        this.getGraphicalSupplement().setFigure(this.figure);
        this.index = this.figure.getGraphicalSupplementCount();
        this.getGraphicalSupplement().setPointList(this.getPointList());
        this.getGraphicalSupplement().setRole(this.role);
    }

    @Override
    protected void setStateToPost() {
        this.figure.addGraphicalSupplement(this.getGraphicalSupplement(), this.index);
    }

    @Override
    protected void setStateToPre() {
        assert (this.index == this.figure.getGraphicalSupplementIndex(this.getGraphicalSupplement())) : "the graphical supplement is not at the expected index";
        this.figure.removeGraphicalSupplement(this.index);
    }

    public abstract IPMGraphicalSupplementRW getGraphicalSupplement();

    public IPMFigureRW getFigure() {
        return this.figure;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.getFigure().getPlanElementRW();
    }

    @Override
    public boolean isNop() {
        return false;
    }

    public String getRole() {
        return this.role;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    @Override
    public Collection<IEntryOfCompressedList> getEntriesForCompressedReactionList() {
        HashSet<IEntryOfCompressedList> reactions = new HashSet<IEntryOfCompressedList>();
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionCreateSupplementAgent().getEntryForCompressedList(Collections.singletonList(this.getGraphicalSupplement()), this.getActionContext()));
        return reactions;
    }
}

