/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigure;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import java.util.HashSet;
import java.util.Set;

public class ACCreateFigureLineShape
extends ACCreateFigure {
    private final ILineMarkerAppearanceRO start;
    private final ILineMarkerAppearanceRO end;
    private IPMFigureLineShapeRW figureLineShape;

    public ACCreateFigureLineShape(ActionContext context, String role, IPMPlanElementRW planElement, Points points, int[] force, ILineAppearanceRO lineAppearance, ILineMarkerAppearanceRO start, ILineMarkerAppearanceRO end, boolean backgroundFigure) {
        super(context, role, planElement, points, force, lineAppearance, backgroundFigure);
        assert (points.size() == force.length + 1) : "it should be an open line chain";
        assert (start != null) : "ref to start style is null";
        this.start = start;
        assert (end != null) : "ref to end style is null";
        this.end = end;
    }

    @Override
    protected void initializeState() {
        this.figureLineShape = this.getIPlanModelObjectFactoryRW().createPMFigureLineShapeRW();
        super.initializeState();
        LineMarkerAppearance.copy(this.start, this.figureLineShape.getLineStartMarkerAppearanceRW());
        LineMarkerAppearance.copy(this.end, this.figureLineShape.getLineEndMarkerAppearanceRW());
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.figureLineShape, 1));
        return changes;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    @Override
    public boolean isDupe(Action a) {
        ACCreateFigureLineShape dupeA;
        boolean isDupe = false;
        if (a instanceof ACCreateFigureLineShape && (dupeA = (ACCreateFigureLineShape)a).getStart() == this.getStart() && dupeA.getEnd() == this.getEnd() && dupeA.getRole().equals(this.getRole()) && dupeA.getLineAppearance() == this.getLineAppearance() && dupeA.getPlanElement() == this.getPlanElement() && dupeA.getPoints() == this.getPoints() && dupeA.getForce() == this.getForce()) {
            isDupe = true;
        }
        return isDupe;
    }

    public ILineMarkerAppearanceRO getEnd() {
        return this.end;
    }

    public ILineMarkerAppearanceRO getStart() {
        return this.start;
    }

    @Override
    public IPMFigureRW getFigure() {
        return this.figureLineShape;
    }

    @Override
    public IPMPlanObjectRW getPlanObject() {
        return this.figureLineShape;
    }

    public String toString() {
        return "ACCreateFigureLineShape (start " + this.start + ", end " + this.end + ")";
    }
}

