/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACCreatePlanObject;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class ACCreateFigure
extends ACCreatePlanObject {
    private final String role;
    private final IPMPlanElementRW planElement;
    private final ILineAppearanceRO lineAppearance;
    private final boolean backgroundFigure;

    public ACCreateFigure(ActionContext context, String role, IPMPlanElementRW planElement, Points points, int[] force, ILineAppearanceRO lineAppearance, boolean backgroundFigure) {
        super(context, points, force);
        this.role = role;
        assert (planElement != null) : "ref to planElement is null";
        this.planElement = planElement;
        assert (lineAppearance != null) : "ref to lineAppearance is null";
        this.lineAppearance = lineAppearance;
        this.backgroundFigure = backgroundFigure;
    }

    @Override
    protected void initializeState() {
        super.initializeState();
        this.initializeFigure(this.getFigure());
    }

    private void initializeFigure(IPMFigureRW figure) {
        figure.setRole(this.role);
        figure.setPlanElement(this.planElement);
        figure.setPointList(this.getPointList());
        LineAppearance.copy(this.lineAppearance, figure.getLineAppearanceRW());
    }

    @Override
    protected void setStateToPre() {
        if (this.backgroundFigure) {
            assert (this.planElement.getFigureIndex(this.getFigure()) == 0) : "figure is not at the expected index";
            this.planElement.removeFigure(0);
        } else {
            assert (this.planElement.getFigureIndex(this.getFigure()) == this.planElement.getFigureCount() - 1) : "figure is not at the expected index";
            this.planElement.removeFigure(this.planElement.getFigureCount() - 1);
        }
    }

    @Override
    protected void setStateToPost() {
        if (this.backgroundFigure) {
            this.planElement.addFigure(this.getFigure(), 0);
        } else {
            this.planElement.addFigure(this.getFigure(), this.planElement.getFigureCount());
        }
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.planElement;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    public abstract IPMFigureRW getFigure();

    public ILineAppearanceRO getLineAppearance() {
        return this.lineAppearance;
    }

    public IPMPlanElementRW getPlanElement() {
        return this.planElement;
    }

    public String getRole() {
        return this.role;
    }

    public Collection getEntriesForCompressedReactionList() {
        ArrayList<IPMFigureRW> createdFigures = new ArrayList<IPMFigureRW>(1);
        createdFigures.add(this.getFigure());
        return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionCreateFigureAgent().getEntryForCompressedList(createdFigures, this.getActionContext()));
    }
}

