/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoringPoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import java.util.HashSet;
import java.util.Set;

public class ACCreateAnchoringPointToLine
extends ACCreateAnchoringPoint {
    private final IPMLineRW line;
    private IPMAnchoringPointToLineRW anchoringPointToLine;

    public ACCreateAnchoringPointToLine(ActionContext actionContext, IPMPointRW point, IPMLineRW line) {
        super(actionContext, point);
        assert (line != null) : "ref to line is null";
        this.line = line;
    }

    @Override
    protected void initializeState() {
        this.anchoringPointToLine = this.getIPlanModelObjectFactoryRW().createPMAnchoringPointToLineRW();
        super.initializeState();
        this.anchoringPointToLine.setTargetLine(this.line);
    }

    @Override
    protected void setStateToPost() {
        super.setStateToPost();
        this.line.addPointToLineAnchoring(this.anchoringPointToLine, this.line.getPointToLineAnchoringCount());
    }

    @Override
    protected void setStateToPre() {
        super.setStateToPre();
        assert (this.line.getPointToLineAnchoringIndex(this.anchoringPointToLine) == this.line.getPointToLineAnchoringCount() - 1) : "anchoring is not at the expected index";
        this.line.removePointToLineAnchoring(this.line.getPointToLineAnchoringCount() - 1);
    }

    @Override
    public boolean isDupe(Action a) {
        ACCreateAnchoringPointToLine dupeA;
        boolean isDupe = false;
        if (a instanceof ACCreateAnchoringPointToLine && (dupeA = (ACCreateAnchoringPointToLine)a).getPoint() == this.getPoint() && dupeA.getLine() == this.getLine()) {
            isDupe = true;
        }
        return isDupe;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.anchoringPointToLine, 1));
        return changes;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        assert (this.getPoint().getPlanElementRW().getPlanRW() == this.line.getPlanElementRW().getPlanRW()) : "the plan should be unique";
        return this.getPoint().getPlanElementRW().getPlanRW();
    }

    public IPMLineRW getLine() {
        return this.line;
    }

    @Override
    public IPMAnchoringPointRW getAnchoringPoint() {
        return this.anchoringPointToLine;
    }

    public String toString() {
        return "ACCreateAnchoringPointToLine (line " + this.line + ")";
    }
}

