/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoringPoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import java.util.HashSet;
import java.util.Set;

public class ACCreateAnchoringPointToFigure
extends ACCreateAnchoringPoint {
    private final IPMFigureRW figure;
    private IPMAnchoringPointToFigureRW anchoringPointToFigure;

    public ACCreateAnchoringPointToFigure(ActionContext actionContext, IPMPointRW point, IPMFigureRW figure) {
        super(actionContext, point);
        assert (figure != null) : "ref to figure is null";
        this.figure = figure;
    }

    @Override
    protected void initializeState() {
        this.anchoringPointToFigure = this.getIPlanModelObjectFactoryRW().createPMAnchoringPointToFigureRW();
        super.initializeState();
        this.anchoringPointToFigure.setFigure(this.figure);
    }

    @Override
    protected void setStateToPost() {
        super.setStateToPost();
        this.figure.addAnchoring(this.anchoringPointToFigure, this.figure.getAnchoringCount());
    }

    @Override
    protected void setStateToPre() {
        super.setStateToPre();
        assert (this.figure.getAnchoringIndex(this.anchoringPointToFigure) == this.figure.getAnchoringCount() - 1) : "anchoring is not at the expected index";
        this.figure.removeAnchoring(this.figure.getAnchoringCount() - 1);
    }

    @Override
    public boolean isDupe(Action a) {
        ACCreateAnchoringPointToFigure dupeA;
        boolean isDupe = false;
        if (a instanceof ACCreateAnchoringPointToFigure && (dupeA = (ACCreateAnchoringPointToFigure)a).getPoint() == this.getPoint() && dupeA.getFigure() == this.getFigure()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        assert (this.getPoint().getPlanElementRW().getPlanRW() == this.figure.getPlanElementRW().getPlanRW()) : "the plan should be unique";
        return this.getPoint().getPlanElementRW().getPlanRW();
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.anchoringPointToFigure, 1));
        return changes;
    }

    public IPMFigureRW getFigure() {
        return this.figure;
    }

    @Override
    public IPMAnchoringPointRW getAnchoringPoint() {
        return this.anchoringPointToFigure;
    }

    public String toString() {
        IPMPointRW point;
        String text = "ACCreateAnchoringPointToFigure ()";
        if (this.figure != null) {
            text = String.valueOf(text) + ", Figure: " + this.figure;
        }
        if ((point = this.getPoint()) != null) {
            text = String.valueOf(text) + ", Point: " + point;
        }
        if (this.figure != null) {
            text = String.valueOf(text) + ", anchorings to figure: ";
            int i = 0;
            while (i < this.figure.getAnchoringCount()) {
                IPMPointRW ap = this.figure.getAnchoringRW(i).getPointRW();
                text = String.valueOf(text) + ", " + ap;
                ++i;
            }
        }
        return text;
    }
}

